package org.gcube.common.homelibrary.jcr.workspace;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;

import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;

import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.events.AbstractWorkspaceEventSource;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.TabularDataLink.Provenance;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.ImageDocumentLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.PDFDocumentLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItemByOperator;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.sharing.JCRWorkspaceMessageManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRAquaMapsItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalUrl;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRGCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRQuery;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReportTemplate;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRTabularDataLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRTimeSeries;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkflowReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkflowTemplate;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRAnnotation;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRExternalResourceLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRImageDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRMetadata;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRPDFDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRUrlDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.link.JCRImageDocumentLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.link.JCRPDFDocumentLink;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolder;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceVREFolder;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.common.homelibrary.util.Util;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspace extends AbstractWorkspaceEventSource implements
Workspace {

	public static final String HOME_FOLDER 						= "Home";
	private static final String WORKSPACE_ROOT_FOLDER 			= "Workspace";
	private static final String APPLICATION_FOLDER 				= ".applications";
	private static final String TRASH	 						= "Trash";
	private static final String SPECIAL_FOLDER 					= "MySpecialFolders";

	public static final String NT_WORKSPACE_TRASH				= "nthl:trashFolder";
	public static final String NT_WORKSPACE_FOLDER 				= "nthl:workspaceItem";
	public static final String NT_WORKSPACE_SHARED_FOLDER		= "nthl:workspaceSharedItem";
	public static final String NT_WORKSPACE_VRE_FOLDER			= "nthl:workspaceVreItem";
	public static final String NT_WORKSPACE_FOLDER_ITEM			= "nthl:workspaceLeafItem";
	public static final String NT_WORKSPACE_FILE 				= "nthl:externalFile";
	public static final String NT_WORKSPACE_IMAGE 				= "nthl:externalImage";
	public static final String NT_WORKSPACE_PDF_FILE 			= "nthl:externalPdf";
	public static final String NT_WORKSPACE_URL 				= "nthl:externalUrl";

	public static final String NT_WORKSPACE_REPORT				= "nthl:report";
	public static final String NT_WORKSPACE_REPORT_TEMPLATE		= "nthl:reportTemplate"; 
	public static final String NT_WORKSPACE_WORKFLOW_REPORT		= "nthl:workflowReport";
	public static final String NT_WORKSPACE_WORKFLOW_TEMPLATE	= "nthl:workflowTemplate";

	public static final String NT_ANNOTATION_ITEM				= "nthl:gCubeAnnotation";
	public static final String NT_ANNOTATION_LINK_ITEM			= "nthl:gCubeAnnotationLink";

	public static final String NT_DOCUMENT_ITEM 				= "nthl:gCubeDocument";
	public static final String NT_DOCUMENT_LINK_ITEM			= "nthl:gCubeDocumentLink";
	public static final String NT_IMAGE_DOCUMENT_ITEM 			= "nthl:gCubeImageDocument";
	public static final String NT_IMAGE_DOCUMENT_LINK_ITEM 		= "nthl:gCubeImageDocumentLink";
	public static final String NT_PDF_DOCUMENT_ITEM 			= "nthl:gCubePDFDocument";
	public static final String NT_PDF_DOCUMENT_LINK_ITEM		= "nthl:gCubePDFDocumentLink";
	public static final String NT_URL_DOCUMENT_ITEM 			= "nthl:gCubeURLDocument";
	public static final String NT_METADATA_ITEM					= "nthl:gCubeMetadata";				
	public static final String NT_METADATA_LINK_ITEM			= "nthl:gCubeMetadataLink";
	public static final String NT_AQUAMAPS_ITEM 				= "nthl:aquamapsItem";
	public static final String NT_GCUBE_ITEM 					= "nthl:gCubeItem";
	public static final String NT_TIMESERIES_ITEM 				= "nthl:timeSeriesItem";
	public static final String NT_QUERY 						= "nthl:query";
	public static final String NT_EXTERNAL_RESOURCE_LINK_ITEM   = "nthl:externalResourceLink";
	public static final String NT_TABULAR_DATA_LINK				= "nthl:tabularDataLink";
	public static final String NT_TRASH_ITEM 					= "nthl:trashItem";

	private static final String NT_FILE 						= "nt:file";
	//	private static final String NT_FOLDER 						= "nt:folder";

	private static final String CONTENT							= "jcr:content";
	private static final String LAST_MODIFIED 					= "jcr:lastModified";
	private static final String LAST_MODIFIED_BY 				= "jcr:lastModifiedBy";
	private static final String LAST_ACTION 					= "hl:lastAction";
	private static final String SIZE							= "hl:size";

	public static final String USERS 							= "hl:users";
	public static final String MEMBERS 							= "hl:members";
	private static final String PREFIX_SHARE 					= "/Share/";
	private static final String PREFIX 							= "home/org.gcube.portlets.user/";


	private final Home home;
	public final JCRRepository repository;
	private final JCRFolderBulkCreatorManager folderBulkCreatorsManager;

	private JCRWorkspaceMessageManager sendRequestManager;

	public String portalLogin;

	public String wsRootPath;
	private String userHomePath;

	public String trashPath;
	public String applicationFolderPath;
	public String mySpecialFoldersPath;

	private JCRWorkspaceFolder root;
	public JCRWorkspaceFolder applicationFolder;
	public JCRWorkspaceFolder trashFolder;
	public JCRWorkspaceFolder mySpecialFolders;

	private Logger logger;

	public JCRWorkspace(Home home, JCRRepository repository) throws InternalErrorException {

		this.home = home;

		this.portalLogin = getOwner().getPortalLogin();

		this.userHomePath = JCRRepository.PATH_SEPARATOR + HOME_FOLDER + JCRRepository.PATH_SEPARATOR + portalLogin;
		this.wsRootPath = userHomePath + JCRRepository.PATH_SEPARATOR + WORKSPACE_ROOT_FOLDER + JCRRepository.PATH_SEPARATOR;

		this.applicationFolderPath = wsRootPath + APPLICATION_FOLDER;
		this.trashPath = wsRootPath + TRASH;	
		this.mySpecialFoldersPath = wsRootPath + SPECIAL_FOLDER;

		this.repository = repository;
		this.folderBulkCreatorsManager = new JCRFolderBulkCreatorManager(this);

		this.logger = LoggerFactory.getLogger(JCRWorkspace.class);

		try {
			init(portalLogin);
		} catch (RepositoryException e1) {
			logger.error("Error init ", e1);
		}

		Session session = JCRRepository.getSession();
		try {
			logger.info("Getting Workspace: " + wsRootPath);
			Node wsNode = session.getNode(wsRootPath);
			this.root = new JCRWorkspaceFolder(this, wsNode);			

		} catch (RepositoryException e) {
			logger.error("Root WorkspaceFolder not found", e);
			throw new InternalErrorException(e);
		} finally {
			if(session != null)
				session.logout();
		}

		//		System.out.println("root path: " + wsRootPath);

	}



	public JCRWorkspace(JCRHome home) {
		this.home = home;
		this.repository = null;
		this.folderBulkCreatorsManager = null;
	}

	private Node addChildNode(Session session, String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException,
	WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {

		Validate.notNull(parentId, "Destination folder must be not null");
		Validate.notNull(nodeName, "Name must be not null");

		if (!isValidName(nodeName)){

			logger.error("The name  " + nodeName + "contains illegal chars or is empty");
			throw new IllegalArgumentException("The name contains illegal chars or is empty");
		}

		Node parent;
		try {
			parent = session.getNodeByIdentifier(parentId);

			WorkspaceItem item = getWorkspaceItem(parent);

			//check ACL
			if(item.isShared()){
				if (!JCRPrivilegesInfo.canAddChildren(item.getOwner().getPortalLogin(), getOwner().getPortalLogin(), parent.getPath()))
					throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
			}

			if(!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) &&
					!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER) &&
					// FIXME item send functionality: copied NT_WORKSPACE_SHARED_FOLDER
					// items on "hl:attachments" node with type "nt:folder"
					!parent.getPrimaryNodeType().getName().equals("nt:folder")) {

				throw new WrongDestinationException("Not is a folder");
			}
		} catch (RepositoryException e) {
			logger.error("Destination folder not found");
			throw new WorkspaceFolderNotFoundException(e.getMessage());
		}

		try {
			String name = Text.escapeIllegalJcrChars(nodeName);
			Node node = parent.addNode(name, nodeType);
			return node;
		} catch (ItemExistsException e) {
			logger.error("Item already exist");
			throw new ItemAlreadyExistException(e.getMessage());
		} catch (RepositoryException e) {
			logger.error("Error ",e);
			throw new InternalErrorException(e);
		}
	}


	@Override
	public String getPathSeparator() {
		return JCRRepository.PATH_SEPARATOR;
	}

	@Override
	public Home getHome() {
		return home;
	}

	public JCRRepository getRepository() {
		return repository;
	}

	@Override
	public User getOwner() {
		return home.getOwner();
	}

	@Override
	public WorkspaceFolder getRoot() {

		return root;
	}


	@Override
	public WorkspaceFolder createFolder(String name, String description,
			String destinationFolderId) throws InternalErrorException,
			InsufficientPrivilegesException, ItemAlreadyExistException,
			WrongDestinationException, ItemNotFoundException,
			WorkspaceFolderNotFoundException {

		logger.trace("Create workspace folder");

		Session session = JCRRepository.getSession();
		Node parent;
		try {
			parent = session.getNodeByIdentifier(destinationFolderId);

			JCRWorkspaceItem destinationFolder = (JCRWorkspaceItem) getItem(destinationFolderId);

			//check ACL
			if(destinationFolder.isShared()){
				//				System.out.println("the item is shared: " + destinationFolder.getPath() + " - parent.getPath(): " + parent.getPath());
				//				System.out.println("getOwner().getPortalLogin(): " + getOwner().getPortalLogin());
				if (!JCRPrivilegesInfo.canAddChildren(destinationFolder.getOwner().getPortalLogin(), getOwner().getPortalLogin(), parent.getPath()))
					throw new InsufficientPrivilegesException("Insufficient Privileges to add the folder");
			}

			Node node = addChildNode(session,destinationFolderId,name,NT_WORKSPACE_FOLDER);		
			JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, node, name, description);
			folder.save(node);

			session.save();	
			try{

				// Set add accounting entry to parent folder
				logger.info(name + " has been added to parent folder " + node.getParent().getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), folder.getType(),
						(folder.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)folder).getFolderItemType():null,
								folder.getName(),
								(folder.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)folder).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.error("Error setting add accounting entry for " + name + " to parent folder " + node.getParent().getPath());
			}

			fireItemCreatedEvent(folder);

			return folder;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}


	}

	@Override
	public ExternalImage createExternalImage(String name, String description,
			String mimeType, InputStream imageData, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create external image");
		//		long time4 = System.nanoTime();
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_IMAGE);
			JCRExternalImage item =  new JCRExternalImage(this, node, name, description, mimeType, imageData);
			item.save(node);
			session.save();	
			//			long time45 = System.nanoTime();
			try{
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());
				// Set add accounting entry to parent folder
				logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
			}
			//			System.out.println("create entry accounting: "+(System.nanoTime()-time45)+" ns");
			fireItemCreatedEvent(item);
			//			System.out.println("create item: "+(System.nanoTime()-time4)+" ns");
			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public ExternalImage createExternalImage(String name, String description,
			String mimeType,String destinationFolderId, File tmpFile)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create external image");
		//		long time4 = System.nanoTime();
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_IMAGE);
			JCRExternalImage item =  new JCRExternalImage(this, node, name, description, mimeType, tmpFile);
			item.save(node);
			session.save();	
			//			long time45 = System.nanoTime();
			try{
				// Set add accounting entry to parent folder
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());	
				logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
			}
			//			System.out.println("create entry accounting: "+(System.nanoTime()-time45)+" ns");
			fireItemCreatedEvent(item);
			//			System.out.println("create item: "+(System.nanoTime()-time4)+" ns");
			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public ExternalFile createExternalFile(String name, String description,
			String mimeType, InputStream fileData, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create external file");
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FILE);		

			JCRExternalFile item = new JCRExternalFile(this,node,name,description,mimeType,fileData);
			item.save(node);
			session.save();	
			setAccountingOnParent(node, item, session);
			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public ExternalFile createExternalFile(String name, String description,
			String mimeType, File tmpFile, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create external file");
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FILE);		

			JCRExternalFile item = new JCRExternalFile(this,node,name,description,mimeType,tmpFile);
			item.save(node);
			session.save();	
			setAccountingOnParent(node, item, session);
			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}


	private void setAccountingOnParent(Node node, JCRExternalFile item, Session session) throws InternalErrorException, RepositoryException {
		try{
			JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());
			// Set add accounting entry to parent folder
			logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
			destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
					Calendar.getInstance(), item.getType(),
					(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
							item.getName(),
							(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
			session.save();	

		}catch (Exception e) {
			logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
		}

		fireItemCreatedEvent(item);

	}


	@Override
	public ExternalPDFFile createExternalPDFFile(String name,
			String description, String mimeType, File tmpFile,
			String destinationFolderId) throws InsufficientPrivilegesException,
			WorkspaceFolderNotFoundException, InternalErrorException,
			ItemAlreadyExistException, WrongDestinationException {	
		logger.trace("Create external pdf file");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_PDF_FILE);
			JCRExternalPDFFile item =  new JCRExternalPDFFile(this, node, name, description, mimeType,
					tmpFile);
			item.save(node);
			session.save();	
			try{
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());
				// Set add accounting entry to parent folder
				logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
			}
			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}


	@Override
	public ExternalPDFFile createExternalPDFFile(String name,
			String description, String mimeType, InputStream fileData,
			String destinationFolderId) throws InsufficientPrivilegesException,
			WorkspaceFolderNotFoundException, InternalErrorException,
			ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create external pdf file");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_PDF_FILE);
			JCRExternalPDFFile item =  new JCRExternalPDFFile(this, node, name, description, mimeType,
					fileData);
			item.save(node);
			session.save();	
			try{
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());
				// Set add accounting entry to parent folder
				logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
			}
			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}



	@Override
	public ExternalUrl createExternalUrl(String name, String description,
			String url, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException{

		logger.trace("Create external url");
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_URL);
			JCRExternalUrl item = new JCRExternalUrl(this, node, name, description, url);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}


	@Override
	public ExternalUrl createExternalUrl(String name, String description,
			File tmpFile, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException{

		logger.trace("Create external url");
		Session session = JCRRepository.getSession();
		FileInputStream fileData = null;
		try {

			return createExternalUrl(name, description,
					fileData, destinationFolderId);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
			if (fileData!=null)
				try {
					fileData.close();
				} catch (IOException e) {}
		}

	}

	@Override
	public ExternalUrl createExternalUrl(String name, String description,
			InputStream url, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException{

		String urlString;
		try {
			urlString = Util.readStreamAsString(url);
		} catch (IOException e) {
			throw new InternalErrorException("Error converting url from" +
					" input stream to string.");
		}
		return createExternalUrl(name, description, urlString, destinationFolderId);
	}

	@Override
	public ReportTemplate createReportTemplate(String name, String description,
			Calendar created, Calendar lastEdit, String author,
			String lastEditBy, int numberOfSections, String status,
			InputStream templateData, String destinationfolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Created report template");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT_TEMPLATE);
			JCRReportTemplate reportTemplate = new JCRReportTemplate(this, node, name, description,
					created, lastEdit, author, lastEditBy, numberOfSections, status, templateData);

			reportTemplate.save(node);

			session.save();	
			try{
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());
				// Set add accounting entry to parent folder
				logger.info(reportTemplate.getPath() + " has been added to parent folder " + node.getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), reportTemplate.getType(),
						(reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)reportTemplate).getFolderItemType():null,
								reportTemplate.getName(),
								(reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)reportTemplate).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.info("Error setting add accounting entry for " + reportTemplate.getPath() + " to parent folder " + node.getPath());
			}

			fireItemCreatedEvent(reportTemplate);
			return reportTemplate;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}


	@Override
	public Report createReport(String name, String description,
			Calendar created, Calendar lastEdit, String author,
			String lastEditBy, String templateName, int numberOfSections,
			String status, InputStream reportData, String destinationfolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create report");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT);
			JCRReport item = new JCRReport(this,node,name,description,created,lastEdit,
					author,lastEditBy,templateName,numberOfSections,status,reportData);
			item.save(node);
			session.save();	
			try{
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(node.getParent());
				// Set add accounting entry to parent folder
				logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
				session.save();	
			}catch (Exception e) {
				logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
			}

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public Query createQuery(String name, String description, String query,
			QueryType queryType, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create query");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_QUERY);
			JCRQuery item = new JCRQuery(this, node, name, description, query, queryType);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public Query createQuery(String name, String description,
			InputStream query, QueryType queryType, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		try {
			return createQuery(name,description,Util.readStreamAsString(query),queryType,destinationFolderId);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public WorkspaceFolder createAquaMapsItem(String name, String description,
			String mapName, String mapType, String author, int numberOfSpecies,
			String boundingBox, float psoThreshold,
			int numberOfGeneratedImages, InputStream metadata,
			Map<String, InputStream> images, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create aquamaps item");

		Session session = JCRRepository.getSession();		
		JCRWorkspaceFolder folder;
		try {
			Node node = addChildNode(session,destinationFolderId,name,NT_WORKSPACE_FOLDER);		
			folder = new JCRWorkspaceFolder(this, node, name, 
					description);
			folder.save(node);

			String fileName = folder.getUniqueName("metadata.xml", false);

			Node nodeFile = addChildNode(session, node.getIdentifier(),fileName, NT_WORKSPACE_FILE);
			JCRExternalFile file = new JCRExternalFile(this,nodeFile,fileName,name + " metadata","text/xml",metadata);
			file.save(nodeFile);

			fireItemCreatedEvent(file);
			for(Entry<String, InputStream> entry : images.entrySet()) {

				String imageName = Text.escapeIllegalJcrChars(entry.getKey());
				Node imageNode = addChildNode(session, node.getIdentifier(), imageName, NT_WORKSPACE_IMAGE);
				JCRExternalImage image = new JCRExternalImage(this, imageNode, imageName, description, "", entry.getValue());
				image.save(imageNode);



				fireItemCreatedEvent(image);
			}


		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (IOException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

		return folder;		

	}

	@Override
	public Annotation createAnnotation(String name, String description,
			String oid, Map<String, String> data, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WorkspaceFolderNotFoundException {

		logger.trace("Create annotation item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session ,destinationFolderId, name, NT_ANNOTATION_ITEM);
			JCRAnnotation item = new JCRAnnotation(this, node, name, description,
					oid,data);
			item.save(node);

			fireItemCreatedEvent(item);


			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public Metadata createMetadata(String name, String description, String oid,
			String schema, String language, String data, String collectionName,
			String destinationFolderId) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException,
			WrongDestinationException, WorkspaceFolderNotFoundException {

		logger.trace("Create metadata item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_METADATA_ITEM);
			JCRMetadata item = new JCRMetadata(this,node,name,description,oid,schema,
					language,collectionName,data);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public Document createDocument(String name, String description, String oid,
			String mimeType, InputStream documentData,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create document item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_DOCUMENT_ITEM);
			JCRDocument item = new JCRDocument(this, node, name, description, oid, mimeType,
					documentData, metadata, annotations, collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public ImageDocument createImageDocument(String name, String description,
			String oid, String mimeType, InputStream imageData,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create image document item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_ITEM);
			JCRImageDocument item = new JCRImageDocument(this, node, name, description, 
					oid, mimeType,imageData, metadata, annotations, collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public PDFDocument createPDFDocument(String name, String description,
			String oid, String mimeType, InputStream data,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create pdf document item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_ITEM);
			JCRPDFDocument	item = new JCRPDFDocument(this,node,name,description,oid,
					mimeType,data,metadata,annotations,collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public UrlDocument createUrlDocument(String name, String description,
			String oid, String mimeType, InputStream documentData,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create url document item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_URL_DOCUMENT_ITEM);
			JCRUrlDocument	item = new JCRUrlDocument(this, node, name, description, oid, mimeType,
					documentData, metadata, annotations, collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public DocumentLink createDocumentLink(String name, String description,
			String oid, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName,
			String mimeType, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		logger.trace("Create document link item");
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_DOCUMENT_LINK_ITEM);
			JCRDocumentLink item = new JCRDocumentLink(this, node, name, description, oid,
					mimeType, metadata, annotations, collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public ImageDocumentLink createImageDocumentLink(String name,
			String description, String oid, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName,
			String mimeType, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_LINK_ITEM);
			JCRImageDocumentLink item = new JCRImageDocumentLink(this, node, name, description, oid,
					mimeType, metadata, annotations, collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public PDFDocumentLink createPDFDocumentLink(String name,
			String description, String oid, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName,
			String mimeType, String destinationFolderId)
					throws InsufficientPrivilegesException,
					WorkspaceFolderNotFoundException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException {

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_LINK_ITEM);
			JCRPDFDocumentLink item = new JCRPDFDocumentLink(this, node, name, description, oid,
					mimeType, metadata, annotations, collectionName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public TimeSeries createTimeSeries(String name, String description,
			String timeseriesId, String title, String creator,
			String timeseriesDescription, String timeseriesCreationDate,
			String publisher, String sourceId, String sourceName,
			String rights, long dimension, List<String> headerLabels,
			InputStream compressedCSV, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WorkspaceFolderNotFoundException,
					WrongDestinationException {

		logger.trace("Create TimeSeries item");
		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_TIMESERIES_ITEM);
			JCRTimeSeries item = new JCRTimeSeries(this, node, name, description,
					timeseriesId, title, creator, timeseriesDescription,
					timeseriesCreationDate, publisher, sourceId, sourceName,
					rights, dimension, headerLabels, compressedCSV);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkflowReport createWorkflowReport(String name, String description,
			String workflowId, String workflowStatus, String workflowData,
			String destinationFolderId) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException,
			WorkspaceFolderNotFoundException, WrongDestinationException {

		logger.trace("Create WorkflowReport item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_REPORT);
			JCRWorkflowReport item = new JCRWorkflowReport(this, node, name,
					description, workflowId, workflowStatus, workflowData);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkflowTemplate createWorkflowTemplate(String name,
			String description, String workflowId, String workflowStatus,
			String workflowData, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WorkspaceFolderNotFoundException,
					WrongDestinationException {

		logger.trace("Create WorkflowTemplate item");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_TEMPLATE);
			JCRWorkflowTemplate item = new JCRWorkflowTemplate(this, node, name,
					description, workflowId, workflowStatus, workflowData);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public ExternalResourceLink createExternalResourceLink(String name, String description,
			String mimeType, String resourceId, String pluginName, String destinationFolderId)
					throws  WorkspaceFolderNotFoundException, WrongDestinationException,
					InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException{

		logger.trace("Create service resource link");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_EXTERNAL_RESOURCE_LINK_ITEM);
			JCRExternalResourceLink item = new JCRExternalResourceLink(this, node, name, mimeType,
					description, resourceId, pluginName);
			item.save(node);

			fireItemCreatedEvent(item);

			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}




	@Override
	public void removeItem(String itemId) throws ItemNotFoundException,
	InternalErrorException, InsufficientPrivilegesException {


		Validate.notNull(itemId , "Item id must be not null");

		Session session = JCRRepository.getSession();
		//		LockManager lockManager = null;
		Node node = null;
		try {
			//			lockManager =  session.getWorkspace().getLockManager();

			node = session.getNodeByIdentifier(itemId);

			logger.trace("Remove node " + node.getPath());

			//			if (!node.isLocked()){

			//				Lock lock = lockManager.lock(node.getPath(), true, true, 0, "");
			//				logger.trace("LOCK on Node: " + lock.getNode().getPath());
			//				session.save();

			JCRWorkspaceItem item = (JCRWorkspaceItem) getItem(session,itemId);

			if(item.isShared()){
				logger.debug("the item is shared: " + node.getPath());
				if (!JCRPrivilegesInfo.canDelete(item.getOwner().getPortalLogin(), getOwner().getPortalLogin(), node.getPath(), false)) 
					throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node " + node.getPath());
			}
			JCRWorkspaceItem parent = (JCRWorkspaceItem)item.getParent();

			//Add removal accounting entry to folder item parent
			try{
				parent.addAccountingEntry(new JCRAccountingFolderEntryRemoval(getOwner().getPortalLogin(),
						Calendar.getInstance(),
						item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
			}catch (Exception e) {
				// the workspace root cannot be removed
			}

			fireItemRemovedEvent(getWorkspaceItem(node));
			//			LockManager lockManager = session.getWorkspace().getLockManager();
			//			lockManager.lock(absPath, isDeep, isSessionScoped, timeoutHint, ownerInfo)
			//				System.out.println("********** IS LOCKED? " + node.isLocked());
			//			item.remove();

			if(item.getType() == WorkspaceItemType.SHARED_FOLDER){
				try{			
					//call remove of WorkspaceSharedFolder
					item.remove();
				}catch (Exception e) {
					throw new InternalErrorException(e);
				}
			}else{
				moveToTrash(node);
			}

			//			}

		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException(e.getMessage());
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (ItemAlreadyExistException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} finally {

			//			try {
			//				if (lockManager.isLocked(node.getPath())){
			//					lockManager.unlock(node.getPath());
			//					logger.trace("Remove Lock from node: " + node.getPath());
			//				}
			//			} catch (RepositoryException e) {
			//				throw new InternalErrorException(e);
			//			}

			session.logout();

		}
	}


	//unlock a node
	public LockManager getLock(Node node) throws InternalErrorException {
		LockManager lockManager = null;
		try {	
			if (node.isLocked()){
				logger.trace(node.getPath() + " is locked");
				lockManager =  node.getSession().getWorkspace().getLockManager();

				Lock lock = null;
				try {
					logger.trace("getting lock");
					lock = lockManager.getLock(node.getPath());
				} catch (LockException ex) {                    
				}
				if (lock != null) {
					lockManager.addLockToken(lock.getLockToken());
					node.getSession().save();
					//						lockManager.unlock(node.getPath());
					//						System.out.println("UNLOCK");
				}
			}
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		}
		return lockManager;

	}

	public void moveToTrash(Node nodeToTrash) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, RepositoryException {
		Session session = nodeToTrash.getSession();		
		long length = 0;
		String mimeType = null;
		//		List<String> users = null;
		boolean isFolder = false;

		Node parentNode = nodeToTrash.getParent();
		String name = nodeToTrash.getName();

		String description = "move to trash " + nodeToTrash.getName();
		String parentId = parentNode.getIdentifier();

		String originalPath = null;

		try {

			JCRWorkspaceItem item = (JCRWorkspaceItem) getItem(session,nodeToTrash.getIdentifier());

			if (!(item.getType().equals(WorkspaceItemType.SHARED_FOLDER)) ){
				try{
					originalPath = item.getParent().getPath();
				}catch (Exception e) {

				}
			}

			if (item.getType().equals(WorkspaceItemType.FOLDER))
				isFolder = true;

			try{
				mimeType =((FolderItem)item).getMimeType();
			}catch (Exception e) {}
			try{
				length = ((FolderItem)item).getLength();
			}catch (Exception e) {}


			try {

				String trashId = session.getNode(trashPath).getIdentifier();
				//create a trash item
				Node trashNode = addChildNode(session, trashId, nodeToTrash.getIdentifier(), NT_TRASH_ITEM);	
				//copy files in trash folder
				JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this, trashNode, name, description, Calendar.getInstance(), getOwner().getPortalLogin(), parentId, mimeType, length, isFolder, originalPath);
//				trashItem.save(trashNode);				
				session.save();

				//move item in trash folder
				//				System.out.println("itemToTrash " + nodeToTrash.getPath());
				moveNodeTo(nodeToTrash, trashNode);

				//				System.out.println("originalPath: " + originalPath);
				//				if (originalPath==null)
				//					trashItem.deletePermanently();


			} catch (ItemAlreadyExistException
					| WorkspaceFolderNotFoundException
					| WrongDestinationException
					| InsufficientPrivilegesException e) {
				throw new InternalErrorException(e);
			} catch (ItemNotFoundException e) {
				throw new InternalErrorException(e);
			}	

			session.save();

		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			//			session.logout();
		}

	}


	private void checkDestination(Node node, Node destinationNode)  
			throws WrongDestinationException, InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException {

		try {	
			Session session = node.getSession();

			if (destinationNode.getPath().equals(trashPath))
				return;
			//			System.out.println("destinationNode.getPrimaryNodeType() " + destinationNode.getPrimaryNodeType().getName());
			if (!destinationNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) &&
					!destinationNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)&&
					!destinationNode.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM)) {

				logger.error("Destination is not a folder");
				throw new WrongDestinationException("Destination is not a folder");
			} 

			if (destinationNode.getPath().equals(mySpecialFoldersPath)) {
				//				logger.error("Not allowed to move files or folders in MySpecialFolders");
				throw new WrongDestinationException("Not allowed to move files or folders in Special Folders");
			} 

			JCRWorkspaceItem item = getWorkspaceItem(node);
			JCRWorkspaceItem itemDestination = getWorkspaceItem(destinationNode);

			QueryManager queryManager = session.getWorkspace().getQueryManager();
			//			System.out.println("item.getPath() " + item.getPath());
			//String query = "/jcr:root" + ISO9075.encodePath(node.getPath()) + "/" + ISO9075.encode(name);
			//			javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getOwner().getPortalLogin()
			//					+ ISO9075.encodePath(item.getPath()) +
			//					"//element(*,nthl:workspaceSharedItem)",
			//					javax.jcr.query.Query.XPATH);

			javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getOwner().getPortalLogin()
					+ ISO9075.encode(Text.escapeIllegalJcrChars(item.getPath())) +
					"//element(*,nthl:workspaceSharedItem)",
					javax.jcr.query.Query.XPATH);

			QueryResult result = q.execute();
			if (itemDestination.isShared() && !item.isShared() && result.getNodes().hasNext()
					|| (itemDestination.isShared() && (item.getType() == WorkspaceItemType.SHARED_FOLDER ))) {
				throw new WrongDestinationException("Not allowed to move in an other destination folder already shared");	 

			}			
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		}

	}

	@Override
	public WorkspaceItem moveItem(String itemId, String destinationFolderId)
			throws ItemNotFoundException, WrongDestinationException,
			InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException, WorkspaceFolderNotFoundException {

		logger.debug("Move item with id " + itemId + "to destination with id " + destinationFolderId);

		Validate.notNull(itemId , "Item id must be not null");
		Validate.notNull(destinationFolderId, "Destination folder id must be not null");

		Session session = JCRRepository.getSession();

		LockManager lockManager = null;
		Node nodeItem = null;
		JCRWorkspaceItem item = null;
		try {
			lockManager =  session.getWorkspace().getLockManager();
			Node nodeDestination;	

			try {
				nodeItem = session.getNodeByIdentifier(itemId);
				item = getWorkspaceItem(nodeItem);
			} catch (javax.jcr.ItemNotFoundException e) {
				logger.error("Item with id "+ itemId + " not found");
				throw new ItemNotFoundException(e.getMessage());
			} catch (RepositoryException e) {
				logger.error("Fatal error retrieving item with id " + itemId);
				throw new InternalErrorException(e);
			}

			logger.trace(nodeItem.getPath() + " is locked? " + nodeItem.isLocked());

			if (!nodeItem.isLocked()){

				try{
					Lock lock = lockManager.lock(nodeItem.getPath(), true, true, 0, "");
					logger.trace("LOCK on Node: " + lock.getNode().getPath());
					session.save();
				}catch (Exception e) {
					logger.trace("Unable to perform a locking operation on a non-lockable node: " + nodeItem.getPath());
				}

				try {
					nodeDestination = session.getNodeByIdentifier(destinationFolderId);			
				} catch (RepositoryException e) {
					logger.error("Destination not found");
					throw new WorkspaceFolderNotFoundException(e.getMessage());
				}

				//			if the destinationFolder is the Trash, use moveToTrash method
				//			if (!nodeFolder.getIdentifier().equals(trashId)){
				//				moveToTrash(itemId);
				//			}

				try {
					logger.trace("nodeDestination: " + nodeDestination.getPath());
					checkDestination(nodeItem, nodeDestination);

					String idSharedFolder = item.getIdSharedFolder();
					if((idSharedFolder!=item.getId()) && (idSharedFolder!=null)){
						logger.debug("the item is shared: " + nodeItem.getPath());
						if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), getOwner().getPortalLogin(), nodeItem.getPath(), false)) 
							throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
					}

					JCRWorkspaceItem parentItem = (JCRWorkspaceItem) item.getParent();
					JCRWorkspaceItem destinationItem = getWorkspaceItem(nodeDestination);

					if(destinationItem.isShared()){
						if (!JCRPrivilegesInfo.canAddChildren(destinationItem.getOwner().getPortalLogin(), getOwner().getPortalLogin(), nodeDestination.getPath()))
							throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
					}

					// Set cut accounting entry to folder parent item
					logger.debug("Adding accounting entry ....");
					try{
						parentItem.addAccountingEntry(new JCRAccountingFolderEntryCut(getOwner().getPortalLogin(),
								Calendar.getInstance(),
								item.getType(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
										item.getName(),
										(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
					}catch (Exception e) {
						logger.error("Error Set cut accounting entry to folder parent item ");
					}

					//				System.out.println(destinationFolder.getPath());
					// Set ADD accounting entry to destination folder if it's not the trash			
					//				if (!nodeFolder.getIdentifier().equals(trashId)){
					destinationItem.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
							Calendar.getInstance(), item.getType(),
							(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
									item.getName(),
									(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
					//				}
					// Set PASTE accounting entry to item
					try{
						item.addAccountingEntry(new JCRAccountingEntryPaste(getOwner().getPortalLogin(),
								Calendar.getInstance(), item.getParent().getName()));
					}catch (Exception e) {
						logger.error("Error Set PASTE accounting entry to item ");
					}

					//				String nodeDestPath = nodeFolder.getPath();
					String newRemotePath = null;

					//move item into storage from a remotePath to a new one

					if (item.getType() == WorkspaceItemType.FOLDER_ITEM){
						newRemotePath = nodeDestination.getPath() + getPathSeparator() + item.getName() ;
						try{

							GCUBEStorage.moveRemoteFile(item.getRemotePath(), Text.unescapeIllegalJcrChars(newRemotePath), home.getOwner().getPortalLogin());
							//						GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath);

							JCRWorkspaceItem itemJCR = (JCRWorkspaceItem) item;
							itemJCR.setRemotePath(Text.unescapeIllegalJcrChars(newRemotePath), nodeItem);
						}catch (Exception e) { logger.error("Error setting remotePath to " + item.getPath());}
					}
					else if (item.getType() == WorkspaceItemType.FOLDER){

						newRemotePath = nodeDestination.getPath();
						//					System.out.println("base Path " + newRemotePath);
						moveDir(item, newRemotePath, nodeItem);
						session.save();
						//					System.out.println("moveRemoteFolder" );
						//					GCUBEStorage.moveRemoteFolder(nodeSrcPath, nodeDestPath);
					}	

					//move item in JR

					item.internalMove(nodeDestination);

				} catch (RepositoryException e) {
					logger.error("Fatal error moving item with id " + itemId 
							+ " to WorkspaceFolder with id " + destinationFolderId);

					throw new InternalErrorException(e);
				}
			}

			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {

			try {
				if (lockManager.isLocked(nodeItem.getPath())){
					lockManager.unlock(nodeItem.getPath());
					logger.trace("Remove Lock from node: " + nodeItem.getPath());
				}
			} catch (RepositoryException e) {
				throw new InternalErrorException(e);
			}

			session.logout();
		}
		return item;

	}


	private void moveDir(WorkspaceItem folder, String destinationPath, Node node) throws InternalErrorException {


		for (WorkspaceItem item : folder.getChildren()){
			String path = destinationPath + getPathSeparator() + folder.getName() + getPathSeparator() + item.getName();
			try{		
				String remotePath = item.getRemotePath();

				logger.trace("Update remotePath: " + remotePath + " to: " + path);

				GCUBEStorage.moveRemoteFile(remotePath, path, home.getOwner().getPortalLogin());
				//				GCUBEStorage.moveRemoteFile(remotePath, path);
				logger.trace("moved from " + remotePath + " to " + path);

				JCRWorkspaceItem jcrItem = (JCRWorkspaceItem) item;

				jcrItem.setRemotePath(path, node);
				logger.trace("set Remote Path property to node: " + path);

				moveDir(item, path, node);

			}catch (Exception e) {

				logger.warn("Error setting new remotePath to " + item.getName());
			}


		}

	}

	/**
	 * Move a folder to a destination node: update Jackrabbit and Storage
	 * @param nodeItem
	 * @param destinationNode
	 * @throws ItemNotFoundException
	 * @throws WrongDestinationException
	 * @throws InsufficientPrivilegesException
	 * @throws InternalErrorException
	 * @throws ItemAlreadyExistException
	 * @throws WorkspaceFolderNotFoundException
	 */
	public void moveNodeTo(Node nodeItem, Node destinationNode)
			throws ItemNotFoundException, WrongDestinationException,
			InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException, WorkspaceFolderNotFoundException {	

		Validate.notNull(nodeItem , "Node must be not null");
		Validate.notNull(destinationNode, "Destination folder Node must be not null");

		try {
			Session session = nodeItem.getSession();
			logger.debug("Move from " + nodeItem.getPath() + "to Trash ");

			try {
				JCRWorkspaceItem item = getWorkspaceItem(nodeItem);
				String newRemotePath = null;

				//move item into storage from a remotePath to a new one

				if (item.getType() == WorkspaceItemType.FOLDER_ITEM){
					newRemotePath = destinationNode.getPath() + "/" + item.getName();

					try{
						//GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath);

						GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath, home.getOwner().getPortalLogin());
						item.setRemotePath(newRemotePath, nodeItem);

					}catch (Exception e) { logger.error("Error setting remotePath to " + item.getPath());}
				}
				else if (item.getType() == WorkspaceItemType.FOLDER){
					newRemotePath = destinationNode.getPath();
					moveDir(item, newRemotePath, nodeItem);
					session.save();
				}	

				//move item in JR

				item.internalMove(destinationNode);

			} catch (RepositoryException e) {
				logger.error("Fatal error moving item " + nodeItem.getPath() 
						+ " to WorkspaceFolder " + destinationNode.getPath());
				throw new InternalErrorException(e);
			}
			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} 

	}

	public void moveSharedItem(Node sharedNode)
			throws ItemNotFoundException, WrongDestinationException,
			InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException, WorkspaceFolderNotFoundException, RepositoryException {

		//		logger.debug("Move item with id " + itemId + "to destination with id " + destinationFolderId);

		Validate.notNull(sharedNode , "Item id must be not null");

		logger.debug("sharedFolder: " + sharedNode.getPath());
		Session session = JCRRepository.getSession();
		try {

			try {
				//				checkDestination(nodeItem, nodeFolder);

				WorkspaceItem item = getWorkspaceItem(sharedNode);

				if(item.isShared()){
					logger.debug("the item " + item.getPath() + " is shared" );
					if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), getOwner().getPortalLogin(), item.getPath(), false)) 
						throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
				}

				String newRemotePath = null;
				logger.debug("item.getType() " + item.getType());
				//move item into storage from a remotePath to a new one

				if (item.getType() == WorkspaceItemType.SHARED_FOLDER){
					newRemotePath = sharedNode.getPath();
					logger.debug("base Path " + newRemotePath);
					moveToShare(item, newRemotePath);

					logger.debug("moveToShare finished");
					//					GCUBEStorage.moveRemoteFolder(nodeSrcPath, nodeDestPath);
				}

			} catch (RepositoryException e) {
				logger.error("Fatal error moving item with id " + sharedNode);

				throw new InternalErrorException(e);
			}

			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}


	//move a folder, changing all paths
	private void moveToShare(WorkspaceItem item, String destinationPath) throws RepositoryException, InternalErrorException, ItemNotFoundException {
		logger.debug("WorkspaceItem " + item + " - destinationPath " + destinationPath );
		//		Session session = JCRRepository.getSession();


		for (WorkspaceItem child : item.getChildren()) {
			String path = destinationPath + "/" + child.getName();
			logger.debug("path " + path);

			try{		
				if(child.getType().equals(WorkspaceItemType.FOLDER_ITEM)){
					String remotePath = child.getRemotePath();

					logger.debug("remotePath " + remotePath);

					//without jcr:content tag
					//				String newRemotePath = child.getParent().getPath();
					//				System.out.println("***newRemotePath " + newRemotePath);
					logger.trace("Update remotePath: " + remotePath + " to: " + path);

					//					GCUBEStorage.moveRemoteFile(remotePath, path);

					GCUBEStorage.moveRemoteFile(remotePath, path, home.getOwner().getPortalLogin());

					logger.debug("moved from " + remotePath + " to " + path);

					JCRWorkspaceItem JCRchild = (JCRWorkspaceItem) child;
					JCRchild.setRemotePath(path, null);

					logger.debug("property to node: " + child.getRemotePath() + " has been set");

					//					session.save();

				}
			}catch (Exception e) {
				throw new ItemNotFoundException(e.getMessage());
			}

			//			//recorsive
			if (child.getChildren().size()>0)
				moveToShare(child, path);									
		}

	}




	@Override
	public void renameItem(String itemId, String newName)
			throws ItemNotFoundException, InternalErrorException,
			ItemAlreadyExistException, InsufficientPrivilegesException {

		Validate.notNull(itemId, "Item id must be not null");

		if (!isValidName(newName))
			throw new IllegalArgumentException("Invalid item name");

		Session session = JCRRepository.getSession();
		try {
			Node node;
			Node parentNode;
			try {
				node = session.getNodeByIdentifier(itemId);
				parentNode = node.getParent();
			} catch (RepositoryException e) {
				throw new ItemNotFoundException(e.getMessage());
			}


			JCRWorkspaceItem item = null;
			JCRWorkspaceItem parentItem = null;
			try {
				item = getWorkspaceItem(node);

				if(item.isShared()){
					logger.debug("the item is shared: " + node.getPath());
					if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), getOwner().getPortalLogin(), node.getPath(), false)) 
						throw new InsufficientPrivilegesException("Insufficient Privileges to rename the node");
				}
				//Set renaming accounting entry to item
				item.addAccountingEntry(new JCRAccountingEntryRenaming(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getName()));

				//Set renaming accounting entry to parent item
				try{

					parentItem = getWorkspaceItem(parentNode);		

					parentItem.addAccountingEntry(new JCRAccountingEntryRenaming(getOwner().getPortalLogin(),
							Calendar.getInstance(), item.getName()));

				}catch (Exception e) {
					logger.error("Impossible to set rename operation to node " + parentNode.getPath());
				}

				item.internalRename(node, newName);



				String newRemotePath = null;
				//move item into storage from a remotePath to a new one
				if (item.getType() == WorkspaceItemType.FOLDER_ITEM){
					newRemotePath = parentNode.getPath() + getPathSeparator() + newName ;
					//					System.out.println("newRemotePath: " + newRemotePath);
					try{
						GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath, home.getOwner().getPortalLogin());
						//						GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath);
						item.setRemotePath(newRemotePath, node);
					}catch (Exception e) { logger.error("Error setting remotePath to " + item.getPath());}
				}
				else if (item.getType() == WorkspaceItemType.FOLDER){
					newRemotePath = parentNode.getPath();
					//					System.out.println("newRemotePath: " + newRemotePath);
					moveDir(item, newRemotePath, node);
					session.save();
				}

			} catch (RepositoryException e) {
				throw new InternalErrorException(e);
			} 
			session.save();
			fireItemRenamedEvent(item);


		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public void changeDescription(String itemId, String newDescription)
			throws ItemNotFoundException, InternalErrorException {

		Validate.notNull(itemId, "Item id must be not null");
		Session session = JCRRepository.getSession();
		try {
			Node nodeItem = session.getNodeByIdentifier(itemId);
			getWorkspaceItem(nodeItem).internalDescription(nodeItem, newDescription);
		} catch (RepositoryException e) {
			throw new ItemNotFoundException(e.getMessage());
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkspaceItem getItem(String itemId) throws ItemNotFoundException {

		Validate.notNull(itemId, "Item id must be not null");

		Session session = null;
		try {
			session = JCRRepository.getSession();
			return getItem(session, itemId);
		} catch (InternalErrorException e) {
			throw new ItemNotFoundException(e.getMessage());
		} catch (RepositoryException e) {
			throw new ItemNotFoundException(e.getMessage());
		} finally {
			if (session != null)
				session.logout();
		}
	}

	public WorkspaceItem getItem(Session session, String itemId) throws ItemNotFoundException,
	InternalErrorException, RepositoryException {

		Node nodeItem = null;
		try {
			nodeItem = session.getNodeByIdentifier(itemId);
		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException(e.getMessage());
		} 
		return getWorkspaceItem(nodeItem);
	}


	@Override
	public Capabilities getCapabilities(String itemId)
			throws ItemNotFoundException, InternalErrorException {
		return null;
	}

	@Override
	public void removeChild(String childId, String folderId)
			throws ItemNotFoundException, InternalErrorException,
			InsufficientPrivilegesException, WrongParentTypeException {

		Validate.notNull(childId, "Child Id must be not null");
		Validate.notNull(folderId, "Folder Id must be not null");

		Session session = JCRRepository.getSession();
		try {

			Node parent = session.getNodeByIdentifier(folderId);


			//check if it's necessary
			if (!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
				throw new WrongParentTypeException("Item with id " + folderId + " isn't a folder item");
			}

			removeItem(childId);
		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException("Folder is not present");
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public void remove(String itemName, String folderId)
			throws ItemNotFoundException, InternalErrorException,
			InsufficientPrivilegesException, WrongItemTypeException {

		Session session = JCRRepository.getSession();
		try {
			Node nodeFolder = null;
			try {
				nodeFolder = session.getNodeByIdentifier(folderId);

			} catch (javax.jcr.ItemNotFoundException e) {
				throw new ItemNotFoundException(e.getMessage());
			} catch (RepositoryException e) {
				throw new InternalErrorException(e);
			} 

			try {
				Node childNode = nodeFolder.getNode(Text.escapeIllegalJcrChars(itemName));
				removeItem(childNode.getIdentifier());

			} catch (PathNotFoundException e) {
				throw new ItemNotFoundException(e.getMessage());
			} catch (RepositoryException e) {
				throw new InternalErrorException(e);
			}
			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkspaceItem copy(String itemId, String newName,
			String destinationFolderId) throws ItemNotFoundException,
			WrongDestinationException, InternalErrorException,
			ItemAlreadyExistException, InsufficientPrivilegesException,
			WorkspaceFolderNotFoundException {

		Validate.notNull(itemId, "ItemId must be not null");
		Validate.notNull(newName, "NewName must be not null");
		Validate.notNull(destinationFolderId, "Destination Folder id must be not null");

		if (!isValidName(newName)){
			logger.error("The name contains illegal chars or is empty");
			throw new IllegalArgumentException("The name contains illegal chars or is empty");
		}

		return internalCopy(itemId, newName, destinationFolderId);


	}

	@Override
	public WorkspaceItem copy(String itemId, String destinationFolderId)
			throws ItemNotFoundException, WrongDestinationException,
			InternalErrorException, ItemAlreadyExistException,
			InsufficientPrivilegesException, WorkspaceFolderNotFoundException {

		Validate.notNull(itemId,"Item id must be not null");
		Validate.notNull(destinationFolderId, "destinationFolder id must be not null");

		return internalCopy(itemId, null, destinationFolderId); 
	}

	//create a new payload by a node for each children node
	public void copyRemoteContent(Node node, Node nodeDestinationFolder) throws RepositoryException, InternalErrorException, RemoteBackendException  {

		Session session = node.getSession();

		WorkspaceItem item = getWorkspaceItem(node);
		for (WorkspaceItem child : item.getChildren()) {
			copyRemoteContent(session.getNodeByIdentifier(child.getId()), nodeDestinationFolder);
		}

		if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {	
			((JCRWorkspaceFolderItem)item).copyRemoteContent(node);
		}
	}


	private WorkspaceItem internalCopy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException,
	WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {

		Session session = JCRRepository.getSession();
		try {
			Node nodeItem = null;
			try {
				nodeItem = session.getNodeByIdentifier(itemId);
			} catch (RepositoryException e) {
				throw new ItemNotFoundException(e.getMessage());
			}

			Node nodeDestinationFolder = null;
			try {
				if(destinationFolderId == null)
					destinationFolderId = nodeItem.getParent().getIdentifier();

				nodeDestinationFolder = session.getNodeByIdentifier(destinationFolderId);
				if(!nodeDestinationFolder.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)
						&& !nodeDestinationFolder.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
					throw new WrongDestinationException("Destination is not a folder");
				}
			} catch (RepositoryException e) {
				throw new WorkspaceFolderNotFoundException(e.getMessage());
			}

			JCRWorkspaceItem item = getWorkspaceItem(nodeItem);

			QueryManager queryManager = session.getWorkspace().getQueryManager();
			javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getOwner().getPortalLogin()
					+ ISO9075.encodePath(item.getPath()) +
					"//element(*,nthl:workspaceSharedItem)",
					javax.jcr.query.Query.XPATH);
			QueryResult result = q.execute();
			if (!item.isShared() && result.getNodes().hasNext()) {
				throw new WrongDestinationException("Not allowed to copy a folder with some discendents item shared ");	 
			}

			if (newName == null) 
				newName = item.getName();

			Node newNode = getWorkspaceItem(nodeItem).internalCopy(
					nodeDestinationFolder, newName);		

			session.save();
			JCRWorkspaceItem newItem = getWorkspaceItem(newNode);

			// Set paste accounting property
			newItem.addAccountingEntry(new JCRAccountingEntryPaste(getOwner().getPortalLogin(),
					Calendar.getInstance(), nodeItem.getParent().getName()));


			//TODO temporarily solution to copy all remote content item child nodes.
			copyRemoteContent(newNode, nodeDestinationFolder);


			//Set add entry on destination folder
			if (nodeDestinationFolder!=null){
				logger.debug("Set ADD accounting entry to destination folder " + nodeDestinationFolder.getPath() );
				JCRWorkspaceItem destinationFolder = getWorkspaceItem(nodeDestinationFolder);
				// Set add accounting entry to destination folder
				destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(getOwner().getPortalLogin(),
						Calendar.getInstance(), item.getType(),
						(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getFolderItemType():null,
								item.getName(),
								(item.getType() == WorkspaceItemType.FOLDER_ITEM)?((FolderItem)item).getMimeType():null));
				session.save();	
			}

			session.save();

			return newItem;


		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public WorkspaceItem cloneItem(String itemId, String cloneName)
			throws ItemNotFoundException, ItemAlreadyExistException,
			InsufficientPrivilegesException, InternalErrorException,
			WrongDestinationException, WorkspaceFolderNotFoundException {

		Validate.notNull(itemId, "itemId must be not null");
		if(!isValidName(cloneName)) 
			throw new IllegalArgumentException("cloneName is a not valid name");

		return internalCopy(itemId, cloneName, null);
	}

	@Override
	public boolean exists(String name, String folderId)
			throws InternalErrorException, ItemNotFoundException,
			WrongItemTypeException {


		Validate.notNull(name, "Name must be not null");
		Validate.notNull(folderId, "Name must be not null");

		Session session = JCRRepository.getSession();
		try {
			Node folderNode;
			try {
				folderNode = session.getNodeByIdentifier(folderId);
			} catch (RepositoryException e) {
				throw new ItemNotFoundException(e.getMessage());
			}

			if (!isValidName(name)){
				return false;
			}

			try {
				folderNode.getNode(Text.escapeIllegalJcrChars(name));
			} catch (RepositoryException e) {
				try {
					logger.debug(name + " does not exist yet in folder " + folderNode.getPath());
				} catch (RepositoryException e1) {
				}
				return false; 
			}

			logger.debug("Item exists");
			return true;
		} finally {
			session.logout();
		}
	}

	@Override
	public boolean exists(String itemId) throws InternalErrorException {

		Validate.notNull(itemId, "Item id must be not null");
		Session session = JCRRepository.getSession();
		try {
			try {
				session.getNodeByIdentifier(itemId);
			} catch (RepositoryException e) {
				return false; 
			}
			return true;
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkspaceItem find(String name, String folderId)
			throws InternalErrorException, ItemNotFoundException,
			WrongItemTypeException {

		Session session = JCRRepository.getSession();
		try {
			Node nodeFolder = session.getNodeByIdentifier(folderId);
			try {
				Node node = nodeFolder.getNode(Text.escapeIllegalJcrChars(name));
				return getWorkspaceItem(node);
			} catch (PathNotFoundException e) {
				return null;
			}
		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException(e.getMessage());
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkspaceItem find(String path) throws InternalErrorException {

		Session session = JCRRepository.getSession();
		try {
			try {
				String[] strings = path.split("/");
				String pathCleaned = "";
				for(String string : strings) {
					pathCleaned += "/" + Text.escapeIllegalJcrChars(string);
				}
				Node rootNode = session.getNodeByIdentifier(root.getId());	
				Node node = session.getNode(rootNode.getPath() + pathCleaned);
				return getWorkspaceItem(node);
			} catch (RepositoryException e) {
				throw new InternalErrorException(e);
			}
		} finally {
			session.logout();
		}
	}

	@Override
	public boolean isValidName(String name) {
		if(name == null || name.length() == 0)
			return false;
		return !name.contains(JCRRepository.PATH_SEPARATOR);
	}

	@Override
	public FolderBulkCreator getNewFolderBulkCreator(String folderId)
			throws WorkspaceFolderNotFoundException, WrongItemTypeException,
			InternalErrorException {

		Validate.notNull(folderId, "Folder id must be not null");

		Session session = JCRRepository.getSession();
		try {
			Node folderNode;
			try {
				folderNode = session.getNodeByIdentifier(folderId);
			} catch (RepositoryException e) {
				throw new WorkspaceFolderNotFoundException(e.getMessage());
			}

			try {		
				if (!folderNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER))
					throw new WrongItemTypeException("A FolderBulkCreator can be created " +
							" only for a folder");
			} catch (RepositoryException e) {
				throw new InternalErrorException(e); 
			}

			JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, folderNode);

			return folderBulkCreatorsManager.getFolderBulk(folder);
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public FolderBulkCreatorManager getFolderBulkCreatorManager() {
		return folderBulkCreatorsManager;
	}

	@Override
	public WorkspaceMessageManager getWorkspaceMessageManager() {

		if(sendRequestManager == null)
			this.sendRequestManager = new JCRWorkspaceMessageManager(this);
		return sendRequestManager;
	}

	@Override
	public WorkspaceFolder decomposeAquaMapsItem(String itemId,
			String folderName, String destinationWorkspaceId)
					throws WrongItemTypeException, WorkspaceFolderNotFoundException,
					WrongDestinationException, InternalErrorException,
					ItemAlreadyExistException, InsufficientPrivilegesException,
					ItemNotFoundException {


		return null;
	}

	public JCRWorkspaceItem getWorkspaceItem(Node node) throws RepositoryException, InternalErrorException {
		//						System.out.println("*****node.getPath(): " + node.getPath() + " - node.getPrimaryNodeType().getName(): " + node.getPrimaryNodeType().getName());

		String type = node.getPrimaryNodeType().getName();

		switch (type) {			
		case NT_WORKSPACE_FOLDER:
			return new JCRWorkspaceFolder(this, node);
		case NT_WORKSPACE_SHARED_FOLDER:
			return new JCRWorkspaceSharedFolder(this, node);
		case NT_WORKSPACE_VRE_FOLDER:
			return new JCRWorkspaceVREFolder(this, node);
		case NT_WORKSPACE_FILE:
			return new JCRExternalFile(this, node);
		case NT_WORKSPACE_IMAGE:
			return new JCRExternalImage(this, node); 
		case NT_WORKSPACE_PDF_FILE:
			return new JCRExternalPDFFile(this,node); 
		case NT_WORKSPACE_URL:
			return new JCRExternalUrl(this, node);
		case NT_GCUBE_ITEM:
			return new JCRGCubeItem(this, node);
		case NT_TRASH_ITEM:
			return new JCRWorkspaceTrashItem(this, node);

		case NT_WORKSPACE_REPORT:
			return new JCRReport(this, node);
		case NT_WORKSPACE_REPORT_TEMPLATE:
			return new JCRReportTemplate(this, node);
		case NT_WORKSPACE_WORKFLOW_REPORT:
			return new JCRWorkflowReport(this, node);
		case NT_WORKSPACE_WORKFLOW_TEMPLATE:
			return new JCRWorkflowTemplate(this, node);
		case NT_AQUAMAPS_ITEM:
			return new JCRAquaMapsItem(this, node);
		case NT_QUERY:
			return new JCRQuery(this,node);
		case NT_TIMESERIES_ITEM:
			return new JCRTimeSeries(this, node);
		case NT_DOCUMENT_ITEM:
			return new JCRDocument(this, node);
		case NT_DOCUMENT_LINK_ITEM:
			return new JCRDocumentLink(this, node);
		case NT_IMAGE_DOCUMENT_ITEM:
			return new JCRImageDocument(this, node);
		case NT_IMAGE_DOCUMENT_LINK_ITEM:
			return new JCRImageDocumentLink(this, node);
		case NT_PDF_DOCUMENT_ITEM:
			return new JCRPDFDocument(this, node);
		case NT_PDF_DOCUMENT_LINK_ITEM:
			return new JCRPDFDocumentLink(this, node);	
		case NT_URL_DOCUMENT_ITEM:
			return new JCRUrlDocument(this, node);
		case NT_ANNOTATION_ITEM:
			return new JCRAnnotation(this, node);
		case NT_METADATA_ITEM:
			return new JCRMetadata(this, node);
		case NT_WORKSPACE_FOLDER_ITEM:
			return new JCRWorkspaceSmartFolder(this,node);
		case NT_EXTERNAL_RESOURCE_LINK_ITEM:
			return new JCRExternalResourceLink(this, node);

		default: 
			throw new InternalErrorException("JCR node type unknow");
		}
	}


	public FolderItemType getFolderItemType(Node node) throws RepositoryException {

		String nodeType = node.getPrimaryNodeType().getName();

		if (nodeType.equals(NT_WORKSPACE_FILE)) {
			return FolderItemType.EXTERNAL_FILE;
		} else if (nodeType.equals(NT_WORKSPACE_IMAGE)) {
			return FolderItemType.EXTERNAL_IMAGE; 
		} else if (nodeType.equals(NT_WORKSPACE_PDF_FILE)) {
			return FolderItemType.EXTERNAL_PDF_FILE; 
		} else if (nodeType.equals(NT_WORKSPACE_URL)) {
			return FolderItemType.EXTERNAL_URL;
		} else if (nodeType.equals(NT_GCUBE_ITEM)) {
			return FolderItemType.GCUBE_ITEM;
		} else if (nodeType.equals(NT_TRASH_ITEM)) {
			return FolderItemType.TRASH_ITEM;


		} else if (nodeType.equals(NT_WORKSPACE_REPORT)) {
			return FolderItemType.REPORT;
		} else if (nodeType.equals(NT_WORKSPACE_REPORT_TEMPLATE)) {
			return FolderItemType.REPORT_TEMPLATE;
		} else if (nodeType.equals(NT_WORKSPACE_WORKFLOW_REPORT)) {
			return FolderItemType.WORKFLOW_REPORT;
		} else if (nodeType.equals(NT_WORKSPACE_WORKFLOW_TEMPLATE)) {
			return FolderItemType.WORKFLOW_TEMPLATE;
		} else if (nodeType.equals(NT_AQUAMAPS_ITEM)) {
			return FolderItemType.AQUAMAPS_ITEM;
		} else if (nodeType.equals(NT_QUERY)) {
			return FolderItemType.QUERY;
		} else if (nodeType.equals(NT_TIMESERIES_ITEM)) {
			return FolderItemType.TIME_SERIES;
		} else if (nodeType.equals(NT_DOCUMENT_ITEM)) {
			return FolderItemType.DOCUMENT;
		} else if (nodeType.equals(NT_DOCUMENT_LINK_ITEM)) {
			return FolderItemType.DOCUMENT_LINK;
		} else if (nodeType.equals(NT_IMAGE_DOCUMENT_ITEM)) {
			return FolderItemType.IMAGE_DOCUMENT;
		} else if (nodeType.equals(NT_IMAGE_DOCUMENT_LINK_ITEM)) {
			return FolderItemType.IMAGE_DOCUMENT_LINK;
		} else if (nodeType.equals(NT_PDF_DOCUMENT_ITEM)) {
			return FolderItemType.PDF_DOCUMENT;
		} else if (nodeType.equals(NT_PDF_DOCUMENT_LINK_ITEM)) {
			return FolderItemType.PDF_DOCUMENT_LINK;	
		} else if (nodeType.equals(NT_URL_DOCUMENT_ITEM)) {
			return FolderItemType.URL_DOCUMENT;
		} else if (nodeType.equals(NT_ANNOTATION_ITEM)) {
			return FolderItemType.ANNOTATION;
		} else if (nodeType.equals(NT_METADATA_ITEM)) {
			return FolderItemType.METADATA_LINK;
		} else if (nodeType.equals(NT_EXTERNAL_RESOURCE_LINK_ITEM))
			return FolderItemType.EXTERNAL_RESOURCE_LINK;

		return null; 
	}

	public JCRAbstractWorkspaceFolder getParent(Node node) throws RepositoryException, InternalErrorException {

		Node parent = node.getParent();
		//	System.out.println("parent " + parent.getPath() +  " " + parent.getPrimaryNodeType().getName());
		if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) 
			return new JCRWorkspaceFolder(this, parent);
		else if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER))
			return new JCRWorkspaceSharedFolder(this, parent);
		else 
			return null;
	}

	public JCRFile getGCUBEDocumentContent(Session session, String oid, ContentType contentType) throws RepositoryException {

		Node node = JCRRepository.getGCubeRoot(session).getNode(Text.escapeIllegalJcrChars(oid));
		switch(contentType) {
		case GENERAL:
			return new JCRFile(this, node.getNode(CONTENT));
		case IMAGE: 
			return new JCRImage(this, node.getNode(CONTENT));
		case PDF:
			return new JCRPDFFile(this, node.getNode(CONTENT));
		default:
			return null;
		}
	}

	public JCRFile setGCUBEDocumentContent(Session session, String oid,InputStream data, String mimeType,
			ContentType contentType) throws IOException, ItemExistsException, RepositoryException, RemoteBackendException{

		Node parent = JCRRepository.getGCubeRoot(session);
		Node nodeFile = parent.addNode(Text.escapeIllegalJcrChars(oid),NT_FILE);

		JCRFile file = null;
		switch(contentType) {
		case GENERAL:
			file = new JCRFile(this, nodeFile.addNode(CONTENT,ContentType.GENERAL.toString()),mimeType,data);
			break;
		case IMAGE: 
			file = new JCRImage(this, nodeFile.addNode(CONTENT,ContentType.IMAGE.toString()),data);
			break;
		case PDF:
			file = new JCRPDFFile(this, nodeFile.addNode(CONTENT,ContentType.PDF.toString()),mimeType,data);
			break;
		default:
			break;
		}

		return file;
	}

	private String isValidSearchResult(Node node) {


		String portalLogin = getHome().getOwner().getPortalLogin();
		String sharePath = JCRRepository.PATH_SEPARATOR + JCRRepository.SHARED_FOLDER;
		String userPath = JCRRepository.PATH_SEPARATOR + JCRRepository.HOME_FOLDER +
				JCRRepository.PATH_SEPARATOR + portalLogin;

		try {
			String nodePath = node.getPath();
			if (nodePath.startsWith(userPath)){
				//				System.out.println("*** userPath");
				return node.getProperty(JCRWorkspaceItem.TITLE).getString();
			}

			if (nodePath.startsWith(sharePath)) {
				//				System.out.println("*** sharePath");
				Node sharedNode = (Node) node.getAncestor(2);

				if (node.getPath().equals(sharedNode.getPath())) {
					Node usersNode = sharedNode.getNode(JCRWorkspaceSharedFolder.USERS);
					String prop = (usersNode.getProperty(portalLogin)).getValue().getString();
					String[] value = prop.split(JCRRepository.PATH_SEPARATOR);
					//					System.out.println("prop " + value[1]);
					return value[1];
				}				
				else 
					return node.getName();
				//				for (PropertyIterator iterator = usersNode.getProperties(); iterator.hasNext();) {
				//					Property property  = iterator.nextProperty();
				//					String name = property.getName();
				//					if (name.equals(portalLogin)) {
				//						if (node.getPath().equals(sharedNode.getPath())) {
				//							String[] values = property.getValue().getString().
				//									split(JCRRepository.PATH_SEPARATOR);
				//							return values[1];
				//
				//						} else {
				//							return node.getName();
				//						}
				//					}
				//				} 
			}	
			return null;
		} catch (RepositoryException e) {
			return null;
		}
	}


	@Override
	public List<SearchItem> advancedSearch(String name, SearchItemByOperator date, SearchItemByOperator size) throws InternalErrorException {

		Session session = JCRRepository.getSession();
		NodeIterator iterator;
		List<SearchItem> list = null;
		try {
			QueryManager queryManager = session.getWorkspace().getQueryManager();	

			String userPath = "/Home/" + getHome().getOwner().getPortalLogin();


			//	if (!(date.getValue() instanceof Date))
			//		System.out.println("date is not an instance of Date");
			//		
			//			String path = userPath +"/Workspace";
			//			String trashPath = userPath + trashFolder.getPath(); 

			//	the ISO standard format: YYYY-MM-DDThh:mm:ss.sTZD
			//						String sql2= "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" +
			//								" AND (UPPER([jcr:title]) LIKE '%"+ name.toUpperCase() + "%')" +				
			//								" AND NOT(ISDESCENDANTNODE ('" + trashPath + "'))" +
			//								" AND (node.[jcr:created] " + date.getOperator() + " CAST('" + date.getValue().toString() + "' AS DATE))" ;
			//								" AND node.[jcr:content/hl:size] " + size.getOperator() + " cast('" + size.getValue().toString() + "' as long)" ;
			StringBuilder xpath =  new StringBuilder("/jcr:root/Home/" + getOwner().getPortalLogin()+"/Workspace" +
					"//element(*,nthl:workspaceItem)[");


			xpath.append("jcr:contains(@jcr:title, '*" + name + "*')");

			if (date!=null){
				if ((date.getMax()!=null) && (date.getMin()!=null))
					xpath.append(" and @jcr:created >= xs:dateTime('" + date.getMin() + "') and @jcr:created < xs:dateTime('" + date.getMax() + "')");

				//			String xpath = "/jcr:root/Home/" + getOwner().getPortalLogin()+"/Workspace" +
				//					"//element(*,nthl:workspaceItem)/jcr:content [@hl:size " + size.getOperator() + " xs:long('" + size.getValue().toString() + "') ]";
				else 
					xpath.append(" and @jcr:created " + date.getOperator() + " xs:dateTime('" + date.getValue().toString() + "')");
			}
			if (size!=null)
				//							xpath.append(" and jcr:content/@hl:size " + size.getOperator() + " xs:long(" + size.getValue().toString() + ")");

				xpath.append(" and jcr:content/@hl:size");
			//			StringBuilder xpath =  new StringBuilder("/jcr:root/Home/" + getOwner().getPortalLogin()+"/Workspace" +
			//					"//element(*,nthl:workspaceItem)[jcr:content/@hl:size " + size.getOperator() + " xs:long('" + size.getValue().toString() + "')");			
			xpath.append("]");
			//			System.out.println(xpath.toString());

			javax.jcr.query.Query q = queryManager.createQuery(xpath.toString(),
					javax.jcr.query.Query.XPATH);
			//						javax.jcr.query.Query q = queryManager.createQuery(sql2,javax.jcr.query.Query.JCR_SQL2);

			QueryResult result = q.execute();
			iterator = result.getNodes();

			list = new LinkedList<SearchItem>();
			while (iterator != null && iterator.hasNext()) {
				Node node = iterator.nextNode();

				String itemName = isValidSearchResult(node);

				if (itemName == null || !itemName.toUpperCase().contains(name.toUpperCase())) {
					logger.trace("Search result is not valid :" + node.getPath());
					continue;
				}

				//				Long sizeNode ;
				//				try {
				//
				//					Calendar creationDate = node.getProperty(JCRWorkspaceItem.CREATED).getDate();
				//
				//					System.out.println(" - Creation date: " + creationDate.toString());
				//					//					continue;
				//
				//				} catch (RepositoryException e) {
				//					System.out.println("no creation date");
				//
				//				}
				//				Node contentNode = null;
				//				try{
				//					contentNode = node.getNode(CONTENT);
				//					sizeNode = contentNode.getProperty(SIZE).getLong();		
				////					System.out.println("**Size  :" + sizeNode );
				//					//					if (sizeNode. size.getOperator() size.getValue() )
				//				} catch (RepositoryException e) {
				////					System.out.println("no size");
				//				}


				try {

					if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) ||
							node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
						JCRSearchFolder searchFolder = new JCRSearchFolder(node,itemName);
						if (!list.contains(searchFolder))
							list.add(searchFolder);
					} else {
						JCRSearchFolderItem searchFolderItem = new JCRSearchFolderItem(node, getFolderItemType(node), itemName);
						if (!list.contains(searchFolderItem))
							list.add(searchFolderItem);
					}
				} catch (Exception e) {

				}
			}

		} catch (Exception e) {
			logger.error("Error searchByName ",e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

		return list;
	}



	@Override
	public List<SearchItem> searchByName(String name) throws InternalErrorException {

		Session session = JCRRepository.getSession();
		NodeIterator iterator;
		List<SearchItem> list = null;
		try {
			QueryManager queryManager = session.getWorkspace().getQueryManager();	

			String userPath = "/Home/" + getHome().getOwner().getPortalLogin();
			String path = userPath +"/Workspace";
			String trashPath = path + "/Trash/";

			//			String sql2= "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" +
			//					" AND (LOCALNAME(node) LIKE '%"+ name + "%')";

			//			System.out.println(trashPath);

			String sql2= "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" +
					" AND (UPPER([jcr:title]) LIKE '%"+ name.toUpperCase() + "%')" +				
					" AND NOT(ISDESCENDANTNODE ('" + trashPath + "'))";

			//			System.out.println(sql2);
			javax.jcr.query.Query q = queryManager.createQuery(sql2,javax.jcr.query.Query.JCR_SQL2);

			QueryResult result = q.execute();
			iterator = result.getNodes();
			list = new LinkedList<SearchItem>();

			List<String> idList = new ArrayList<String>();
			//			int i=0;
			while (iterator.hasNext()) {
				Node node = iterator.nextNode();

				String id = node.getIdentifier();

				if (idList.contains(id))
					continue;			

				//				System.out.println(i++ + ") " + itemName);
				//				if (itemName == null || !itemName.toUpperCase().contains(name.toUpperCase())) {
				//					logger.trace("Search result is not valid :" + node.getPath());
				//					continue;
				//				}

				String itemName = isValidSearchResult(node);

				if (itemName == null)
					continue;

				try {
					if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) ||
							node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {

						JCRSearchFolder searchFolder = new JCRSearchFolder(node,itemName);
						list.add(searchFolder);

					} else {

						JCRSearchFolderItem searchFolderItem = new JCRSearchFolderItem(node, getFolderItemType(node), itemName);
						list.add(searchFolderItem);

					}
					idList.add(id);
					//					System.out.println(id + " added");
				} catch (Exception e) {

				}
			}

		} catch (Exception e) {
			logger.error("Error searchByName ",e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

		return list;
	}




	@Override
	public List<WorkspaceItem> getWorkspaceTree(WorkspaceItem item) throws InternalErrorException {
		List<WorkspaceItem> listItems = new LinkedList<WorkspaceItem>();
		listItems.addAll(item.getChildren());
		for(WorkspaceItem child : item.getChildren() ) {
			listItems.addAll(getWorkspaceTree(child));
		}
		return listItems;
	}

	@Override
	public WorkspaceSmartFolder createSmartFolder(String name, String description,
			String query) throws ItemAlreadyExistException, InternalErrorException  {

		Session session = JCRRepository.getSession();
		try {
			Node node = repository.getRootSmartFolders(session).addNode(name, 
					NT_WORKSPACE_FOLDER_ITEM);
			JCRWorkspaceSmartFolder  folder = new JCRWorkspaceSmartFolder(this, node, name, description, query);
			folder.save(node);
			return folder;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public List<WorkspaceSmartFolder> getAllSmartFolders() throws InternalErrorException {

		Session session = JCRRepository.getSession();
		List<WorkspaceSmartFolder> folders = new LinkedList<WorkspaceSmartFolder>();
		try {
			for (NodeIterator iterator = repository.getRootSmartFolders(session)
					.getNodes(); iterator.hasNext();) {
				Node node = iterator.nextNode();
				folders.add(new JCRWorkspaceSmartFolder(this, node));
			}
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return folders;

	}

	@Override
	public WorkspaceSmartFolder getSmartFolder(String folderId) throws ItemNotFoundException,
	InternalErrorException  {

		Session session = JCRRepository.getSession();
		try {
			return new JCRWorkspaceSmartFolder(this, session.getNodeByIdentifier(folderId));
		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException(e.getMessage());
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}


	@Override
	public List<SearchItem> getFolderItems(FolderItemType... types) throws InternalErrorException{

		List<SearchItem> list = new LinkedList<SearchItem>();
		for (FolderItemType folderItemType : types) {
			list.addAll(getFolderItems(folderItemType));
		}
		return list;
	}

	@Override
	public List<SearchItem> getFolderItems(FolderItemType type)
			throws InternalErrorException {

		Session session = JCRRepository.getSession();
		NodeIterator iterator = null;
		List<SearchItem> list = null;
		try {
			QueryManager queryManager = session.getWorkspace().getQueryManager();	
			javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
					"/Workspace//element()[@hl:workspaceItemType = '"+ type.toString() +"']",javax.jcr.query.Query.XPATH);

			logger.info("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
					"/Workspace//element()[@hl:workspaceItemType = '"+ type.toString() +"']");
			QueryResult result = q.execute();
			iterator = result.getNodes();

			list = new LinkedList<SearchItem>();
			while (iterator != null && iterator.hasNext()) {

				Node node = iterator.nextNode();
				String itemName = isValidSearchResult(node);
				if (itemName == null) {
					//					logger.trace("Search result is not valid :" + node.getPath());
					continue;
				}

				try {
					if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) ||
							node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
						list.add(new JCRSearchFolder(node,itemName));
					} else {
						list.add(new JCRSearchFolderItem(node, getFolderItemType(node), itemName));
					}
				} catch (Exception e) {

				}
			}
		} catch (Exception e) {
			logger.error("Error getFolderItems", e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return list;
	}

	@Override
	public List<SearchFolderItem> searchByMimeType(String mimeType)
			throws InternalErrorException {

		Session session = JCRRepository.getSession();
		NodeIterator iterator = null;
		List<SearchFolderItem> list = null;
		try {
			QueryManager queryManager = session.getWorkspace().getQueryManager();	
			javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
					"/Workspace//element()[@jcr:mimeType = '"+ mimeType+"']",javax.jcr.query.Query.XPATH);
			QueryResult result = q.execute();
			iterator = result.getNodes();

			list = new LinkedList<SearchFolderItem>();
			while (iterator != null && iterator.hasNext()) {

				Node node = iterator.nextNode();
				String itemName = isValidSearchResult(node);
				if (itemName == null) {
					logger.trace("Search result is not valid :" + node.getPath());
					continue;
				}

				try {
					list.add(new JCRSearchFolderItem(node.getParent(), 
							getFolderItemType(node.getParent()),itemName));		
				} catch (RepositoryException e) {
					try {
						logger.error("Item " + node.getName() + " unknow");
					} catch (RepositoryException e1) {
						logger.error("Error ",e1);
					}
				}

			}
		} catch (Exception e) {
			logger.error("Error getFolderItems", e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return list;
	}




	@Override
	public String getUrlWebDav() throws InternalErrorException {

		return repository.getWebDavUrl(home.getOwner().getPortalLogin()) 
				+  getPathSeparator() + WORKSPACE_ROOT_FOLDER;
		//		return repository.getUserHomeUrl(home.getOwner().getPortalLogin()) 
		//				+  getPathSeparator() + WORKSPACE_ROOT_FOLDER;
	}


	private void updateHomes(List<String> users) throws InternalErrorException{
		try{
			List<String> homes =  JCRRepository.getHomeNames();
			for (String user: users){
				if (!homes.contains(user))
					home.getHomeManager().createUser(user);
			}
		}catch (Exception e) {
			throw new InternalErrorException(e);
		}
	}


	@Override
	public WorkspaceSharedFolder createSharedFolder(String name,
			String description, List<String> users, String destinationFolderId)
					throws InternalErrorException, InsufficientPrivilegesException,
					ItemAlreadyExistException, WrongDestinationException,
					ItemNotFoundException, WorkspaceFolderNotFoundException {

		logger.trace("Create workspace shared folder");
		updateHomes(users);
		Session session = JCRRepository.getSession();
		try {

			if (exists(name, destinationFolderId))
				throw new ItemAlreadyExistException("The item already exists");

			JCRWorkspaceItem item = (JCRWorkspaceItem)getItem(session,destinationFolderId);
			if (item.getType() != WorkspaceItemType.FOLDER)
				throw new WrongDestinationException("Destination is not a folder");

			if (item.isShared())
				throw new WrongDestinationException("Destination folder is already shared");

			Node sharedFolder = JCRRepository.getSharedRoot(session);
			Node node = sharedFolder.addNode(UUID.randomUUID().toString(),NT_WORKSPACE_SHARED_FOLDER);		

			JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, name, 
					description, destinationFolderId, users, null, null);
			folder.save(node);


			fireItemCreatedEvent(folder);
			return folder;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (WrongItemTypeException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}	
	}


	@Override
	public WorkspaceSharedFolder shareFolder(List<String> users,
			String itemId)
					throws InternalErrorException, InsufficientPrivilegesException,
					WrongDestinationException, ItemNotFoundException,
					WorkspaceFolderNotFoundException {

		updateHomes(users);

		Session session = JCRRepository.getSession();

		LockManager lockManager = null;
		Node nodeItemToShare = null;
		JCRWorkspaceSharedFolder sharedItem = null;
		try {
			lockManager =  session.getWorkspace().getLockManager();


			nodeItemToShare = session.getNodeByIdentifier(itemId);

			if (!nodeItemToShare.isLocked()){
				JCRWorkspaceItem itemToShare = (JCRWorkspaceItem)getItem(session, itemId);
				if (itemToShare.getType() == WorkspaceItemType.SHARED_FOLDER) {

					WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)itemToShare; 
					sharedFolder.share(users);
					return sharedFolder;
				}

				//allow sharing if it's a gCubeItem

				if ((itemToShare.getType() != WorkspaceItemType.FOLDER) && !(itemToShare instanceof GCubeItem)) {
					//				System.out.println("The item to share is not a folder");
					throw new WorkspaceFolderNotFoundException("The item to share is not a folder");
				}

				WorkspaceItem parentItem = itemToShare.getParent(nodeItemToShare);
				if (parentItem == null)
					throw new WrongDestinationException("The root can't be shared");

				String parentId = parentItem.getId();
				JCRWorkspaceItem destinationFolder = (JCRWorkspaceItem)getItem(session,parentId);
				if (destinationFolder.isShared())
					throw new WrongDestinationException("Destination folder is already shared");


				logger.info("Check if Folder contains descendants already shared");
				QueryManager queryManager = session.getWorkspace().getQueryManager();

				javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getOwner().getPortalLogin()
						+ ISO9075.encodePath(itemToShare.getPath()) +
						"//element(*,nthl:workspaceSharedItem)",
						javax.jcr.query.Query.XPATH);

				QueryResult result = q.execute();

				if (result.getNodes().hasNext())
					throw new WrongDestinationException("Folder contains descendants already shared");

				//			System.out.println("itemId " + itemId);
				String sharedFolderName = itemToShare.getName();
				String sharedFolderDescription = itemToShare.getDescription();

				Node sharedRootFolder = JCRRepository.getSharedRoot(session);

				Node sharedNode = sharedRootFolder.addNode(UUID.randomUUID().toString(),NT_WORKSPACE_SHARED_FOLDER);			



				if (itemToShare.getType() == WorkspaceItemType.FOLDER){
					sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, 
							sharedFolderDescription, parentId, users, null, null);
					//				System.out.println("folder");

					Node folderNode = session.getNodeByIdentifier(itemId);

					//				try {
					//					moveNodeTo(nodeItemToShare, sharedNode);
					//				} catch (ItemAlreadyExistException e) {
					//					// TODO Auto-generated catch block
					//					e.printStackTrace();
					//				}


					for (NodeIterator iterator = nodeItemToShare.getNodes();iterator.hasNext();) {
						Node node = iterator.nextNode();
						if (!node.getName().startsWith(JCRRepository.JCR_NAMESPACE)
								&& !node.getName().startsWith(JCRRepository.HL_NAMESPACE)) {
							session.getWorkspace().copy(node.getPath(), sharedNode.getPath() + 
									getPathSeparator() + node.getName());		

						}
					}

				}else{

					//				System.out.println("gCubeitem"); 

					String applicationName = nodeItemToShare.getParent().getName();

					sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, 
							sharedFolderDescription, parentId, users, applicationName, nodeItemToShare.getName());
					//
					//				System.out.println("copy from " + nodeItemToShare.getPath());
					//				System.out.println("to " + sharedNode.getPath() + getPathSeparator() + nodeItemToShare.getName());

					session.getWorkspace().copy(nodeItemToShare.getPath(), sharedNode.getPath() + getPathSeparator() + nodeItemToShare.getName());	
					session.save();

					//				System.out.println("sharedNode getPath" +  sharedNode.getPath() + " - get name : "+sharedNode.getName());

				}


				try {
					if (lockManager.isLocked(nodeItemToShare.getPath()))
						lockManager.unlock(nodeItemToShare.getPath());
				} catch (RepositoryException e) {
					throw new InternalErrorException(e);
				}

				nodeItemToShare.remove();

				session.save();

				sharedItem.save(sharedNode);

				//			System.out.println("copyremotecontent from "+  folderNode.getPath() + " to " + sharedNode.getPath());		


				//added after moving to moveItem
				sharedItem.setShareHistory(users, getOwner().getPortalLogin());


				//copy shared folder from private area to "share" area
				if (itemToShare.getType() == WorkspaceItemType.FOLDER){
					try {
						moveSharedItem(sharedNode);			
					} catch (ItemAlreadyExistException e) {

						throw new InternalErrorException(e);
					}


					session.save();

					//set SHARED operation in History
					//			JCRWorkspaceItem sharedItem = (JCRWorkspaceItem)getItem(session, sharedNode.getIdentifier());			
					//					sharedItem.setShareHistory(users, getOwner().getPortalLogin());

				}
				fireItemCreatedEvent(sharedItem);
			}
			return sharedItem;
		} catch (RepositoryException e) {

			throw new InternalErrorException(e);
		} finally {

			session.logout();
		}	

	}

	//	private void moveToShareFolder(Node nodeItem, Node sharedFolder)
	//				throws ItemNotFoundException, WrongDestinationException,
	//				InsufficientPrivilegesException, InternalErrorException,
	//				ItemAlreadyExistException, WorkspaceFolderNotFoundException {	
	//
	//			Validate.notNull(nodeItem , "Node to share must be not null");
	//			Validate.notNull(sharedFolder, "Shared folder Node must be not null");
	//
	//			try {
	//				Session session = nodeItem.getSession();
	//				logger.debug("Move from " + nodeItem.getPath() + "to Share ");
	//
	//				try {
	//					//				checkDestination(nodeItem, nodeFolder);
	//
	//					JCRWorkspaceItem item = getWorkspaceItem(nodeItem);
	//					String newRemotePath = null;
	//
	//					//move item into storage from a remotePath to a new one
	//
	//					if (item.getType() == WorkspaceItemType.FOLDER_ITEM){
	//						newRemotePath = sharedFolder.getPath() + "/" + item.getName();
	//						//					System.out.println("moveRemoteFile" );
	//						try{
	//							//						GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath);
	//
	//							getStorage().moveRemoteFile(item.getRemotePath(), newRemotePath);
	//
	//							item.setRemotePath(newRemotePath);
	//						}catch (Exception e) { logger.error("Error setting remotePath to " + item.getPath());}
	//					}
	//					else if (item.getType() == WorkspaceItemType.FOLDER){
	//						newRemotePath = sharedFolder.getPath();
	//						moveDir(item, newRemotePath);
	//						session.save();
	//					}	
	//
	//					//move item in JR
	//					item.internalMove(sharedFolder);
	//
	//				} catch (RepositoryException e) {
	//					logger.error("Fatal error moving item " + nodeItem.getPath() 
	//							+ " to WorkspaceFolder " + sharedFolder.getPath());
	//					throw new InternalErrorException(e);
	//				}
	//
	//				session.save();
	//			} catch (RepositoryException e) {
	//				throw new InternalErrorException(e);
	//			} 
	//
	//		}

	@Override
	public TabularDataLink createTabularDataLink(String name,
			String description, String tableId, String template,
			Provenance provenance, String operator, String runtimeResourceName, String destinationFolderId)
					throws InsufficientPrivilegesException, InternalErrorException,
					ItemAlreadyExistException, WrongDestinationException,
					WorkspaceFolderNotFoundException {

		logger.trace("Create tabular data link");

		Session session = JCRRepository.getSession();
		try {
			Node node = addChildNode(session, destinationFolderId, name, NT_TABULAR_DATA_LINK);
			JCRTabularDataLink item = new JCRTabularDataLink(this, node, name, description,
					tableId, template, provenance, operator, runtimeResourceName);
			item.save(node);

			fireItemCreatedEvent(item);
			return item;
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}


	@Override
	public List<Object> getBookmarks(String bookmarkFolderId) throws InternalErrorException {
		return null;
	}

	@Override
	public void addBookmark(String itemId, String destinationFolderId)
			throws ItemAlreadyExistException, InternalErrorException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {

	}

	public void setHardLink(Node node, String hardLinkRemotePath) throws RepositoryException, InternalErrorException {
		logger.info("set hard link: " + hardLinkRemotePath + " to node " + node.getPath());

		Session session = node.getSession();

		WorkspaceItem item = getWorkspaceItem(node);
		for (WorkspaceItem child : item.getChildren()) {
			setHardLink(session.getNodeByIdentifier(child.getId()), hardLinkRemotePath);
		}

		if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
			((JCRWorkspaceFolderItem)item).setHardLink(node, hardLinkRemotePath);
		}

		session.save();

	}



	@Override
	public void orderResultBy(String mimeType, long limit, long offset) throws InternalErrorException {
		//		Session session = JCRRepository.getSession();
		//		NodeIterator iterator;
		//		List<SearchItem> list = null;
		//		try {
		//			QueryManager queryManager = session.getWorkspace().getQueryManager();
		//
		//			String userPath = "/Home/" +getHome().getOwner().getPortalLogin();
		//
		//
		//			String path = userPath +"/Workspace";
		//
		//			//			javax.jcr.query.Query q = queryManager.createQuery("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
		//			//					"/Workspace//element()[@jcr:mimeType = '"+ mimeType+"']",javax.jcr.query.Query.XPATH);
		//
		//			//			String sql2= "/jcr:root/Home/" + getHome().getOwner().getPortalLogin() + /Workspace//element()[@jcr:mimeType = '"+ mimeType+"']";
		//			javax.jcr.query.Query query = queryManager.createQuery("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
		//					"/Workspace//element()[@jcr:mimeType = '"+ mimeType+"']",javax.jcr.query.Query.XPATH);
		//
		//			//			QueryResult result = q.execute();
		//
		//			QueryResult result = null;
		//
		//			if ((limit!=0) && (offset!=0)){
		//				((QueryImpl) query).setLimit(limit);
		//				((QueryImpl) query).setOffset(offset);
		//			}
		//
		//			result = query.execute();
		//
		//			final long totalSize = ((QueryResultImpl) result).getTotalSize(); 
		//			System.out.println("totalSize " + totalSize);
		//			//			if (limit!=0)
		//			//				((javax.jcr.query.Query) q).setLimit(limit);
		//			//			if (offset!=0)
		//			//				((javax.jcr.query.Query) q).setOffset(offset); // Start from the 10:th file
		//			//			
		//			//			
		//			//			QueryResult result = q.execute(offset, offset);
		//			iterator = result.getNodes();
		//
		//			list = new LinkedList<SearchItem>();
		//			while (iterator != null && iterator.hasNext()) {
		//				Node node = iterator.nextNode();
		//				System.out.println(node.getName());
		//				//				String itemName = isValidSearchResult(node);
		//				//				if (itemName == null || !itemName.contains(name)) {
		//				//					logger.trace("Search result is not valid :" + node.getPath());
		//				//					continue;
		//				//				}
		//			}
		//
		//		}catch (Exception e) {
		//			System.out.println(e);
		//		}
	}


	@Override
	public void updateItem(String itemId, InputStream fileData)
			throws InsufficientPrivilegesException,
			WorkspaceFolderNotFoundException, InternalErrorException,
			ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {


		Session session = JCRRepository.getSession();
		try {

			Node node = session.getNodeByIdentifier(itemId);
			logger.trace("Update file " + node.getPath());

			JCRWorkspaceItem newItem = getWorkspaceItem(node);

			if(newItem.isShared()){
				logger.debug("the item is shared: " + node.getPath());
				if (!JCRPrivilegesInfo.canModifyProperties(newItem.getOwner().getPortalLogin(), getOwner().getPortalLogin(), node.getPath(), false)) 
					throw new InsufficientPrivilegesException("Insufficient Privileges to update the node");
			}

			Calendar lastupdate = Calendar.getInstance();
			// Set updated accounting property to file
			newItem.addAccountingEntry(new JCRAccountingEntryUpdate(getOwner().getPortalLogin(),
					lastupdate, node.getName()));


			Node parent = node.getParent();
			JCRWorkspaceItem parentItem = getWorkspaceItem(parent);


			// Set updated accounting property to folder
			parentItem.addAccountingEntry(new JCRAccountingEntryUpdate(getOwner().getPortalLogin(),
					lastupdate, node.getName()));

			//			
			//			JCRFile file = new JCRFile(this, node.getNode(CONTENT), fileData);
			//			System.out.println(file.getName());
			File tmpFile = WorkspaceUtil.getTmpFile(fileData);	

			try {
				fileData.close();
			} catch (IOException e1) {
				logger.error("Error closing InputStream " + e1);
			}


			//copy file to storage and update properties	
			FileInputStream data = null;

			try {	              
				data = new FileInputStream(tmpFile);
				overwriteContent(node, data);
				data.close();
				updateProperties(node, lastupdate, MimeTypeUtil.getMimeType(node.getName(), new FileInputStream(tmpFile)), tmpFile.length());
			} catch (IOException e1) {
				throw new InternalErrorException(e1);
			}
			fireItemUpdatedEvent(getItem(itemId));
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}



	private void updateProperties(Node node, Calendar lastupdate, String mimeType, long size) throws RepositoryException, InternalErrorException {

		logger.trace("update Properies for node: " + node.getPath() + " - Last Modified by : " + getOwner().getPortalLogin()+ " - Last Action : " + WorkspaceItemAction.UPDATED.toString() );
		node.setProperty(LAST_MODIFIED,lastupdate); 
		node.setProperty(LAST_MODIFIED_BY, getOwner().getPortalLogin());
		node.setProperty(LAST_ACTION,WorkspaceItemAction.UPDATED.toString());
		node.getSession().save();

		if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FILE)) {
			JCRExternalFile item = new JCRExternalFile(this, node);
			item.updateInfo(mimeType, size);
		} else if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_IMAGE)) {
			JCRExternalImage item = new JCRExternalImage(this, node);
			item.updateInfo(mimeType, size);
		} else if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_PDF_FILE)) {
			JCRExternalPDFFile item =new JCRExternalPDFFile(this,node);
			item.updateInfo(mimeType, size);
		}

	}

	//overwrite Content
	public void overwriteContent(Node node, String is) throws RepositoryException, RemoteBackendException {

		try {
			Node contentNode = node.getNode(CONTENT);
			if (contentNode.hasProperty(JCRFile.REMOTE_STORAGE_PATH)) {	

				String remotePath = contentNode.getProperty(JCRFile.REMOTE_STORAGE_PATH).getString();

				//				String remotePath = Text.getRelativeParent(path, 1);


				String url =  GCUBEStorage.putStream(is, remotePath, home.getOwner().getPortalLogin());
				//				String url = GCUBEStorage.putStream(is, remotePath);

				//				contentNode.setProperty(JCRFile.REMOTE_STORAGE_PATH, remotePath);

				// Store url as byte stream in jcr:data binary property
				ByteArrayInputStream  binaryUrl = new ByteArrayInputStream(url.getBytes());
				Binary binary = contentNode.getSession().getValueFactory().createBinary(binaryUrl);
				contentNode.setProperty(JCRFile.DATA, binary);
			}	
		} catch (PathNotFoundException e) {
			logger.error("Content node "+ CONTENT + " not found",e);
		} 

	}


	//overwrite Content
	public void overwriteContent(Node node, InputStream is) throws RepositoryException, RemoteBackendException {

		try {
			Node contentNode = node.getNode(CONTENT);
			if (contentNode.hasProperty(JCRFile.REMOTE_STORAGE_PATH)) {	

				String remotePath = contentNode.getProperty(JCRFile.REMOTE_STORAGE_PATH).getString();

				//				String remotePath = Text.getRelativeParent(path, 1);


				String url =  GCUBEStorage.putStream(is, remotePath, home.getOwner().getPortalLogin());
				//				String url = GCUBEStorage.putStream(is, remotePath);

				//				contentNode.setProperty(JCRFile.REMOTE_STORAGE_PATH, remotePath);

				// Store url as byte stream in jcr:data binary property
				ByteArrayInputStream  binaryUrl = new ByteArrayInputStream(url.getBytes());
				Binary binary = contentNode.getSession().getValueFactory().createBinary(binaryUrl);
				contentNode.setProperty(JCRFile.DATA, binary);
			}	
		} catch (PathNotFoundException e) {
			logger.error("Content node "+ CONTENT + " not found",e);
		} 

	}

	@Override
	public JCRWorkspaceItem createGcubeItem(String name, String description,
			List<String> scopes, String creator, String itemType, Map<String, String> properties, 
			String destinationFolderId) throws InsufficientPrivilegesException,
			WorkspaceFolderNotFoundException, InternalErrorException,
			ItemAlreadyExistException, WrongDestinationException,
			ItemNotFoundException {
		logger.trace("Create aquamaps item");

		Session session = JCRRepository.getSession();		
		JCRWorkspaceItem item;
		try {
			Node node = addChildNode(session,destinationFolderId,name, NT_GCUBE_ITEM);		
			item = new JCRGCubeItem(this, node, name, description, scopes, creator, itemType, properties );
			session.save();
			fireItemCreatedEvent(item);
			return item;	
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}



	@Override
	public WorkspaceFolder getMySpecialFolders() throws InternalErrorException, ItemNotFoundException {

		logger.info("getMySpecialFolders: " + mySpecialFoldersPath);
		Session session = null;
		if (mySpecialFolders==null){
			session = JCRRepository.getSession();
			try {
				//create applicationFolder
				try {				
					mySpecialFolders = new JCRWorkspaceFolder(this, session.getNode(mySpecialFoldersPath));			
				} catch (PathNotFoundException e) {
					Node node = session.getNode(wsRootPath).addNode(SPECIAL_FOLDER,NT_WORKSPACE_FOLDER);
					mySpecialFolders = new JCRWorkspaceFolder(this, node, SPECIAL_FOLDER,  "My Special Folders");
					mySpecialFolders.save(node);
				}
			}catch (Exception e) {
				throw new InternalErrorException(e);
			} finally {
				session.logout();
			}
		}
		return mySpecialFolders;

	}

	public JCRWorkspaceFolder getApplicationArea() throws InternalErrorException {
		logger.info("getApplicationArea: " + applicationFolderPath);
		Session session = null;
		if (applicationFolder==null){
			session = JCRRepository.getSession();
			try {
				//create applicationFolder
				try {				
					applicationFolder = new JCRWorkspaceFolder(this, session.getNode(applicationFolderPath));			
				} catch (PathNotFoundException e) {
					Node node = session.getNode(wsRootPath).addNode(APPLICATION_FOLDER,NT_WORKSPACE_FOLDER);
					applicationFolder = new JCRWorkspaceFolder(this, node, APPLICATION_FOLDER, "Applications folder");
					applicationFolder.save(node);
				}
			}catch (Exception e) {
				throw new InternalErrorException(e);
			} finally {
				session.logout();
			}
		}
		return applicationFolder;
	}


	public JCRWorkspaceFolder getTrashFolder() throws InternalErrorException, RepositoryException {
		logger.info("getTrashFolder: " + trashPath);
		Session session = null;
		if (trashFolder==null){
			session = JCRRepository.getSession();
			try {	
				try {	
					trashFolder = new JCRWorkspaceFolder(this, session.getNode(trashPath));
				} catch (PathNotFoundException e) {
					Node trashNode = session.getNode(wsRootPath).addNode(TRASH,NT_WORKSPACE_FOLDER);
					trashFolder = new JCRWorkspaceFolder(this, trashNode, TRASH, "Trash folder");
					trashFolder.save(trashNode);
				}
			}catch (PathNotFoundException e) {
				throw new InternalErrorException(e);
			} finally {
				session.logout();
			}
		}
		return applicationFolder;
	}



	@Override
	public WorkspaceItem unshare(String itemId) throws InternalErrorException,
	ItemNotFoundException {

		JCRWorkspaceItem itemUnshared = null;
		Session session = JCRRepository.getSession();
		Node sharedNode = null;
		try {

			sharedNode = session.getNodeByIdentifier(itemId);

			JCRWorkspaceItem item = (JCRWorkspaceItem) getItem(sharedNode.getIdentifier());

			if (item.isShared()){
				//					System.out.println("the item is shared");
				JCRWorkspaceSharedFolder sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode);
				WorkspaceFolder destFolder = sharedItem.unShare();
				logger.trace("Unshared Folder: " + destFolder.getPath());

			}else			
				logger.trace(item.getPath() +" the item is not shared");


		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

		return itemUnshared;
	}

	@Override
	public WorkspaceItem getItemByPath(String path)
			throws ItemNotFoundException {
		Validate.notNull(path, "path must be not null");

		Session session = null;
		try {
			session = JCRRepository.getSession();
			String absPath;

			String longPath = path.substring(path.indexOf('/')+1);
			String shortPath = longPath.substring(longPath.indexOf('/')+1);

			if (shortPath.startsWith(PREFIX +  JCRRepository.serviceName))		
				absPath = shortPath.replaceAll(PREFIX + JCRRepository.serviceName, "");
			else if (path.startsWith(PREFIX_SHARE) || (path.startsWith("/Home/"+ getOwner().getPortalLogin()+ "/Workspace/")))
				absPath = path;
			else
				absPath = this.userHomePath + path;
			logger.trace("getItemByPath: " + absPath);
			//			String absPath = path;
			return getItemByAbsPath(session,absPath);
		} catch (InternalErrorException e) {
			throw new RuntimeException(e);
		} catch (RepositoryException e) {
			throw new ItemNotFoundException(e.getMessage());
		} finally {
			if (session != null)
				session.logout();
		}
	}


	//static method
	//	public static WorkspaceItem getWsItemByPath(String path)
	//			throws ItemNotFoundException {
	//		Validate.notNull(path, "path must be not null");
	//
	//		Session session = null;
	//		try {
	//			session = JCRRepository.getSession();
	//			String absPath = userHomePath +path;
	//			return getItemByPath(session, absPath);
	//		} catch (InternalErrorException e) {
	//			throw new RuntimeException(e);
	//		} catch (RepositoryException e) {
	//			throw new ItemNotFoundException(e.getMessage());
	//		} finally {
	//			if (session != null)
	//				session.logout();
	//		}
	//	}
	//
	//	public static WorkspaceItem getItemByPath(Session session, String path) throws ItemNotFoundException,
	//	InternalErrorException, RepositoryException {
	//
	//		Node nodeItem = null;
	//		try {
	//			nodeItem = session.getNode(path);
	//		} catch (javax.jcr.ItemNotFoundException e) {
	//			throw new ItemNotFoundException(e.getMessage());
	//		} 
	//		return getWorkspaceItem(nodeItem);
	//	}



	public WorkspaceItem getItemByAbsPath(Session session, String path) throws ItemNotFoundException,
	InternalErrorException, RepositoryException {

		Node nodeItem = null;
		try {
			nodeItem = session.getNode(path);
		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException(e.getMessage());
		} 
		return getWorkspaceItem(nodeItem);
	}


	@Override
	public WorkspaceTrashFolder getTrash() throws InternalErrorException, ItemNotFoundException {

		Session session = JCRRepository.getSession();
		try {
			return new JCRWorkspaceTrashFolder(this, session.getNode(trashPath));
		} catch (javax.jcr.ItemNotFoundException e) {
			throw new ItemNotFoundException(e.getMessage());
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}




	@Override
	public WorkspaceSharedFolder createSharedFolder(String name,
			String description, String groupId, String destinationFolderId,
			String displayName, boolean isVREFolder)
					throws InternalErrorException, InsufficientPrivilegesException,
					ItemAlreadyExistException, WrongDestinationException,
					ItemNotFoundException, WorkspaceFolderNotFoundException {
		logger.trace("Create workspace shared folder");

		String newName = getVREByScope(name);
		String newGroupId = getVREByScope(groupId);

		List<String> users = resolveGroupId(newGroupId);
		updateHomes(users);
		Session session = JCRRepository.getSession();
		try {
			String destinationFolderID = session.getNode(mySpecialFoldersPath).getIdentifier();
			if (exists(newName, destinationFolderID))
				throw new ItemAlreadyExistException("The item already exists");

			JCRWorkspaceItem item = (JCRWorkspaceItem)getItem(session,destinationFolderID);
			if (item.getType() != WorkspaceItemType.FOLDER)
				throw new WrongDestinationException("Destination is not a folder");

			if (item.isShared())
				throw new WrongDestinationException("Destination folder is already shared");

			Node sharedFolder = JCRRepository.getSharedRoot(session);
			Node node = sharedFolder.addNode(UUID.randomUUID().toString(),NT_WORKSPACE_SHARED_FOLDER);		

			List<String> users1 = new ArrayList<String>();
			users1.add(newGroupId);
			//			(JCRWorkspace workspace, Node node,
			//					String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName, String displayName, boolean isVreFolder) 
			JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, newName, 
					description, destinationFolderID, users1, null, null, displayName, isVREFolder);
			folder.save(node);

			fireItemCreatedEvent(folder);		

			if(isVREFolder)
				createVREManager(newName, folder);

			return folder;

		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (WrongItemTypeException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}


	private void createVREManager(String newName, JCRWorkspaceSharedFolder folder) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
		//create a VRE Manager user
		String manager = newName + "-Manager";
		List<String> usersList = new ArrayList<String>();
		usersList.add(manager);
		folder.share(usersList);	
	}



	//resolve groupId
	public List<String> resolveGroupId(String groupId) throws InternalErrorException {
		UserManager gm = HomeLibrary
				.getHomeManagerFactory().getUserManager();
		//		System.out.println("groupId " + groupId);
		GCubeGroup myGroup = gm.getGroup(groupId);
		List<String> members = myGroup.getMembers();
		//		System.out.println(members);
		return members;
	}

	//	@Override
	//	public String getMySpecialFoldersId() throws InternalErrorException{
	//		
	//		Session session;
	//		try {
	//			session = JCRRepository.getSession();
	//
	//			Node userHome = repository.getUserHome(session);
	//
	//			this.userHomePath = userHome.getPath();
	//
	//			Node wsNode = null;
	//			try {
	//				wsNode = userHome.addNode(WORKSPACE_ROOT_FOLDER,NT_WORKSPACE_FOLDER);
	//				this.root = new JCRWorkspaceFolder(this, wsNode, WORKSPACE_ROOT_FOLDER, "The root");
	//				this.root.save(wsNode);
	//			} catch (ItemExistsException e) {
	//				wsNode = userHome.getNode(WORKSPACE_ROOT_FOLDER);
	//				//				System.out.println("wsNode " + wsNode.getPath());
	//				this.root = new JCRWorkspaceFolder(this, wsNode);
	//			}
	//		//create a special folder to save VRE folders
	//		Node vreNode;
	//		try {
	//			vreNode = wsNode.addNode(SPECIAL_FOLDER, NT_WORKSPACE_FOLDER);
	//			this.mySpecialFolders = new JCRWorkspaceFolder(this, vreNode, SPECIAL_FOLDER, "My Special Folders");
	//			this.mySpecialFolders.save(vreNode);
	//		} catch (ItemExistsException e) {
	//			this.mySpecialFolders = new JCRWorkspaceFolder(this, wsNode.getNode(SPECIAL_FOLDER));
	//			vreNode = wsNode.getNode(SPECIAL_FOLDER);
	//		}
	//
	//		mySpecialFoldersId = vreNode.getIdentifier();
	//		return mySpecialFoldersId;
	//		}finally{
	//			session.logout();
	//		}
	//	}



	//	public String getTrashId(){
	//		return trashId;
	//	}

	@Override
	public List<WorkspaceItem> searchByProperties(List<String> properties)
			throws InternalErrorException {

		Session session = JCRRepository.getSession();
		NodeIterator iterator = null;
		List<WorkspaceItem> list = null;
		try {

			QueryManager queryManager = session.getWorkspace().getQueryManager();	

			StringBuilder query = new StringBuilder("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
					"/Workspace//element(*,nthl:workspaceItem)[");
			int i=0;
			for (String property: properties){
				if (i!=0)
					query.append(" and ");

				query.append("hl:metadata/@"+ property +"");
				i++;
			}

			query.append("]");
			logger.trace(query.toString());


			//			StringBuilder xpath =  new StringBuilder("/jcr:root/Home/" + getOwner().getPortalLogin()+"/Workspace" +
			//					"//element(*,nthl:gCubeItem)[hl:property/@Agency]");

			javax.jcr.query.Query q = queryManager.createQuery(query.toString(),
					javax.jcr.query.Query.XPATH);

			QueryResult result = q.execute();

			iterator = result.getNodes();

			list = new LinkedList<WorkspaceItem>();
			while (iterator != null && iterator.hasNext()) {

				Node node = iterator.nextNode();
				String itemName = isValidSearchResult(node);
				if (itemName == null) {
					logger.trace("Search result is not valid :" + node.getPath());
					continue;
				}

				try {
					WorkspaceItem item = getWorkspaceItem(node);
					list.add(item);		
				} catch (RepositoryException e) {
					try {
						logger.error("Item " + node.getName() + " unknow");
					} catch (RepositoryException e1) {
						logger.error("Error ",e1);
					}
				}
			}
		} catch (Exception e) {
			logger.error("Error getFolderItems", e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return list;
	}



	/**
	 * Check if the parent is in trash folder using xpath
	 * @param parentNode
	 * @return true if a node is in trash folder
	 * @throws InternalErrorException
	 * @throws RepositoryException 
	 */
	public boolean exists(String name, Node parentNode) throws InternalErrorException, RepositoryException {

		Session session = parentNode.getSession();
		String path = null;
		try{

			path = parentNode.getPath() + "/" + name;
			session.getItem(path);		
		}catch (Exception e) {
			logger.info(path + " does not exist yet");
			return false;
		}
		logger.info(path + " already exists");
		return true;
	}


	/**
	 * Check if the parent is in trash folder using xpath
	 * @param originalParentNode
	 * @return true if a node is in trash folder
	 * @throws InternalErrorException
	 * @throws RepositoryException 
	 */
	public boolean isInTrash(Node originalParentNode) throws InternalErrorException, RepositoryException {

		if (originalParentNode.getPath().contains("/Home/" + getHome().getOwner().getPortalLogin() +
				"/Workspace/Trash/"))
			return true;

		return false;

	}

	@Override
	public List<SearchFolderItem> searchFullText(String text)
			throws InternalErrorException {

		Session session = JCRRepository.getSession();
		NodeIterator iterator = null;
		List<SearchFolderItem> list = null;
		List<String> ids = null;
		try {

			QueryManager queryManager = session.getWorkspace().getQueryManager();	

			//			String sql2= "SELECT * FROM [nthl:workspaceItem] AS node WHERE contains(*, '" + text + "'))";


			//			String trashPath = path + "/Trash";
			//			String sql2= "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" +	
			//					" AND CONTAINS(node.*, '" + text + "')" +
			//					" AND NOT(ISDESCENDANTNODE ('" + trashPath + "'))";
			//
			//
			//						System.out.println(sql2);
			//			javax.jcr.query.Query q = queryManager.createQuery(sql2,javax.jcr.query.Query.JCR_SQL2);


			StringBuilder query = new StringBuilder("/jcr:root/Home/" + getHome().getOwner().getPortalLogin() +
					"/Workspace//element(*,nthl:workspaceItem)[jcr:contains(., '" + text + "')]");

			logger.trace(query.toString());

			javax.jcr.query.Query q = queryManager.createQuery(query.toString(),
					javax.jcr.query.Query.XPATH);

			QueryResult result = q.execute();

			iterator = result.getNodes();

			list = new LinkedList<SearchFolderItem>();
			ids = new ArrayList<String>();

			while (iterator != null && iterator.hasNext()) {

				Node node = iterator.nextNode();
				String id = node.getIdentifier();
				String itemName = isValidSearchResult(node);
				if (itemName == null) {
					logger.trace("Search result is not valid :" + node.getPath());
					continue;
				}

				try {
					if (!ids.contains(id)){
						list.add(new JCRSearchFolderItem(node, 
								getFolderItemType(node),itemName));		
						ids.add(id);
					}
				} catch (RepositoryException e) {
					try {
						logger.error("Item " + node.getName() + " unknow");
					} catch (RepositoryException e1) {
						logger.error("Error ",e1);
					}
				}

			}
			logger.info("Results: " + list.size());
		} catch (Exception e) {
			logger.error("Error getFolderItems", e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return list;
	}


	/**
	 * Workspace initialization: check workspace folders
	 * @param portalLogin
	 * @throws PathNotFoundException
	 * @throws RepositoryException
	 * @throws InternalErrorException
	 */
	public void init(String portalLogin) throws PathNotFoundException, RepositoryException, InternalErrorException{

		JCRUserManager um = new JCRUserManager();
		Session session = null;
		try {
			String userVersion = JCRRepository.getUserVersion(portalLogin, null);
			logger.info(portalLogin + " --> USER VERSION: " + userVersion + " - HL VERSION: " + JCRRepository.HLversion);

			if(!JCRRepository.HLversion.equals(userVersion)){

				session = JCRRepository.getSession();

				Node userHome = session.getNode("/" + HOME_FOLDER + "/" + portalLogin);

				Node wsNode = null;
				try {
					wsNode = userHome.addNode(WORKSPACE_ROOT_FOLDER,NT_WORKSPACE_FOLDER);
					this.root = new JCRWorkspaceFolder(this, wsNode, WORKSPACE_ROOT_FOLDER, "The root");
					this.root.save(wsNode);

					String wsRootPath = "/" + HOME_FOLDER + "/" +  portalLogin + "/" + WORKSPACE_ROOT_FOLDER;
					logger.info("Set ACL on: " + wsRootPath);
					JCRRepository.setACL(portalLogin, wsRootPath);

				} catch (ItemExistsException e) {
					wsNode = userHome.getNode(WORKSPACE_ROOT_FOLDER);
					logger.info("Getting workspace node: " + wsNode.getPath());
					this.root = new JCRWorkspaceFolder(this, wsNode);
				}

				//create applicationFolder
				try {
					Node node = wsNode.addNode(APPLICATION_FOLDER,NT_WORKSPACE_FOLDER);
					this.applicationFolder = new JCRWorkspaceFolder(this, node, APPLICATION_FOLDER, "Applications folder");
					this.applicationFolder.save(node);
				} catch (ItemExistsException e) {
					this.applicationFolder = new JCRWorkspaceFolder(this, wsNode.getNode(APPLICATION_FOLDER));
				}

				//create Trash Folder
				Node trashNode;
				try {
					trashNode = wsNode.addNode(TRASH,NT_WORKSPACE_FOLDER);
					this.trashFolder = new JCRWorkspaceFolder(this, trashNode, TRASH, "Trash folder");
					this.trashFolder.save(trashNode);
				} catch (ItemExistsException e) {
					this.trashFolder = new JCRWorkspaceFolder(this, wsNode.getNode(TRASH));
					trashNode = wsNode.getNode(TRASH);
				}

				//create a special folder to save VRE folders
				Node vreNode;
				try {
					vreNode = wsNode.addNode(SPECIAL_FOLDER, NT_WORKSPACE_FOLDER);
					this.mySpecialFolders = new JCRWorkspaceFolder(this, vreNode, SPECIAL_FOLDER, "My Special Folders");
					this.mySpecialFolders.save(vreNode);
				} catch (ItemExistsException e) {
					this.mySpecialFolders = new JCRWorkspaceFolder(this, wsNode.getNode(SPECIAL_FOLDER));
					vreNode = wsNode.getNode(SPECIAL_FOLDER);
				}

				session.save();
				um.setVersionByUser(portalLogin, JCRRepository.HLversion);
			}else
				logger.info("skip init in JCRWorkspace for user: " + portalLogin );
		}catch (InternalErrorException e) {
			throw new InternalErrorException(e);
		} finally {
			if (session!=null)
				session.logout();
		}
	}


	/**
	 * Replace "/" with "-" in scope
	 * @param scope
	 * @return
	 */
	private String getVREByScope(String scope) {
		String newName;
		if (scope.startsWith("/"))			
			newName = scope.replace("/", "-").substring(1);
		else
			newName = scope.replace("/", "-");
		return newName;
	}


	/**
	 * Get VREFolder by scope
	 * @param scope
	 * @return VREFolder
	 * @throws ItemNotFoundException 
	 * @throws InternalErrorException 
	 */
	@Override
	public WorkspaceSharedFolder getVREFolderByScope(String scope) throws ItemNotFoundException, InternalErrorException {
		String VRE = getVREByScope(scope);		
		WorkspaceSharedFolder folder = (WorkspaceSharedFolder) getItemByPath(mySpecialFoldersPath + "/"+ VRE);
		return folder;
	}





	/**
	 * Get the disk usage amount of the current user 
	 * @return the disk usage amount of current user
	 * @throws RemoteBackendException
	 */
	@Override
	public long getDiskUsage() throws InternalErrorException{
		logger.trace("get getDiskUsage of user " + portalLogin);
		long diskUsage = 0;
		try{
			diskUsage = GCUBEStorage.getDiskUsageByUser(portalLogin);
		}catch (Exception e) {
			logger.error("Error retrieving disk usage ", e);
		}
		return diskUsage;

	}

	/**
	 * Get tot items of the current user 
	 * @return tot items of the current user 
	 * @throws RemoteBackendException
	 */
	@Override
	public int getTotalItems() throws InternalErrorException{
		logger.trace("get getTotalItems of user " + portalLogin);

		int totItems = 0;
		try{
			totItems = GCUBEStorage.getTotalItemsByUser(portalLogin);
		}catch (Exception e) {
			logger.error("Error retrieving total items ", e);
		}
		return totItems;


	}



}
