/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.GenericItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.events.AbstractWorkspaceEventSource;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItemByOperator;
import org.gcube.common.homelibrary.home.workspace.search.util.SearchQuery;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.sharing.JCRWorkspaceMessageManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSmartFolder;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalUrl;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRGCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRQuery;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReportTemplate;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRTimeSeries;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkflowReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolder;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashFolder;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.common.homelibrary.util.Util;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspace
extends AbstractWorkspaceEventSource
implements Workspace {
    public static final String HOME_FOLDER = "Home";
    private static final String WORKSPACE_ROOT_FOLDER = "Workspace";
    private static final String APPLICATION_FOLDER = ".applications";
    private static final String TRASH = "Trash";
    private static final String SPECIAL_FOLDER = "MySpecialFolders";
    private static final String PREFIX_SHARE = "/Share/";
    private static final String PREFIX = "home/org.gcube.portlets.user/";
    private final Home home;
    public final JCRRepository repository;
    private final JCRFolderBulkCreatorManager folderBulkCreatorsManager;
    private JCRWorkspaceMessageManager sendRequestManager;
    public String portalLogin;
    public String userWorkspace;
    private String userHome;
    public String trashPath;
    public String applicationFolderPath;
    public String mySpecialFoldersPath;
    public String rootId;
    public JCRWorkspaceFolder applicationFolder;
    public JCRWorkspaceFolder trashFolder;
    public JCRWorkspaceFolder mySpecialFolders;
    private Logger logger;
    private GCUBEStorage storage = null;

    public JCRWorkspace(Home home, JCRRepository repository) throws InternalErrorException {
        this.home = home;
        this.portalLogin = this.getOwner().getPortalLogin();
        this.userHome = "/Home/" + this.portalLogin;
        this.userWorkspace = this.userHome + "/" + WORKSPACE_ROOT_FOLDER + "/";
        this.applicationFolderPath = this.userWorkspace + APPLICATION_FOLDER;
        this.trashPath = this.userWorkspace + TRASH;
        this.mySpecialFoldersPath = this.userWorkspace + SPECIAL_FOLDER;
        this.repository = repository;
        this.folderBulkCreatorsManager = new JCRFolderBulkCreatorManager(this);
        this.logger = LoggerFactory.getLogger(JCRWorkspace.class);
        try {
            this.init(this.portalLogin);
        }
        catch (RepositoryException e1) {
            this.logger.error("Error init ", (Throwable)e1);
        }
        catch (ItemNotFoundException e) {
            this.logger.error("Error init workspace ", (Throwable)e);
        }
    }

    public GCUBEStorage getStorage() {
        if (this.storage == null) {
            try {
                this.storage = new GCUBEStorage(this.portalLogin);
            }
            catch (Exception e) {
                this.logger.error("Error getting Storage ", (Throwable)e);
            }
        }
        return this.storage;
    }

    public JCRWorkspace(JCRHome home) {
        this.home = home;
        this.repository = null;
        this.folderBulkCreatorsManager = null;
    }

    private ItemDelegate addChildNode(String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {
        ItemDelegate parent;
        Validate.notNull((Object)parentId, (String)"Destination folder must be not null");
        Validate.notNull((Object)nodeName, (String)"Name must be not null");
        if (!this.isValidName(nodeName)) {
            this.logger.error("The name  " + nodeName + "contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        try {
            parent = JCRRepository.getServlets().getItemById(parentId);
            JCRWorkspaceItem item = this.getWorkspaceItem(parent);
            if (item.isShared() && !JCRPrivilegesInfo.canAddChildren(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), parent.getPath())) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
            }
            if (!(parent.getPrimaryType().equals("nthl:workspaceItem") || parent.getPrimaryType().equals("nthl:workspaceSharedItem") || parent.getPrimaryType().equals("nt:folder"))) {
                throw new WrongDestinationException("Not is a folder");
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Destination folder not found");
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        try {
            DelegateManager wrap = new DelegateManager(parent, this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.addNode(nodeName, nodeType);
            return node;
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    private ItemDelegate createItemDelegate(String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {
        ItemDelegate parent;
        Validate.notNull((Object)parentId, (String)"Destination folder must be not null");
        Validate.notNull((Object)nodeName, (String)"Name must be not null");
        if (!this.isValidName(nodeName)) {
            this.logger.error("The name  " + nodeName + "contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        try {
            parent = JCRRepository.getServlets().getItemById(parentId);
            JCRWorkspaceItem item = this.getWorkspaceItem(parent);
            if (item.isShared() && !JCRPrivilegesInfo.canAddChildren(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), parent.getPath())) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
            }
            if (!(parent.getPrimaryType().equals("nthl:workspaceItem") || parent.getPrimaryType().equals("nthl:workspaceSharedItem") || parent.getPrimaryType().equals("nt:folder"))) {
                throw new WrongDestinationException("Not is a folder");
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Destination folder not found");
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        try {
            DelegateManager wrap = new DelegateManager(parent, this.getOwner().getPortalLogin());
            ItemDelegate delegate = wrap.addNode(nodeName, nodeType);
            delegate.setPath(parent.getPath() + "/" + nodeName);
            return delegate;
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPathSeparator() {
        return "/";
    }

    public Home getHome() {
        return this.home;
    }

    public JCRRepository getRepository() {
        return this.repository;
    }

    public User getOwner() {
        return this.home.getOwner();
    }

    public WorkspaceFolder getRoot() {
        JCRWorkspaceFolder root = null;
        try {
            this.logger.info("Getting Workspace: " + this.userWorkspace);
            ItemDelegate wsNode = null;
            try {
                wsNode = JCRRepository.getServlets().getItemByPath(this.userWorkspace, this.getOwner().getPortalLogin());
            }
            catch (ItemNotFoundException e) {
                this.logger.error("Root WorkspaceFolder not found", (Throwable)e);
            }
            root = new JCRWorkspaceFolder(this, wsNode);
            try {
                this.rootId = root.getId();
            }
            catch (InternalErrorException e) {
                e.printStackTrace();
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Root WorkspaceFolder not found", (Throwable)e);
        }
        return root;
    }

    public WorkspaceFolder createFolder(String name, String description, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace folder");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate parent = servlets.getItemById(destinationFolderId);
            JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(parent);
            if (destinationFolder.isShared() && !JCRPrivilegesInfo.canAddChildren(destinationFolder.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), parent.getPath())) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to add the folder");
            }
            ItemDelegate node = this.createItemDelegate(destinationFolderId, name, "nthl:workspaceItem");
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save();
            try {
                this.logger.info(name + " has been added to parent folder " + parent.getPath());
                JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), folder.getType(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getFolderItemType() : null, folder.getName(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getMimeType() : null);
                entry.save();
            }
            catch (Exception e) {
                this.logger.error("Error setting add accounting entry for " + name + " to parent folder " + parent.getPath());
            }
            this.fireItemCreatedEvent(folder);
            return folder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, InputStream imageData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        ExternalImage image;
        this.logger.trace("Create external image");
        File tmpFile = null;
        try {
            tmpFile = WorkspaceUtil.getTmpFile((InputStream)imageData);
            image = this.createExternalImage(name, description, mimeType, destinationFolderId, tmpFile);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return image;
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, String destinationFolderId, File tmpFile) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external image");
        JCRExternalImage item = null;
        try {
            ItemDelegate delegate = this.createItemDelegate(destinationFolderId, name, "nthl:externalImage");
            try {
                item = new JCRExternalImage(this, delegate, name, description, mimeType, tmpFile);
                item.save();
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            this.setAccountingOnParent(delegate, item);
            this.fireItemCreatedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return item;
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        ExternalFile file;
        this.logger.trace("Create external file from inpustream");
        File tmpFile = null;
        try {
            tmpFile = WorkspaceUtil.getTmpFile((InputStream)fileData);
            file = this.createExternalFile(name, description, mimeType, tmpFile, destinationFolderId);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return file;
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, File tmpFile, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external file");
        JCRExternalFile item = null;
        try {
            ItemDelegate node = this.createItemDelegate(destinationFolderId, name, "nthl:externalFile");
            item = new JCRExternalFile(this, node, name, description, mimeType, tmpFile);
            item.save();
            this.setAccountingOnParent(node, item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return item;
    }

    private void setAccountingOnParent(ItemDelegate node, JCRExternalFile item) throws InternalErrorException, RepositoryException {
        try {
            this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
            JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null);
            entry.save();
        }
        catch (Exception e) {
            this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
        }
        this.fireItemCreatedEvent(item);
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, File tmpFile, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external pdf file");
        JCRExternalPDFFile item = null;
        try {
            ItemDelegate node = this.createItemDelegate(destinationFolderId, name, "nthl:externalPdf");
            item = new JCRExternalPDFFile(this, node, name, description, mimeType, tmpFile);
            item.save();
            this.setAccountingOnParent(node, item);
            this.fireItemCreatedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return item;
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        ExternalPDFFile pdf;
        this.logger.trace("Create external pdf file");
        File tmpFile = null;
        try {
            tmpFile = WorkspaceUtil.getTmpFile((InputStream)fileData);
            pdf = this.createExternalPDFFile(name, description, mimeType, tmpFile, destinationFolderId);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return pdf;
    }

    public ExternalUrl createExternalUrl(String name, String description, String url, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external url");
        JCRExternalUrl item = null;
        try {
            ItemDelegate node = this.createItemDelegate(destinationFolderId, name, "nthl:externalUrl");
            try {
                item = new JCRExternalUrl(this, node, name, description, url);
                item.save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            this.fireItemCreatedEvent(item);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return item;
    }

    public ExternalUrl createExternalUrl(String name, String description, File tmpFile, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        ExternalUrl url;
        this.logger.trace("Create external url");
        try {
            url = this.createExternalUrl(name, description, tmpFile, destinationFolderId);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return url;
    }

    public ExternalUrl createExternalUrl(String name, String description, InputStream url, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String urlString;
        try {
            urlString = Util.readStreamAsString((InputStream)url);
        }
        catch (IOException e) {
            throw new InternalErrorException("Error converting url from input stream to string.");
        }
        return this.createExternalUrl(name, description, urlString, destinationFolderId);
    }

    public void removeItem(String itemId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        ItemDelegate itemDelegate = null;
        try {
            itemDelegate = JCRRepository.getServlets().getItemById(itemId);
            this.logger.trace("Remove node " + itemDelegate.getPath());
            JCRWorkspaceItem item = this.getWorkspaceItem(itemDelegate);
            if (item.isShared()) {
                this.logger.debug("the item is shared: " + itemDelegate.getPath());
                if (!JCRPrivilegesInfo.canDelete(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), itemDelegate.getPath(), false)) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node " + itemDelegate.getPath());
                }
            }
            try {
                JCRAccountingFolderEntryRemoval entry = new JCRAccountingFolderEntryRemoval(itemDelegate.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null);
                entry.save();
            }
            catch (Exception e) {
                this.logger.error("Impossible to set Removal Accounting Entry to parent of " + itemDelegate.getPath());
            }
            this.fireItemRemovedEvent(this.getWorkspaceItem(itemDelegate));
            this.moveToTrash(itemDelegate);
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveToTrash(ItemDelegate nodeToTrash) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, RepositoryException {
        long length = 0L;
        String mimeType = null;
        boolean isFolder = false;
        String name = nodeToTrash.getName();
        String description = "move to trash " + nodeToTrash.getName();
        String parentId = nodeToTrash.getParentId();
        String originalPath = null;
        try {
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(nodeToTrash.getId());
            if (!item.getType().equals((Object)WorkspaceItemType.SHARED_FOLDER)) {
                try {
                    originalPath = item.getParent().getPath();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (item.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                isFolder = true;
            } else {
                this.logger.info("Try to get mimetype and lenght from file");
                try {
                    mimeType = ((FolderItem)item).getMimeType();
                }
                catch (Exception e) {
                    this.logger.error("mime type not present");
                }
                try {
                    length = ((FolderItem)item).getLength();
                }
                catch (Exception e) {
                    this.logger.error("lenght not present");
                }
            }
            try {
                String trashId = JCRRepository.getServlets().getItemByPath(this.trashPath, this.getOwner().getPortalLogin()).getId();
                ItemDelegate trashNode = this.createItemDelegate(trashId, nodeToTrash.getId(), "nthl:trashItem");
                JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this, trashNode, name, description, Calendar.getInstance(), this.getOwner().getPortalLogin(), parentId, mimeType, length, isFolder, originalPath);
                ItemDelegate savedNode = trashItem.save();
                this.moveNodeTo(nodeToTrash, savedNode);
            }
            catch (InsufficientPrivilegesException | ItemAlreadyExistException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void checkDestination(ItemDelegate node, ItemDelegate destinationNode) throws WrongDestinationException, InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException {
        try {
            if (destinationNode.getPath().equals(this.trashPath)) {
                return;
            }
            if (!(destinationNode.getPrimaryType().equals("nthl:workspaceItem") || destinationNode.getPrimaryType().equals("nthl:workspaceSharedItem") || destinationNode.getPrimaryType().equals("nthl:trashItem"))) {
                this.logger.error("Destination is not a folder");
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (destinationNode.getPath().equals(this.mySpecialFoldersPath)) {
                throw new WrongDestinationException("Not allowed to move files or folders in Special Folders");
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(node);
            JCRWorkspaceItem itemDestination = this.getWorkspaceItem(destinationNode);
            String query = "/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)item.getPath()) + "//element(*,nthl:workspaceSharedItem)";
            List<SearchItemDelegate> result = null;
            try {
                JCRServlets servlets = JCRRepository.getServlets();
                result = servlets.executeQuery(query, "xpath", this.getOwner().getPortalLogin(), 0);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            if (itemDestination.isShared() && !item.isShared() && result.size() > 0 || itemDestination.isShared() && item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                throw new WrongDestinationException("Not allowed to move in an other destination folder already shared");
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem moveItem(String itemId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.debug("Move item with id " + itemId + "to destination with id " + destinationFolderId);
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination folder id must be not null");
        JCRServlets servlets = JCRRepository.getServlets();
        ItemDelegate nodeItem = null;
        JCRWorkspaceItem item = null;
        ItemDelegate nodeDestination = null;
        try {
            try {
                nodeItem = servlets.getItemById(itemId);
                item = this.getWorkspaceItem(nodeItem);
            }
            catch (javax.jcr.ItemNotFoundException e) {
                this.logger.error("Item with id " + itemId + " not found");
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error retrieving item with id " + itemId);
                throw new InternalErrorException((Throwable)e);
            }
            try {
                nodeDestination = servlets.getItemById(destinationFolderId);
            }
            catch (Exception e) {
                this.logger.error("Destination not found");
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            if (this.exists(nodeItem.getName(), destinationFolderId)) {
                this.logger.error("Item with name " + nodeItem.getName() + " exists in folder " + nodeDestination.getPath());
                throw new ItemAlreadyExistException("Item " + nodeItem.getName() + " already exists in folder " + nodeDestination.getPath());
            }
            try {
                this.logger.trace("nodeDestination: " + nodeDestination.getPath());
                this.checkDestination(nodeItem, nodeDestination);
                String idSharedFolder = item.getIdSharedFolder();
                if (idSharedFolder != item.getId() && idSharedFolder != null) {
                    this.logger.debug("the item is shared: " + nodeItem.getPath());
                    if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), nodeItem.getPath(), false)) {
                        throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
                    }
                }
                JCRAbstractWorkspaceFolder parentItem = item.getParent();
                JCRWorkspaceItem destinationItem = this.getWorkspaceItem(nodeDestination);
                if (destinationItem.isShared() && !JCRPrivilegesInfo.canAddChildren(destinationItem.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), nodeDestination.getPath())) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
                }
                this.logger.debug("Adding accounting entry ....");
                try {
                    JCRAccountingFolderEntryCut entry = new JCRAccountingFolderEntryCut(parentItem.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null);
                    entry.save();
                }
                catch (Exception e) {
                    this.logger.error("Error Set cut accounting entry to folder parent item ");
                }
                JCRAccountingFolderEntryAdd entryAdd = new JCRAccountingFolderEntryAdd(destinationItem.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null);
                entryAdd.save();
                try {
                    JCRAccountingEntryPaste entryPaste = new JCRAccountingEntryPaste(item.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getParent().getName());
                    entryPaste.save();
                }
                catch (Exception e) {
                    this.logger.error("Error Set PASTE accounting entry to item ");
                }
                String newRemotePath = null;
                if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                    newRemotePath = nodeDestination.getPath() + this.getPathSeparator() + item.getName();
                    try {
                        this.getStorage().moveRemoteFile(item.getRemotePath(), newRemotePath, this.home.getOwner().getPortalLogin());
                    }
                    catch (Exception e) {
                        this.logger.error("Error setting remotePath to " + item.getPath());
                    }
                } else if (item.getType() == WorkspaceItemType.FOLDER) {
                    newRemotePath = nodeDestination.getPath();
                    this.moveDir(item, newRemotePath + this.getPathSeparator() + nodeItem.getName(), nodeItem);
                }
                item.internalMove(nodeDestination, newRemotePath);
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error moving item with id " + itemId + " to WorkspaceFolder with id " + destinationFolderId);
                throw new InternalErrorException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return item;
    }

    private void moveDir(WorkspaceItem folder, String destinationPath, ItemDelegate node) throws InternalErrorException {
        for (WorkspaceItem item : folder.getChildren()) {
            String path = destinationPath + this.getPathSeparator() + item.getName();
            try {
                String remotePath = item.getRemotePath();
                this.logger.trace("Update remotePath: " + remotePath + " to: " + path);
                try {
                    this.getStorage().moveRemoteFile(remotePath, path, this.home.getOwner().getPortalLogin());
                }
                catch (Exception e) {
                    this.logger.error("Not possible to move " + remotePath + " to " + path);
                }
                this.logger.trace("moved from " + remotePath + " to " + path);
                JCRWorkspaceItem jcrItem = (JCRWorkspaceItem)item;
                jcrItem.setRemotePath(path);
                this.logger.trace("set Remote Path property to node: " + path);
                this.moveDir(item, path, node);
            }
            catch (Exception e) {
                this.logger.warn("Error setting new remotePath to " + item.getName());
            }
        }
    }

    public void moveNodeTo(ItemDelegate nodeItem, ItemDelegate destinationNode) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)nodeItem, (String)"Node must be not null");
        Validate.notNull((Object)destinationNode, (String)"Destination folder Node must be not null");
        try {
            this.logger.debug("Move from " + nodeItem.getPath() + "to Trash ");
            try {
                JCRWorkspaceItem item = this.getWorkspaceItem(nodeItem);
                String newRemotePath = null;
                if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                    newRemotePath = destinationNode.getPath() + "/" + item.getName();
                    try {
                        this.getStorage().moveRemoteFile(item.getRemotePath(), newRemotePath, this.home.getOwner().getPortalLogin());
                    }
                    catch (Exception e) {
                        this.logger.error("Error setting remotePath to " + item.getPath());
                    }
                } else if (item.getType() == WorkspaceItemType.FOLDER) {
                    newRemotePath = destinationNode.getPath();
                    this.moveDir(item, newRemotePath, nodeItem);
                }
                item.internalMove(destinationNode, newRemotePath);
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error moving item " + nodeItem.getPath() + " to WorkspaceFolder " + destinationNode.getPath());
                throw new InternalErrorException((Throwable)e);
            }
            DelegateManager wrap = null;
            try {
                wrap = new DelegateManager(nodeItem, this.getOwner().getPortalLogin());
                wrap.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveSharedItem(ItemDelegate sharedNode) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, RepositoryException {
        Validate.notNull((Object)sharedNode, (String)"Item id must be not null");
        this.logger.debug("sharedFolder: " + sharedNode.getPath());
        try {
            JCRWorkspaceItem item = this.getWorkspaceItem(sharedNode);
            if (item.isShared()) {
                this.logger.debug("the item " + item.getPath() + " is shared");
                if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), item.getPath(), false)) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
                }
            }
            String newRemotePath = null;
            this.logger.debug("item.getType() " + item.getType());
            if (item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                newRemotePath = sharedNode.getPath();
                this.logger.debug("base Path " + newRemotePath);
                this.moveToShare(item, newRemotePath);
                this.logger.debug("moveToShare finished");
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Fatal error moving item with id " + sharedNode);
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void moveToShare(WorkspaceItem item, String destinationPath) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        this.logger.debug("WorkspaceItem " + item + " - destinationPath " + destinationPath);
        for (WorkspaceItem child : item.getChildren()) {
            String path = destinationPath + "/" + child.getName();
            this.logger.debug("path " + path);
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
                    String remotePath = child.getRemotePath();
                    this.logger.trace("Calling GCUBEStorage: update remotePath: " + remotePath + " to: " + path);
                    this.getStorage().moveRemoteFile(remotePath, path, this.home.getOwner().getPortalLogin());
                    this.logger.debug("moved from " + remotePath + " to " + path);
                    JCRWorkspaceItem JCRchild = (JCRWorkspaceItem)child;
                    JCRchild.setRemotePath(path);
                    this.logger.debug("property to node: " + child.getRemotePath() + " has been set");
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.moveToShare(child, path);
        }
    }

    public void renameItem(String itemId, String newName) throws ItemNotFoundException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        if (!this.isValidName(newName)) {
            throw new IllegalArgumentException("Invalid item name");
        }
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate parentNode;
            ItemDelegate itemDelegate;
            try {
                itemDelegate = servlets.getItemById(itemId);
                parentNode = servlets.getItemById(itemDelegate.getParentId());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            JCRWorkspaceItem item = null;
            try {
                item = this.getWorkspaceItem(itemDelegate);
                if (item.isShared()) {
                    this.logger.debug("the item is shared: " + itemDelegate.getPath());
                    if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), itemDelegate.getPath(), false)) {
                        throw new InsufficientPrivilegesException("Insufficient Privileges to rename the node");
                    }
                }
                JCRAccountingEntryRenaming entryRenaming = new JCRAccountingEntryRenaming(item.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getName());
                entryRenaming.save();
                try {
                    JCRAccountingEntryRenaming entryParent = new JCRAccountingEntryRenaming(itemDelegate.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getName());
                    entryParent.save();
                }
                catch (Exception e) {
                    this.logger.error("Impossible to set rename operation to parent of node " + itemDelegate.getPath());
                }
                String newRemotePath = parentNode.getPath() + this.getPathSeparator() + newName;
                try {
                    if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                        this.getStorage().moveRemoteFile(item.getRemotePath(), newRemotePath, this.getOwner().getPortalLogin());
                    } else if (item.getType() == WorkspaceItemType.FOLDER) {
                        this.moveDir(item, newRemotePath, itemDelegate);
                    }
                    item.internalRename(newName, newRemotePath);
                }
                catch (RemoteBackendException e) {
                    this.logger.error("Error setting remotePath to " + item.getPath());
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            this.fireItemRenamedEvent(item);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void changeDescription(String itemId, String newDescription) throws ItemNotFoundException, InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate nodeItem = servlets.getItemById(itemId);
            this.getWorkspaceItem(nodeItem).internalDescription(newDescription);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public WorkspaceItem getItem(String itemId) throws ItemNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        ItemDelegate nodeItem = null;
        try {
            nodeItem = JCRRepository.getServlets().getItemById(itemId);
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        JCRWorkspaceItem item = null;
        try {
            item = this.getWorkspaceItem(nodeItem);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        return item;
    }

    public Capabilities getCapabilities(String itemId) throws ItemNotFoundException, InternalErrorException {
        return null;
    }

    public void removeChild(String childId, String folderId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        Validate.notNull((Object)childId, (String)"Child Id must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate parent = servlets.getItemById(folderId);
            if (!parent.getPrimaryType().equals("nthl:workspaceItem")) {
                throw new WrongParentTypeException("Item with id " + folderId + " isn't a folder item");
            }
            this.removeItem(childId);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void remove(String itemName, String folderId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        JCRServlets servlets = JCRRepository.getServlets();
        ItemDelegate nodeFolder = null;
        try {
            nodeFolder = servlets.getItemById(folderId);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        try {
            DelegateManager wrap = new DelegateManager(nodeFolder, this.getOwner().getPortalLogin());
            ItemDelegate childNode = wrap.getNode(itemName);
            this.removeItem(childNode.getId());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem copy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"ItemId must be not null");
        Validate.notNull((Object)newName, (String)"NewName must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        if (!this.isValidName(newName)) {
            this.logger.error("The name contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        return this.internalCopy(itemId, newName, destinationFolderId);
    }

    public WorkspaceItem copy(String itemId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"destinationFolder id must be not null");
        return this.internalCopy(itemId, null, destinationFolderId);
    }

    public void copyRemoteContent(ItemDelegate node, ItemDelegate nodeDestinationFolder) throws RepositoryException, InternalErrorException, RemoteBackendException {
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            ItemDelegate childDelegate = JCRRepository.getServlets().getItemById(child.getId());
            this.copyRemoteContent(childDelegate, nodeDestinationFolder);
        }
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            ((JCRWorkspaceFolderItem)item).copyRemoteContent(node);
        }
    }

    private WorkspaceItem internalCopy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {
        JCRServlets servlet = JCRRepository.getServlets();
        JCRWorkspaceItem newItem = null;
        try {
            ItemDelegate itemDelegate = null;
            try {
                itemDelegate = servlet.getItemById(itemId);
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            ItemDelegate destinationDelegate = null;
            try {
                if (destinationFolderId == null) {
                    destinationFolderId = itemDelegate.getParentId();
                }
                if (!(destinationDelegate = servlet.getItemById(destinationFolderId)).getPrimaryType().equals("nthl:workspaceItem") && !destinationDelegate.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                    throw new WrongDestinationException("Destination is not a folder");
                }
            }
            catch (Exception e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(itemDelegate);
            String query = ISO9075.encodePath((String)("/jcr:root/Home/" + this.getOwner().getPortalLogin() + item.getPath())) + "//element(*,nthl:workspaceSharedItem)";
            List<SearchItemDelegate> itemDelegateList = null;
            try {
                itemDelegateList = servlet.executeQuery(query, "xpath", this.getOwner().getPortalLogin(), 0);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            if (!item.isShared() && itemDelegateList.size() > 0) {
                throw new WrongDestinationException("Not allowed to copy a folder with some discendents item shared ");
            }
            if (newName == null) {
                newName = item.getName();
            }
            ItemDelegate newNode = item.internalCopy(destinationDelegate, newName);
            newItem = this.getWorkspaceItem(newNode);
            this.copyRemoteContent(newNode, destinationDelegate);
            Calendar now = Calendar.getInstance();
            JCRAccountingEntryPaste entryPaste = new JCRAccountingEntryPaste(newItem.getId(), this.getOwner().getPortalLogin(), now, destinationDelegate.getTitle());
            entryPaste.save();
            if (destinationDelegate != null) {
                this.logger.debug("Set ADD accounting entry to destination folder " + destinationDelegate.getPath());
                JCRAccountingFolderEntryAdd entryAdd = new JCRAccountingFolderEntryAdd(destinationFolderId, this.getOwner().getPortalLogin(), now, item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null);
                entryAdd.save();
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newItem;
    }

    public WorkspaceItem cloneItem(String itemId, String cloneName) throws ItemNotFoundException, ItemAlreadyExistException, InsufficientPrivilegesException, InternalErrorException, WrongDestinationException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"itemId must be not null");
        if (!this.isValidName(cloneName)) {
            throw new IllegalArgumentException("cloneName is a not valid name");
        }
        return this.internalCopy(itemId, cloneName, null);
    }

    public boolean exists(String name, String folderId) throws InternalErrorException, ItemNotFoundException, WrongItemTypeException {
        ItemDelegate folderNode;
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            folderNode = servlets.getItemById(folderId);
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        if (!this.isValidName(name)) {
            return false;
        }
        DelegateManager wrap = new DelegateManager(folderNode, this.getOwner().getPortalLogin());
        try {
            ItemDelegate item = wrap.getNode(name);
            item.getPath();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean exists(String itemId) throws InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate myItem = servlets.getItemById(itemId);
            myItem.getId();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public WorkspaceItem find(String name, String folderId) throws InternalErrorException, ItemNotFoundException, WrongItemTypeException {
        JCRServlets servlets = JCRRepository.getServlets();
        ItemDelegate nodeFolder = servlets.getItemById(folderId);
        DelegateManager wrap = new DelegateManager(nodeFolder, this.getOwner().getPortalLogin());
        try {
            ItemDelegate node = wrap.getNode(name);
            return this.getWorkspaceItem(node);
        }
        catch (Exception e) {
            return null;
        }
    }

    public WorkspaceItem find(String path) throws InternalErrorException {
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            String[] strings = path.split("/");
            String pathCleaned = "";
            for (String string : strings) {
                pathCleaned = pathCleaned + "/" + Text.escapeIllegalJcrChars((String)string);
            }
            ItemDelegate rootNode = servlets.getItemById(this.getRoot().getId());
            ItemDelegate node = null;
            try {
                node = servlets.getItemByPath(rootNode.getPath() + pathCleaned, this.getOwner().getPortalLogin());
            }
            catch (ItemNotFoundException e) {
                e.printStackTrace();
            }
            return this.getWorkspaceItem(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !name.contains("/");
    }

    public FolderBulkCreator getNewFolderBulkCreator(String folderId) throws WorkspaceFolderNotFoundException, WrongItemTypeException, InternalErrorException {
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate folderNode;
            try {
                folderNode = servlets.getItemById(folderId);
            }
            catch (Exception e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                if (!folderNode.getPrimaryType().equals("nthl:workspaceItem")) {
                    throw new WrongItemTypeException("A FolderBulkCreator can be created  only for a folder");
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, folderNode);
            return this.folderBulkCreatorsManager.getFolderBulk(folder);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public FolderBulkCreatorManager getFolderBulkCreatorManager() {
        return this.folderBulkCreatorsManager;
    }

    public WorkspaceMessageManager getWorkspaceMessageManager() {
        if (this.sendRequestManager == null) {
            this.sendRequestManager = new JCRWorkspaceMessageManager(this);
        }
        return this.sendRequestManager;
    }

    public WorkspaceFolder decomposeAquaMapsItem(String itemId, String folderName, String destinationWorkspaceId) throws WrongItemTypeException, WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException {
        return null;
    }

    public JCRWorkspaceItem getWorkspaceItem(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        String type = delegate.getPrimaryType();
        System.out.println("delegate " + delegate.getPath() + " - type " + type);
        switch (type) {
            case "nthl:workspaceItem": {
                return new JCRWorkspaceFolder(this, delegate);
            }
            case "nthl:workspaceSharedItem": {
                return new JCRWorkspaceSharedFolder(this, delegate);
            }
            case "nthl:externalFile": {
                return new JCRExternalFile(this, delegate);
            }
            case "nthl:externalImage": {
                return new JCRExternalImage(this, delegate);
            }
            case "nthl:externalPdf": {
                return new JCRExternalPDFFile(this, delegate);
            }
            case "nthl:externalUrl": {
                return new JCRExternalUrl(this, delegate);
            }
            case "nthl:gCubeItem": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:trashItem": {
                return new JCRWorkspaceTrashItem(this, delegate);
            }
            case "nthl:query": {
                return new JCRQuery(this, delegate);
            }
            case "nthl:timeSeriesItem": {
                return new JCRTimeSeries(this, delegate);
            }
            case "nthl:report": {
                return new JCRReport(this, delegate);
            }
            case "nthl:reportTemplate": {
                return new JCRReportTemplate(this, delegate);
            }
            case "nthl:gCubeMetadata": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubeDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubeImageDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubePDFDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubeURLDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:workspaceLeafItem": {
                return new JCRWorkspaceFolder(this, delegate);
            }
            case "nthl:workflowReport": {
                return new JCRWorkflowReport(this, delegate);
            }
        }
        throw new InternalErrorException("JCR node type unknow");
    }

    public FolderItemType getFolderItemType(String nodeType) throws RepositoryException {
        if (nodeType.equals("nthl:externalFile")) {
            return FolderItemType.EXTERNAL_FILE;
        }
        if (nodeType.equals("nthl:externalImage")) {
            return FolderItemType.EXTERNAL_IMAGE;
        }
        if (nodeType.equals("nthl:externalPdf")) {
            return FolderItemType.EXTERNAL_PDF_FILE;
        }
        if (nodeType.equals("nthl:externalUrl")) {
            return FolderItemType.EXTERNAL_URL;
        }
        if (nodeType.equals("nthl:gCubeItem")) {
            return FolderItemType.GCUBE_ITEM;
        }
        if (nodeType.equals("nthl:trashItem")) {
            return FolderItemType.TRASH_ITEM;
        }
        if (nodeType.equals("nthl:report")) {
            return FolderItemType.REPORT;
        }
        if (nodeType.equals("nthl:reportTemplate")) {
            return FolderItemType.REPORT_TEMPLATE;
        }
        if (nodeType.equals("nthl:query")) {
            return FolderItemType.QUERY;
        }
        if (nodeType.equals("nthl:timeSeriesItem")) {
            return FolderItemType.TIME_SERIES;
        }
        if (nodeType.equals("nthl:gCubeDocument")) {
            return FolderItemType.DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubeImageDocument")) {
            return FolderItemType.IMAGE_DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubePDFDocument")) {
            return FolderItemType.PDF_DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubeURLDocument")) {
            return FolderItemType.URL_DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubeMetadata")) {
            return FolderItemType.METADATA;
        }
        return null;
    }

    public FolderItemType getFolderItemType(ItemDelegate node) throws RepositoryException {
        String nodeType = node.getPrimaryType();
        return this.getFolderItemType(nodeType);
    }

    protected JCRAbstractWorkspaceFolder getParent(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        if (delegate.getId().equals(this.rootId)) {
            return null;
        }
        ItemDelegate parent = JCRRepository.getServlets().getItemById(delegate.getParentId());
        if (parent != null) {
            if (parent.getPrimaryType().equals("nthl:workspaceItem")) {
                return new JCRWorkspaceFolder(this, parent);
            }
            if (parent.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                return new JCRWorkspaceSharedFolder(this, parent);
            }
        }
        return null;
    }

    public JCRFile getGCUBEDocumentContent(String oid, ContentType contentType) throws RepositoryException {
        String path = this.getGCubeRoot() + Text.escapeIllegalJcrChars((String)oid);
        ItemDelegate node = null;
        try {
            node = JCRRepository.getServlets().getItemByPath(path, this.getOwner().getPortalLogin());
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        switch (contentType) {
            case GENERAL: {
                return new JCRFile(this, node);
            }
            case IMAGE: {
                return new JCRImage(this, node);
            }
            case PDF: {
                return new JCRPDFFile(this, node);
            }
        }
        return null;
    }

    private String getGCubeRoot() {
        return null;
    }

    public List<SearchItem> advancedSearch(String name, SearchItemByOperator date, SearchItemByOperator size) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        List list = null;
        try {
            StringBuilder xpath = new StringBuilder("/jcr:root/Home/" + this.getOwner().getPortalLogin() + "/Workspace" + "//element(*,nthl:workspaceItem)[");
            xpath.append("jcr:contains(@jcr:title, '*" + name + "*')");
            if (date != null) {
                if (date.getMax() != null && date.getMin() != null) {
                    xpath.append(" and @jcr:created >= xs:dateTime('" + date.getMin() + "') and @jcr:created < xs:dateTime('" + date.getMax() + "')");
                } else {
                    xpath.append(" and @jcr:created " + date.getOperator() + " xs:dateTime('" + date.getValue().toString() + "')");
                }
            }
            if (size != null) {
                xpath.append(" and jcr:content/@hl:size");
            }
            xpath.append("]");
            List<SearchItemDelegate> itemDelegateList = JCRRepository.getServlets().executeQuery(xpath.toString(), "xpath", this.getHome().getOwner().getPortalLogin(), 0);
            for (SearchItemDelegate node : itemDelegateList) {
                try {
                    if (node.getPrimaryType().equals("nthl:workspaceItem") || node.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                        JCRSearchFolder searchFolder = new JCRSearchFolder(node);
                        if (list.contains(searchFolder)) continue;
                        list.add(searchFolder);
                        continue;
                    }
                    JCRSearchFolderItem searchFolderItem = new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType()));
                    if (list.contains(searchFolderItem)) continue;
                    list.add(searchFolderItem);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<SearchItem> searchByName(String name) throws InternalErrorException {
        LinkedList<SearchItem> list = null;
        try {
            String userPath = "/Home/" + this.getHome().getOwner().getPortalLogin();
            String path = userPath + "/Workspace";
            String trashPath = path + "/Trash/";
            String sql2 = "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" + " AND (UPPER([jcr:title]) LIKE '%" + name.toUpperCase() + "%')" + " AND NOT(ISDESCENDANTNODE ('" + trashPath + "'))";
            List<SearchItemDelegate> itemDelegateList = JCRRepository.getServlets().executeQuery(sql2, "JCR-SQL2", this.getHome().getOwner().getPortalLogin(), 0);
            list = new LinkedList<SearchItem>();
            ArrayList<String> idList = new ArrayList<String>();
            for (SearchItemDelegate node : itemDelegateList) {
                String id = node.getId();
                if (idList.contains(id)) continue;
                try {
                    if (node.getPrimaryType().equals("nthl:workspaceItem") || node.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                        JCRSearchFolder searchFolder = new JCRSearchFolder(node);
                        list.add((SearchItem)searchFolder);
                    } else {
                        JCRSearchFolderItem searchFolderItem = new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType()));
                        list.add((SearchItem)searchFolderItem);
                    }
                    idList.add(id);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public List<WorkspaceItem> getWorkspaceTree(WorkspaceItem item) throws InternalErrorException {
        LinkedList<WorkspaceItem> listItems = new LinkedList<WorkspaceItem>();
        listItems.addAll(item.getChildren());
        for (WorkspaceItem child : item.getChildren()) {
            listItems.addAll(this.getWorkspaceTree(child));
        }
        return listItems;
    }

    public WorkspaceSmartFolder createSmartFolder(String name, String description, String query) throws ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            ItemDelegate node = new DelegateManager(this.repository.getRootSmartFolders(), this.getOwner().getPortalLogin()).addNode(name, "nthl:workspaceLeafItem");
            JCRWorkspaceSmartFolder folder = new JCRWorkspaceSmartFolder(this, node, name, description, query);
            folder.save();
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = folder;
            return jCRWorkspaceSmartFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<WorkspaceSmartFolder> getAllSmartFolders() throws InternalErrorException {
        LinkedList<WorkspaceSmartFolder> folders = null;
        try {
            ItemDelegate rootSmartFolders = this.repository.getRootSmartFolders();
            DelegateManager manager = new DelegateManager(rootSmartFolders, this.getOwner().getPortalLogin());
            folders = new LinkedList<WorkspaceSmartFolder>();
            List<ItemDelegate> list = manager.getNodes();
            for (ItemDelegate node : list) {
                folders.add(new JCRWorkspaceSmartFolder(this, node));
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return folders;
    }

    public WorkspaceSmartFolder getSmartFolder(String folderId) throws ItemNotFoundException, InternalErrorException {
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            return new JCRWorkspaceSmartFolder(this, servlets.getItemById(folderId));
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<SearchItem> getFolderItems(GenericItemType ... types) throws InternalErrorException {
        LinkedList<SearchItem> list = new LinkedList<SearchItem>();
        for (GenericItemType folderItemType : types) {
            list.addAll(this.getFolderItems(folderItemType));
        }
        return list;
    }

    public List<SearchItem> getFolderItems(GenericItemType type) throws InternalErrorException {
        LinkedList<SearchItem> list = null;
        try {
            String query = null;
            if (type instanceof FolderItemType) {
                query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@hl:workspaceItemType = '" + type.toString() + "']";
            } else if (type instanceof WorkspaceItemType) {
                switch ((WorkspaceItemType)type) {
                    case FOLDER: {
                        query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:primaryType= '" + "nthl:workspaceItem" + "']";
                        break;
                    }
                    case SHARED_FOLDER: {
                        query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:primaryType= '" + "nthl:workspaceSharedItem" + "']";
                        break;
                    }
                    case TRASH_ITEM: {
                        query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:primaryType= '" + "nthl:trashItem" + "']";
                        break;
                    }
                }
            }
            this.logger.info(query);
            List<SearchItemDelegate> itemDelegateList = JCRRepository.getServlets().executeQuery(query, "xpath", this.getHome().getOwner().getPortalLogin(), 0);
            list = new LinkedList<SearchItem>();
            for (SearchItemDelegate node : itemDelegateList) {
                try {
                    if (node.getPrimaryType().equals("nthl:workspaceItem") || node.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                        list.add((SearchItem)new JCRSearchFolder(node));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType())));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public List<SearchFolderItem> searchByMimeType(String mimeType) throws InternalErrorException {
        LinkedList<SearchFolderItem> list = null;
        try {
            String query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:mimeType = '" + mimeType + "']";
            List<SearchItemDelegate> itemDelegateList = JCRRepository.getServlets().executeQuery(query, "xpath", this.getHome().getOwner().getPortalLogin(), 0);
            list = new LinkedList<SearchFolderItem>();
            for (SearchItemDelegate node : itemDelegateList) {
                try {
                    list.add(new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType())));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public String getUrlWebDav() throws InternalErrorException {
        return this.repository.getWebDavUrl(this.home.getOwner().getPortalLogin()) + this.getPathSeparator() + WORKSPACE_ROOT_FOLDER;
    }

    private void updateHomes(List<String> users) throws InternalErrorException {
        try {
            List<String> homes = JCRRepository.getHomeNames();
            for (String user : users) {
                if (homes.contains(user)) continue;
                this.home.getHomeManager().createUser(user);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, List<String> users, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace shared folder");
        this.updateHomes(users);
        try {
            if (this.exists(name, destinationFolderId)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(destinationFolderId);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            ItemDelegate sharedRootFolder = JCRRepository.getSharedRoot();
            DelegateManager wrap = new DelegateManager(sharedRootFolder, this.getOwner().getPortalLogin());
            ItemDelegate sharedNode = wrap.addNode(UUID.randomUUID().toString(), "nthl:workspaceSharedItem");
            this.logger.info("SHARED NODE: " + sharedNode.toString());
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, sharedNode, name, description, destinationFolderId, users, null, null);
            folder.save();
            folder.share();
            this.fireItemCreatedEvent(folder);
            return folder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder shareFolder(List<String> users, String itemId) throws InternalErrorException, InsufficientPrivilegesException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        JCRServlets servlets = JCRRepository.getServlets();
        ItemDelegate nodeItemToShare = null;
        JCRWorkspaceSharedFolder sharedFoldere = null;
        try {
            nodeItemToShare = servlets.getItemById(itemId);
            if (!nodeItemToShare.isLocked()) {
                JCRWorkspaceItem itemToShare = this.getWorkspaceItem(nodeItemToShare);
                if (itemToShare.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    JCRWorkspaceSharedFolder sharedFolder = (JCRWorkspaceSharedFolder)itemToShare;
                    sharedFolder.share(users);
                    return sharedFolder;
                }
                if (itemToShare.getType() != WorkspaceItemType.FOLDER && !(itemToShare instanceof GCubeItem)) {
                    throw new WorkspaceFolderNotFoundException("The item to share is not a folder or a GCubeItem");
                }
                JCRAbstractWorkspaceFolder parentItem = itemToShare.getParent();
                if (parentItem == null) {
                    throw new WrongDestinationException("The root can't be shared");
                }
                String parentId = parentItem.getId();
                if (parentItem.isShared()) {
                    throw new WrongDestinationException("Destination folder is already shared");
                }
                this.logger.info("Check if Folder contains descendants already shared");
                List<SearchItemDelegate> result = null;
                try {
                    result = servlets.executeQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)itemToShare.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath", this.getHome().getOwner().getPortalLogin(), 0);
                }
                catch (HttpException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (!result.isEmpty()) {
                    throw new WrongDestinationException("Folder contains descendants already shared");
                }
                String sharedFolderName = itemToShare.getName();
                String sharedFolderDescription = itemToShare.getDescription();
                ItemDelegate sharedRootFolder = JCRRepository.getSharedRoot();
                DelegateManager wrap = new DelegateManager(sharedRootFolder, this.getOwner().getPortalLogin());
                ItemDelegate sharedNode = wrap.addNode(itemId, "nthl:workspaceSharedItem");
                this.logger.info("SHARED NODE: " + sharedNode.toString());
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    sharedFoldere = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users, null, null);
                    sharedFoldere.save();
                    DelegateManager wrap1 = new DelegateManager(nodeItemToShare, this.getOwner().getPortalLogin());
                    List<ItemDelegate> list = wrap1.getNodes();
                    for (ItemDelegate node : list) {
                        try {
                            this.logger.info("MOVE FROM: " + node.getPath() + " - TO: " + sharedNode.getPath() + this.getPathSeparator() + node.getName());
                            servlets.move(node.getPath(), sharedNode.getPath() + this.getPathSeparator() + node.getName());
                        }
                        catch (HttpException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.logger.trace("Sharing a GCubeItem");
                    ItemDelegate parent = servlets.getItemById(nodeItemToShare.getParentId());
                    String applicationName = parent.getName();
                    sharedFoldere = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users, applicationName, nodeItemToShare.getName());
                    sharedFoldere.save();
                    try {
                        servlets.move(nodeItemToShare.getPath(), JCRRepository.getSharedRoot().getPath() + this.getPathSeparator() + itemId + this.getPathSeparator() + nodeItemToShare.getName());
                    }
                    catch (HttpException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    JCRGCubeItem gcubeItem = (JCRGCubeItem)itemToShare;
                    gcubeItem.setSharedRootId(sharedFoldere.getId());
                    gcubeItem.save();
                }
                DelegateManager wrap2 = new DelegateManager(nodeItemToShare, this.getOwner().getPortalLogin());
                wrap2.remove();
                sharedFoldere.share();
                sharedFoldere.setShareHistory(users, this.getOwner().getPortalLogin());
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    try {
                        this.moveSharedItem(sharedNode);
                    }
                    catch (ItemAlreadyExistException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                this.fireItemCreatedEvent(sharedFoldere);
            }
            return sharedFoldere;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<Object> getBookmarks(String bookmarkFolderId) throws InternalErrorException {
        return null;
    }

    public void addBookmark(String itemId, String destinationFolderId) throws ItemAlreadyExistException, InternalErrorException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
    }

    public void setHardLink(ItemDelegate node, String hardLinkRemotePath) throws RepositoryException, InternalErrorException {
        this.logger.info("set hard link: " + hardLinkRemotePath + " to node " + node.getPath());
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            this.setHardLink(JCRRepository.getServlets().getItemById(child.getId()), hardLinkRemotePath);
        }
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            ((JCRWorkspaceFolderItem)item).setHardLink(node, hardLinkRemotePath);
        }
    }

    public void updateItem(String itemId, InputStream fileData) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        File tmpFile = null;
        try {
            ItemDelegate itemDelegate = JCRRepository.getServlets().getItemById(itemId);
            this.logger.trace("Update file " + itemDelegate.getPath());
            JCRWorkspaceItem newItem = this.getWorkspaceItem(itemDelegate);
            if (newItem.isShared()) {
                this.logger.debug("the item is shared: " + itemDelegate.getPath());
                if (!JCRPrivilegesInfo.canModifyProperties(newItem.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), itemDelegate.getPath(), false)) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to update the node");
                }
            }
            Calendar lastupdate = Calendar.getInstance();
            JCRAccountingEntryUpdate entryUpdate = new JCRAccountingEntryUpdate(newItem.getId(), this.getOwner().getPortalLogin(), lastupdate, itemDelegate.getTitle());
            entryUpdate.save();
            JCRAccountingEntryUpdate entryUpdateFolder = new JCRAccountingEntryUpdate(itemDelegate.getParentId(), this.getOwner().getPortalLogin(), lastupdate, itemDelegate.getTitle());
            entryUpdateFolder.save();
            tmpFile = WorkspaceUtil.getTmpFile((InputStream)fileData);
            try {
                fileData.close();
            }
            catch (IOException e1) {
                this.logger.error("Error closing InputStream " + e1);
            }
            FileInputStream data = null;
            try {
                data = new FileInputStream(tmpFile);
                String mimeType = null;
                try {
                    mimeType = MimeTypeUtil.getMimeType((String)itemDelegate.getTitle(), (File)tmpFile);
                }
                catch (Exception e) {
                    this.logger.error("Error getting mimeType of file: " + tmpFile.getAbsolutePath());
                }
                this.overwriteContent(itemDelegate, data, mimeType);
                data.close();
                this.updateProperties(itemDelegate, lastupdate, tmpFile);
            }
            catch (IOException e1) {
                throw new InternalErrorException((Throwable)e1);
            }
            this.fireItemUpdatedEvent(this.getItem(itemId));
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private void updateProperties(ItemDelegate delegate, Calendar lastupdate, File tmpFile) throws RepositoryException, InternalErrorException {
        this.logger.trace("update Properies for node: " + delegate.getPath() + " - Last Modified by : " + this.getOwner().getPortalLogin() + " - Last Action : " + WorkspaceItemAction.UPDATED.toString());
        delegate.setLastModificationTime(lastupdate);
        delegate.setLastModifiedBy(this.getOwner().getPortalLogin());
        delegate.setLastAction(WorkspaceItemAction.UPDATED);
        DelegateManager manager = new DelegateManager(delegate, this.getOwner().getPortalLogin());
        try {
            manager.save();
        }
        catch (Exception e) {
            this.logger.error("Error savig updated item " + delegate.getPath());
        }
        if (delegate.getPrimaryType().equals("nthl:externalFile")) {
            JCRExternalFile item = new JCRExternalFile(this, delegate);
            item.updateInfo(tmpFile);
        } else if (delegate.getPrimaryType().equals("nthl:externalImage")) {
            JCRExternalImage item = new JCRExternalImage(this, delegate);
            item.updateInfo(tmpFile);
        } else if (delegate.getPrimaryType().equals("nthl:externalPdf")) {
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, delegate);
            item.updateInfo(tmpFile);
        }
    }

    public void overwriteContent(ItemDelegate itemDelegate, String oldRemotePath, String mimeType) throws RepositoryException, RemoteBackendException {
        try {
            Map contentNode = itemDelegate.getContent();
            if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                String remotePath = (String)contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
                this.getStorage().putStream(oldRemotePath, remotePath, this.home.getOwner().getPortalLogin(), mimeType);
            }
        }
        catch (Exception e) {
            this.logger.error("Content node not found", (Throwable)e);
        }
    }

    public void overwriteContent(ItemDelegate itemDelegate, InputStream is, String mimeType) throws RepositoryException, RemoteBackendException {
        try {
            Map contentNode = itemDelegate.getContent();
            if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                String remotePath = (String)contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
                this.getStorage().putStream(is, remotePath, this.home.getOwner().getPortalLogin(), mimeType);
            }
        }
        catch (Exception e) {
            this.logger.error("Content node not found", (Throwable)e);
        }
    }

    public JCRWorkspaceItem createGcubeItem(String name, String description, List<String> scopes, String creator, String itemType, Map<String, String> properties, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        this.logger.trace("Create gCube item " + name);
        try {
            ItemDelegate node = this.addChildNode(destinationFolderId, name, "nthl:gCubeItem");
            JCRGCubeItem item = new JCRGCubeItem(this, node, name, description, scopes, creator, itemType, properties);
            ((JCRWorkspaceItem)item).save();
            this.fireItemCreatedEvent(item);
            return item;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder getMySpecialFolders() throws InternalErrorException, ItemNotFoundException {
        this.logger.info("getMySpecialFolders: " + this.mySpecialFoldersPath);
        JCRServlets servlets = null;
        if (this.mySpecialFolders == null) {
            servlets = JCRRepository.getServlets();
            try {
                try {
                    this.mySpecialFolders = new JCRWorkspaceFolder(this, servlets.getItemByPath(this.mySpecialFoldersPath, this.getOwner().getPortalLogin()));
                }
                catch (PathNotFoundException e) {
                    ItemDelegate root = servlets.getItemByPath(this.userWorkspace, this.getOwner().getPortalLogin());
                    DelegateManager wrap = new DelegateManager(root, this.getOwner().getPortalLogin());
                    ItemDelegate mySpecial = wrap.addNode(SPECIAL_FOLDER, "nthl:workspaceItem");
                    this.mySpecialFolders = new JCRWorkspaceFolder(this, mySpecial, SPECIAL_FOLDER, "My Special Folders");
                    this.mySpecialFolders.save();
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return this.mySpecialFolders;
    }

    public WorkspaceFolder getApplicationArea() throws InternalErrorException {
        this.logger.info("getApplicationArea: " + this.applicationFolderPath);
        JCRServlets servlets = null;
        if (this.applicationFolder == null) {
            servlets = JCRRepository.getServlets();
            try {
                try {
                    this.applicationFolder = new JCRWorkspaceFolder(this, servlets.getItemByPath(this.applicationFolderPath, this.getOwner().getPortalLogin()));
                }
                catch (PathNotFoundException e) {
                    ItemDelegate root = servlets.getItemByPath(this.userWorkspace, this.getOwner().getPortalLogin());
                    DelegateManager wrap = new DelegateManager(root, this.getOwner().getPortalLogin());
                    ItemDelegate application = wrap.addNode(APPLICATION_FOLDER, "nthl:workspaceItem");
                    this.applicationFolder = new JCRWorkspaceFolder(this, application, APPLICATION_FOLDER, "Applications folder");
                    this.applicationFolder.save();
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return this.applicationFolder;
    }

    public JCRWorkspaceFolder getTrashFolder() throws InternalErrorException, RepositoryException {
        this.logger.info("getTrashFolder: " + this.trashPath);
        JCRServlets servlets = null;
        if (this.trashFolder == null) {
            servlets = JCRRepository.getServlets();
            try {
                try {
                    this.trashFolder = new JCRWorkspaceFolder(this, servlets.getItemByPath(this.trashPath, this.getOwner().getPortalLogin()));
                }
                catch (ItemNotFoundException e) {
                    ItemDelegate root = null;
                    try {
                        root = servlets.getItemByPath(this.userWorkspace, this.getOwner().getPortalLogin());
                    }
                    catch (ItemNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    DelegateManager wrap = new DelegateManager(root, this.getOwner().getPortalLogin());
                    ItemDelegate trash = wrap.addNode(TRASH, "nthl:workspaceItem");
                    this.trashFolder = new JCRWorkspaceFolder(this, trash, TRASH, "Trash folder");
                    this.trashFolder.save();
                }
            }
            catch (PathNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return this.applicationFolder;
    }

    public WorkspaceItem unshare(String itemId) throws InternalErrorException, ItemNotFoundException {
        WorkspaceItem itemUnshared = null;
        JCRServlets servlets = JCRRepository.getServlets();
        ItemDelegate sharedNode = null;
        try {
            sharedNode = servlets.getItemById(itemId);
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(sharedNode.getId());
            if (item.isShared()) {
                JCRWorkspaceSharedFolder sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode);
                WorkspaceFolder destFolder = sharedItem.unShare();
                this.logger.trace("Unshared Folder: " + destFolder.getPath());
            } else {
                this.logger.trace(item.getPath() + " the item is not shared");
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return itemUnshared;
    }

    public WorkspaceItem getItemByPath(String path) throws ItemNotFoundException {
        Validate.notNull((Object)path, (String)"path must be not null");
        try {
            String longPath = path.substring(path.indexOf(47) + 1);
            String shortPath = longPath.substring(longPath.indexOf(47) + 1);
            String absPath = shortPath.startsWith(PREFIX + JCRRepository.serviceName) ? shortPath.replaceAll(PREFIX + JCRRepository.serviceName, "") : (path.startsWith(PREFIX_SHARE) || path.startsWith("/Home/" + this.getOwner().getPortalLogin() + "/Workspace/") ? path : this.userHome + path);
            this.logger.trace("getItemByPath: " + absPath);
            return this.getItemByAbsPath(absPath);
        }
        catch (InternalErrorException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public WorkspaceItem getItemByAbsPath(String path) throws ItemNotFoundException, InternalErrorException, RepositoryException {
        ItemDelegate nodeItem = null;
        try {
            nodeItem = JCRRepository.getServlets().getItemByPath(path, this.getOwner().getPortalLogin());
            nodeItem.getId();
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.toString());
        }
        return this.getWorkspaceItem(nodeItem);
    }

    public WorkspaceTrashFolder getTrash() throws InternalErrorException, ItemNotFoundException {
        try {
            return new JCRWorkspaceTrashFolder(this, JCRRepository.getServlets().getItemByPath(this.trashPath, this.getOwner().getPortalLogin()));
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, String groupId, String destinationFolderId, String displayName, boolean isVREFolder) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace shared folder");
        String newName = this.getVREByScope(name);
        String newGroupId = this.getVREByScope(groupId);
        List<String> users = this.resolveGroupId(newGroupId);
        this.updateHomes(users);
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            String destinationFolderID = servlets.getItemByPath(this.mySpecialFoldersPath, this.getOwner().getPortalLogin()).getId();
            if (this.exists(newName, destinationFolderID)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(destinationFolderID);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            ItemDelegate sharedFolder = JCRRepository.getSharedRoot();
            DelegateManager wrap = new DelegateManager(sharedFolder, this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.addNode(UUID.randomUUID().toString(), "nthl:workspaceSharedItem");
            ArrayList<String> users1 = new ArrayList<String>();
            users1.add(newGroupId);
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, newName, description, destinationFolderID, users1, null, null, displayName, isVREFolder);
            folder.save();
            folder.share();
            this.fireItemCreatedEvent(folder);
            if (isVREFolder) {
                this.createVREManager(newName, folder);
            }
            ArrayList<String> admins = new ArrayList<String>();
            admins.add(this.getOwner().getPortalLogin());
            folder.setACL(admins, ACLType.ADMINISTRATOR);
            return folder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void createVREManager(String newName, JCRWorkspaceSharedFolder folder) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        String manager = newName + "-Manager";
        ArrayList<String> usersList = new ArrayList<String>();
        usersList.add(manager);
        folder.share(usersList);
    }

    public List<String> resolveGroupId(String groupId) throws InternalErrorException {
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        GCubeGroup myGroup = gm.getGroup(groupId);
        List members = myGroup.getMembers();
        return members;
    }

    public List<WorkspaceItem> searchByProperties(List<String> properties) throws InternalErrorException {
        LinkedList<WorkspaceItem> list = null;
        try {
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:workspaceItem)[");
            int i = 0;
            for (String property : properties) {
                if (i != 0) {
                    query.append(" and ");
                }
                query.append("hl:metadata/@" + property + "");
                ++i;
            }
            query.append("]");
            this.logger.trace(query.toString());
            List<ItemDelegate> itemDelegateList = JCRRepository.getServlets().searchItems(query.toString(), "xpath", this.getHome().getOwner().getPortalLogin());
            list = new LinkedList<WorkspaceItem>();
            for (ItemDelegate node : itemDelegateList) {
                try {
                    JCRWorkspaceItem item = this.getWorkspaceItem(node);
                    list.add(item);
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public boolean isInTrash(ItemDelegate originalParent) throws InternalErrorException, RepositoryException {
        return originalParent.getPath().contains("/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace/Trash/");
    }

    public List<SearchFolderItem> searchFullText(String text) throws InternalErrorException {
        LinkedList<SearchFolderItem> list = null;
        ArrayList<String> ids = null;
        try {
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:workspaceItem)[jcr:contains(., '" + text + "')]");
            this.logger.trace(query.toString());
            List<SearchItemDelegate> itemDelegateList = JCRRepository.getServlets().executeQuery(query.toString(), "xpath", this.getHome().getOwner().getPortalLogin(), 0);
            list = new LinkedList<SearchFolderItem>();
            ids = new ArrayList<String>();
            for (SearchItemDelegate node : itemDelegateList) {
                String id = node.getId();
                try {
                    if (ids.contains(id)) continue;
                    list.add(new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType())));
                    ids.add(id);
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
            this.logger.info("Results: " + list.size());
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public void init(String portalLogin) throws PathNotFoundException, RepositoryException, InternalErrorException, ItemNotFoundException {
        JCRUserManager um = new JCRUserManager();
        String userVersion = JCRRepository.getUserVersion(portalLogin, null);
        this.logger.info(portalLogin + " --> USER VERSION: " + userVersion + " - HL VERSION: " + JCRRepository.HLversion);
        if (!JCRRepository.HLversion.equals(userVersion)) {
            JCRServlets servlets = null;
            try {
                ItemDelegate trashNode;
                servlets = JCRRepository.getServlets();
                ItemDelegate userHome = servlets.getItemByPath("/Home/" + portalLogin, this.getOwner().getPortalLogin());
                DelegateManager userHomeManager = new DelegateManager(userHome, this.getOwner().getPortalLogin());
                ItemDelegate wsNode = null;
                try {
                    wsNode = userHomeManager.addNode(WORKSPACE_ROOT_FOLDER, "nthl:workspaceItem");
                    JCRWorkspaceFolder root = new JCRWorkspaceFolder(this, wsNode, WORKSPACE_ROOT_FOLDER, "The root");
                    wsNode = root.save();
                    this.logger.info(wsNode.getPath() + " created");
                }
                catch (ItemExistsException e) {
                    wsNode = userHomeManager.getNode(WORKSPACE_ROOT_FOLDER);
                    this.logger.info("Getting workspace node: " + wsNode.getPath());
                }
                DelegateManager wrapWsNode = new DelegateManager(wsNode, this.getOwner().getPortalLogin());
                try {
                    ItemDelegate node = wrapWsNode.addNode(APPLICATION_FOLDER, "nthl:workspaceItem");
                    this.applicationFolder = new JCRWorkspaceFolder(this, node, APPLICATION_FOLDER, "Applications folder");
                    this.applicationFolder.save();
                }
                catch (ItemExistsException e) {
                    this.applicationFolder = new JCRWorkspaceFolder(this, wrapWsNode.getNode(APPLICATION_FOLDER));
                }
                try {
                    trashNode = wrapWsNode.addNode(TRASH, "nthl:workspaceItem");
                    this.trashFolder = new JCRWorkspaceFolder(this, trashNode, TRASH, "Trash folder");
                    this.trashFolder.save();
                }
                catch (ItemExistsException e) {
                    this.trashFolder = new JCRWorkspaceFolder(this, wrapWsNode.getNode(TRASH));
                    trashNode = wrapWsNode.getNode(TRASH);
                }
                try {
                    ItemDelegate vreNode = wrapWsNode.addNode(SPECIAL_FOLDER, "nthl:workspaceItem");
                    this.mySpecialFolders = new JCRWorkspaceFolder(this, vreNode, SPECIAL_FOLDER, "My Special Folders");
                    this.mySpecialFolders.save();
                }
                catch (ItemExistsException e) {
                    this.mySpecialFolders = new JCRWorkspaceFolder(this, wrapWsNode.getNode(SPECIAL_FOLDER));
                    ItemDelegate vreNode = wrapWsNode.getNode(SPECIAL_FOLDER);
                }
                um.setVersionByUser(portalLogin, JCRRepository.HLversion);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        this.logger.info("skip init in JCRWorkspace for user: " + portalLogin);
    }

    private String getVREByScope(String scope) {
        String newName = scope.startsWith("/") ? scope.replace("/", "-").substring(1) : scope.replace("/", "-");
        return newName;
    }

    public WorkspaceSharedFolder getVREFolderByScope(String scope) throws ItemNotFoundException, InternalErrorException {
        String VRE = this.getVREByScope(scope);
        WorkspaceSharedFolder folder = (WorkspaceSharedFolder)this.getItemByPath(this.mySpecialFoldersPath + "/" + VRE);
        return folder;
    }

    public long getDiskUsage() throws InternalErrorException {
        this.logger.trace("get getDiskUsage of user " + this.portalLogin);
        long diskUsage = 0L;
        try {
            diskUsage = this.getStorage().getDiskUsageByUser(this.portalLogin);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving disk usage ", (Throwable)e);
        }
        return diskUsage;
    }

    public int getTotalItems() throws InternalErrorException {
        this.logger.trace("get getTotalItems of user " + this.portalLogin);
        int totItems = 0;
        try {
            totItems = this.getStorage().getTotalItemsByUser(this.portalLogin);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving total items ", (Throwable)e);
        }
        return totItems;
    }

    public WorkspaceSharedFolder share(List<String> users, String itemId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        return this.shareFolder(users, itemId);
    }

    public List<GCubeItem> searchGCubeItems(SearchQuery queryString) throws InternalErrorException {
        LinkedList<GCubeItem> list = null;
        try {
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:gCubeItem)[");
            if (!queryString.getHasProperties().isEmpty()) {
                int i = 0;
                Set keys = queryString.getHasProperties();
                for (String key : keys) {
                    if (i != 0) {
                        query.append(" and ");
                    }
                    query.append("hl:property/@" + key);
                    ++i;
                }
            }
            if (!queryString.getPropertiesValues().isEmpty()) {
                if (!queryString.getHasProperties().isEmpty()) {
                    query.append(" and ");
                }
                Map properties = queryString.getPropertiesValues();
                int i = 0;
                Set keys = properties.keySet();
                for (String key : keys) {
                    if (i != 0) {
                        query.append(" and ");
                    }
                    query.append("hl:property/@" + key + " = '" + (String)properties.get(key) + "'");
                    ++i;
                }
            }
            if (!queryString.getTypes().isEmpty()) {
                if (!queryString.getHasProperties().isEmpty() || !queryString.getPropertiesValues().isEmpty()) {
                    query.append(" and ");
                }
                Set types = queryString.getTypes();
                int i = 0;
                for (String type : types) {
                    if (i != 0) {
                        query.append(" and ");
                    }
                    query.append("@hl:itemType = '" + type + "'");
                    ++i;
                }
            }
            query.append("]");
            this.logger.trace(query.toString());
            List<ItemDelegate> itemDelegateList = JCRRepository.getServlets().searchItems(query.toString(), "xpath", this.getHome().getOwner().getPortalLogin());
            list = new LinkedList<GCubeItem>();
            for (ItemDelegate node : itemDelegateList) {
                try {
                    GCubeItem item = (GCubeItem)this.getWorkspaceItem(node);
                    list.add(item);
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public ReportTemplate createReportTemplate(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Created report template");
        try {
            ItemDelegate node = this.createItemDelegate(destinationfolderId, name, "nthl:reportTemplate");
            JCRReportTemplate reportTemplate = new JCRReportTemplate(this, node, name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData);
            reportTemplate.save();
            try {
                this.logger.info(reportTemplate.getPath() + " has been added to parent folder " + node.getPath());
                JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), reportTemplate.getType(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getFolderItemType() : null, reportTemplate.getName(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getMimeType() : null);
                entry.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + reportTemplate.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(reportTemplate);
            return reportTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Report createReport(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create report");
        try {
            ItemDelegate node = this.createItemDelegate(destinationfolderId, name, "nthl:report");
            JCRReport item = new JCRReport(this, node, name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData);
            item.save();
            try {
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null);
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            return item;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Query createQuery(String name, String description, String query, QueryType queryType, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create query");
        try {
            ItemDelegate node = this.createItemDelegate(destinationfolderId, name, "nthl:query");
            JCRQuery item = new JCRQuery(this, node, name, description, query, queryType);
            item.save();
            this.fireItemCreatedEvent(item);
            return item;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Query createQuery(String name, String description, InputStream query, QueryType queryType, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        try {
            return this.createQuery(name, description, Util.readStreamAsString((InputStream)query), queryType, destinationfolderId);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create TimeSeries item");
        try {
            ItemDelegate node = this.createItemDelegate(destinationFolderId, name, "nthl:timeSeriesItem");
            JCRTimeSeries item = new JCRTimeSeries(this, node, name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV);
            item.save();
            this.fireItemCreatedEvent(item);
            return item;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkflowReport createWorkflowReport(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create WorkflowReport item");
        try {
            ItemDelegate node = this.createItemDelegate(destinationFolderId, name, "nthl:workflowReport");
            JCRWorkflowReport item = new JCRWorkflowReport(this, node, name, description, workflowId, workflowStatus, workflowData);
            item.save();
            this.fireItemCreatedEvent(item);
            return item;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem createReference(String itemId, String destinationFolderId) throws InternalErrorException {
        ItemDelegate node = null;
        JCRWorkspaceItem item = null;
        try {
            node = JCRRepository.getServlets().createReference(itemId, destinationFolderId, this.getOwner().getPortalLogin());
            item = this.getWorkspaceItem(node);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }
}

