/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRWorkflowReport
extends JCRWorkspaceFolderItem
implements WorkflowReport {
    public JCRWorkflowReport(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException, InternalErrorException {
        super(workspace, itemDelegate);
    }

    public JCRWorkflowReport(JCRWorkspace workspace, ItemDelegate itemDelegate, String name, String description, String workflowId, String workflowStatus, String workflowData) throws RepositoryException {
        super(workspace, itemDelegate, name, description);
        Validate.notNull((Object)workflowId, (String)"workflowId must be not null");
        Validate.notNull((Object)workflowStatus, (String)"workflowStatus must be not null");
        Validate.notNull((Object)workflowData, (String)"workflowData type must be not null");
        Map content = itemDelegate.getContent();
        content.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.WORKFLOW_REPORT.toString());
        content.put(NodeProperty.WORKFLOW_DATA, new XStream().toXML((Object)workflowData));
        content.put(NodeProperty.WORKFLOW_ID, workflowId);
        content.put(NodeProperty.WORKFLOW_STATUS, workflowStatus);
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.WORKFLOW_REPORT;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

