/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.servlet;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRServlets {
    private String urlRepository;
    private Logger logger = LoggerFactory.getLogger(JCRServlets.class);
    private String login;

    public JCRServlets(String login) {
        this.urlRepository = JCRRepository.url;
        this.login = login;
    }

    public JCRServlets() {
        this.urlRepository = JCRRepository.url;
        this.login = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemDelegate> getChildrenById(String id, String login) {
        this.logger.info("Calling servlet getChildrenById " + id + " by " + login);
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(JCRRepository.url + "/GetChildrenById?" + JCRRepository.getCredetials() + "&id=" + id + "&login=" + login);
            httpClient.executeMethod((HttpMethod)getMethod);
            items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public ItemDelegate getItemByPath(String path, String login) throws ItemNotFoundException {
        this.logger.info("Calling Servlet GetItemByPath " + path + " by " + login);
        ItemDelegate item = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.urlRepository + "/GetItemByPath?" + JCRRepository.getCredetials() + "&path=" + URLEncoder.encode(path, "UTF-8") + "&login=" + login);
            httpClient.executeMethod((HttpMethod)getMethod);
            item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate getItemById(String id) {
        ItemDelegate item = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.urlRepository + "/GetItemById?" + JCRRepository.getCredetials() + "&id=" + id);
            httpClient.executeMethod((HttpMethod)getMethod);
            item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate getParentById(String id) {
        ItemDelegate item = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.urlRepository + "/GetParentById?" + JCRRepository.getCredetials() + "&id=" + id);
            httpClient.executeMethod((HttpMethod)getMethod);
            item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate saveItem(ItemDelegate item) throws Exception {
        Validate.notNull((Object)item, (String)"item must be not null");
        this.logger.info("Calling Servlet SaveItem " + item.getName() + " by " + this.login);
        ItemDelegate modifiedItem = null;
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.urlRepository + "/SaveItem?" + JCRRepository.getCredetials());
            post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML((Object)item), "application/json", null));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return modifiedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate clone(String srcAbsPath, String destAbsPath, boolean removeExisting) throws HttpException, IOException {
        this.logger.info("Calling Servlet Clone from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.urlRepository + "/Clone?" + JCRRepository.getCredetials() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&removeExisting=" + removeExisting);
            httpClient.executeMethod((HttpMethod)getMethod);
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate move(String srcAbsPath, String destAbsPath) throws HttpException, IOException {
        this.logger.info("Calling Servlet Move from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.urlRepository + "/Move?" + JCRRepository.getCredetials() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8"));
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(String absPath) throws IOException {
        this.logger.info("Calling Servlet RemoveItem " + absPath + " by " + this.login);
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        try {
            post = new PostMethod(this.urlRepository + "/RemoveItem?" + JCRRepository.getCredetials() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8"));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate copy(String srcAbsPath, String destAbsPath) throws HttpException, IOException {
        ItemDelegate item = null;
        GetMethod post = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new GetMethod(this.urlRepository + "/Copy?" + JCRRepository.getCredetials() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8"));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate copyContent(String srcId, String destId) throws HttpException, IOException {
        ItemDelegate item = null;
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.urlRepository + "/CopyContent?" + JCRRepository.getCredetials() + "&srcId=" + srcId + "&destId=" + destId);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchItemDelegate> executeQuery(String query, String lang, String login, int limit) throws HttpException, IOException {
        GetMethod get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(this.urlRepository + "/ExecuteQuery?" + JCRRepository.getCredetials() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang + "&login=" + login + "&limit=" + limit);
            int response = httpClient.executeMethod((HttpMethod)get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemDelegate> searchItems(String query, String lang, String login) throws HttpException, IOException {
        GetMethod get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(this.urlRepository + "/SearchItems?" + JCRRepository.getCredetials() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang + "&login=" + login);
            int response = httpClient.executeMethod((HttpMethod)get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAccountingItem(AccountingDelegate item) {
        Validate.notNull((Object)item, (String)"item must be not null");
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.urlRepository + "/SaveAccountingItem?" + JCRRepository.getCredetials());
            post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML((Object)item), "application/json", null));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountingDelegate> getAccountingById(String id) {
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(JCRRepository.url + "/GetAccountingById?" + JCRRepository.getCredetials() + "&id=" + id);
            httpClient.executeMethod((HttpMethod)getMethod);
            items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate createReference(String itemId, String destinationFolderId, String login) throws HttpException, IOException {
        this.logger.info("Calling Servlet createReference of Node Id " + itemId + " to destination folder ID" + destinationFolderId + " by " + login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            System.out.println(this.urlRepository + "/CreateReference?" + JCRRepository.getCredetials() + "&srcId=" + itemId + "&destId=" + destinationFolderId + "&login=" + login);
            getMethod = new GetMethod(this.urlRepository + "/CreateReference?" + JCRRepository.getCredetials() + "&srcId=" + itemId + "&destId=" + destinationFolderId + "&login=" + login);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }
}

