/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository;

import java.security.Key;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRRepository {
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_WEBDAV = "/repository/default/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    private static final String GCUBE_FOLDER = "GCube";
    private static final String DOWNLOADS = "Downloads";
    private static final String SMART_FOLDER = "Folders";
    private static final String IN_BOX_FOLDER = "InBox";
    private static final String OUT_BOX_FOLDER = "OutBox";
    private static final String HIDDEN_FOLDER = "HiddenFolder";
    private static final String NT_FOLDER = "nt:folder";
    private static final String NT_HOME = "nthl:home";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    private static final String NT_ROOT_ITEM_SENT = "nthl:rootItemSentRequest";
    private static final String NT_ROOT_FOLDER_BULK_CREATOR = "nthl:rootFolderBulkCreator";
    private static final String SCOPES = "hl:scopes";
    private static final String nameResource = "HomeLibraryRepository";
    private static Repository repository;
    private static JCRServlets servletManager;
    private String portalLogin;
    public static String user;
    public static String pass;
    public static String url;
    private static String webdavUrl;
    public static String serviceName;
    public static String HLversion;
    private static String version;
    private static String minorVersion;
    private static String revisionVersion;
    private static Logger logger;

    private static synchronized void initializeRepository() throws InternalErrorException {
        if (repository != null) {
            return;
        }
        String callerScope = ScopeProvider.instance.get();
        try {
            if (callerScope == null) {
                throw new IllegalArgumentException("scope is null");
            }
            String rootScope = Utils.getRootScope(callerScope);
            logger.debug("scope for repository creation is " + rootScope + " caller scope is " + callerScope);
            ScopeProvider.instance.set(rootScope);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq 'HomeLibraryRepository' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List resources = client.submit((Query)query);
            if (resources.size() != 0) {
                try {
                    ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
                    for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
                        if (ap.name().equals("JCR")) {
                            url = ap.address();
                            user = ap.username();
                            pass = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                            for (ServiceEndpoint.Property p : ap.properties()) {
                                if (p.name().equals("version")) {
                                    version = p.value();
                                    continue;
                                }
                                if (p.name().equals("minorVersion")) {
                                    minorVersion = p.value();
                                    continue;
                                }
                                if (!p.name().equals("revisionVersion")) continue;
                                revisionVersion = p.value();
                            }
                            HLversion = version + "." + minorVersion + "." + revisionVersion;
                            continue;
                        }
                        if (ap.name().equals("WebDav")) {
                            webdavUrl = ap.address();
                            continue;
                        }
                        if (!ap.name().equals("ServiceName")) continue;
                        serviceName = ap.address();
                    }
                }
                catch (Throwable e) {
                    logger.error("error decrypting resource", e);
                }
            }
            if (user == null || pass == null) {
                throw new InternalErrorException("cannot discover password and username in scope " + callerScope);
            }
            repository = new URLRemoteRepository(url + "/rmi");
            logger.debug("user is " + user + " password is null?" + (pass == null) + " and repository is null?" + (repository == null));
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (callerScope != null) {
                ScopeProvider.instance.set(callerScope);
            }
        }
    }

    public static String getCredetials() {
        String credentials = "adminId=" + user + "&adminPassword=" + pass;
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHomeNames() throws RepositoryException {
        ArrayList<String> homes = new ArrayList<String>();
        Session session = null;
        try {
            try {
                session = JCRRepository.getSession();
            }
            catch (InternalErrorException e) {
                logger.error("error gettin session", (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
            Node home = (Node)session.getItem("/Home");
            NodeIterator it = home.getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                if (!node.getPrimaryNodeType().getName().equals(NT_HOME)) continue;
                homes.add(node.getName());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return homes;
    }

    public static Session getSession(String user) throws InternalErrorException {
        JCRRepository.initializeRepository();
        Repository repository = JCRRepository.repository;
        synchronized (repository) {
            try {
                logger.debug("session of " + user);
                Session session = JCRRepository.repository.login((Credentials)new SimpleCredentials(user, JCRUserManager.getSecurePassword(user).toCharArray()));
                return session;
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public static Session getSession() throws InternalErrorException {
        JCRRepository.initializeRepository();
        Repository repository = JCRRepository.repository;
        synchronized (repository) {
            try {
                Session session = JCRRepository.repository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()));
                return session;
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public static synchronized void initialize() throws InternalErrorException {
        logger.debug("Initialize repository");
        JCRRepository.initializeRepository();
    }

    public JCRRepository(User user) throws InternalErrorException {
        this.portalLogin = user.getPortalLogin();
        logger.info("getHome " + this.portalLogin);
        try {
            this.init();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public static void removeUser(User user) throws Exception {
        JCRRepository.getServlets().removeItem("/Home/" + user.getPortalLogin());
    }

    public void init() throws Exception {
        JCRUserManager um = new JCRUserManager();
        String userVersion = JCRRepository.getUserVersion(this.portalLogin, um);
        logger.info(this.portalLogin + " - USER VERSION: " + userVersion + " - HL VERSION: " + HLversion);
        if (!HLversion.equals(userVersion)) {
            JCRServlets servlets = null;
            try {
                ItemDelegate inBoxDelegate;
                servlets = JCRRepository.getServlets();
                ItemDelegate home = servlets.getItemByPath("/Home", this.portalLogin);
                DelegateManager homeManager = new DelegateManager(home, this.portalLogin);
                ItemDelegate userHome = null;
                try {
                    userHome = homeManager.addNode(this.portalLogin, NT_HOME);
                    homeManager.save(userHome);
                    um.createUser(this.portalLogin, version + "");
                }
                catch (ItemExistsException e) {
                    userHome = homeManager.getNode(this.portalLogin);
                }
                DelegateManager userHomeManager = new DelegateManager(userHome, this.portalLogin);
                try {
                    ItemDelegate smartFolder = userHomeManager.addNode(SMART_FOLDER, NT_FOLDER);
                    userHomeManager.save(smartFolder);
                }
                catch (ItemExistsException e) {
                    logger.error("error creating Folders");
                }
                try {
                    inBoxDelegate = userHomeManager.addNode(IN_BOX_FOLDER, NT_ROOT_ITEM_SENT);
                    userHomeManager.save(inBoxDelegate);
                }
                catch (ItemExistsException e) {
                    logger.error("error creating InBox");
                }
                try {
                    inBoxDelegate = userHomeManager.addNode(OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT);
                    userHomeManager.save(inBoxDelegate);
                }
                catch (ItemExistsException e) {
                    logger.error("error creating OutBox");
                }
                try {
                    inBoxDelegate = userHomeManager.addNode(HIDDEN_FOLDER, NT_FOLDER);
                    userHomeManager.save(inBoxDelegate);
                }
                catch (ItemExistsException e) {
                    logger.error("error creating HiddenFolder");
                }
                try {
                    inBoxDelegate = userHomeManager.addNode(DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR);
                    userHomeManager.save(inBoxDelegate);
                }
                catch (ItemExistsException e) {
                    logger.error("error creating Downloads");
                }
            }
            catch (InternalErrorException e) {
                throw new InternalErrorException((Throwable)e);
            }
        } else {
            logger.info("skip init in JCRRepository");
        }
    }

    public boolean exist(Node parent, String childName) throws RepositoryException {
        try {
            parent.getNode(childName);
        }
        catch (PathNotFoundException e) {
            logger.info(childName + " does not exist");
            return false;
        }
        return true;
    }

    public List<String> listScopes() throws RepositoryException, InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        return list;
    }

    public static ItemDelegate getGCubeRoot() throws RepositoryException {
        logger.info("getGCubeRoot");
        ItemDelegate gcubeRoot = null;
        try {
            gcubeRoot = JCRRepository.getServlets().getItemByPath("/GCube", null);
        }
        catch (Exception e) {
            gcubeRoot = JCRRepository.getRootNode().addNode(GCUBE_FOLDER, NT_FOLDER);
        }
        try {
            JCRRepository.getServlets().saveItem(gcubeRoot);
        }
        catch (Exception e) {
            logger.error("Error retrieving shared root");
        }
        return gcubeRoot;
    }

    public static ItemDelegate getSharedRoot() throws RepositoryException {
        logger.info("getSharedRoot");
        ItemDelegate sharedNode = null;
        try {
            sharedNode = JCRRepository.getServlets().getItemByPath("/Share", null);
        }
        catch (Exception e) {
            sharedNode = JCRRepository.getRootNode().addNode(SHARED_FOLDER, NT_FOLDER);
        }
        try {
            JCRRepository.getServlets().saveItem(sharedNode);
        }
        catch (Exception e) {
            logger.error("Error retrieving shared root");
        }
        return sharedNode;
    }

    private static DelegateManager getRootNode() {
        ItemDelegate root = null;
        DelegateManager wrap = null;
        try {
            root = JCRRepository.getServlets().getItemByPath(PATH_SEPARATOR, null);
            wrap = new DelegateManager(root, "");
        }
        catch (Exception e) {
            logger.error("Error retrieving Root Node " + e);
        }
        return wrap;
    }

    public ItemDelegate getUserHome() throws RepositoryException, ItemNotFoundException {
        logger.info("getUserHome: /Home/" + this.portalLogin);
        return JCRRepository.getServlets().getItemByPath("/Home/" + this.portalLogin, this.portalLogin);
    }

    public ItemDelegate getRootSmartFolders() throws RepositoryException {
        JCRServlets servlets = JCRRepository.getServlets();
        logger.info("getRootSmartFolders: /Home/" + this.portalLogin + PATH_SEPARATOR + SMART_FOLDER);
        ItemDelegate smartFolders = null;
        if (smartFolders == null) {
            try {
                try {
                    smartFolders = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + SMART_FOLDER, this.portalLogin);
                }
                catch (ItemNotFoundException e) {
                    smartFolders = this.getUserWS(this.portalLogin).addNode(SMART_FOLDER, NT_FOLDER);
                    new DelegateManager(smartFolders, this.portalLogin).save();
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return smartFolders;
    }

    private DelegateManager getUserWS(String user) {
        JCRServlets servlets = JCRRepository.getServlets();
        DelegateManager wrap = null;
        try {
            ItemDelegate item = servlets.getItemByPath("/Home/" + this.portalLogin, this.portalLogin);
            wrap = new DelegateManager(item, this.portalLogin);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        return wrap;
    }

    public Node getOwnInBoxFolder(Session session) throws RepositoryException {
        Node inBoxNode = null;
        if (inBoxNode == null) {
            try {
                try {
                    inBoxNode = session.getNode("/Home/" + this.portalLogin + PATH_SEPARATOR + IN_BOX_FOLDER);
                }
                catch (PathNotFoundException e) {
                    inBoxNode = session.getNode("/Home/" + this.portalLogin).addNode(IN_BOX_FOLDER, NT_ROOT_ITEM_SENT);
                    session.save();
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return inBoxNode;
    }

    public Node getOutBoxFolder(Session session) throws RepositoryException {
        Node outBoxNode = null;
        logger.info("getOutBoxFolder: /Home/" + this.portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
        if (outBoxNode == null) {
            try {
                try {
                    outBoxNode = session.getNode("/Home/" + this.portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
                }
                catch (PathNotFoundException e) {
                    outBoxNode = session.getNode("/Home/" + this.portalLogin).addNode(OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT);
                    session.save();
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return outBoxNode;
    }

    public Node getRootFolderBulkCreators(Session session) throws RepositoryException {
        Node downloads = null;
        logger.info("Get Download Folder: /Home/" + this.portalLogin + PATH_SEPARATOR + DOWNLOADS);
        if (downloads == null) {
            try {
                try {
                    downloads = session.getNode("/Home/" + this.portalLogin + PATH_SEPARATOR + DOWNLOADS);
                }
                catch (PathNotFoundException e) {
                    downloads = session.getNode("/Home/" + this.portalLogin).addNode(DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR);
                    session.save();
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return downloads;
    }

    public Node getHiddenFolder(Session session) throws RepositoryException {
        Node hiddenFolder = null;
        logger.info("hiddenFolder: /Home/" + this.portalLogin + PATH_SEPARATOR + HIDDEN_FOLDER);
        if (hiddenFolder == null) {
            try {
                try {
                    hiddenFolder = session.getNode("/Home/" + this.portalLogin + PATH_SEPARATOR + HIDDEN_FOLDER);
                }
                catch (PathNotFoundException e) {
                    hiddenFolder = session.getNode("/Home/" + this.portalLogin).addNode(HIDDEN_FOLDER, NT_ROOT_ITEM_SENT);
                    session.save();
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return hiddenFolder;
    }

    public Node getInBoxFolder(Session session, String user) throws RepositoryException, InternalErrorException {
        return session.getNode("/Home/" + user + PATH_SEPARATOR + IN_BOX_FOLDER);
    }

    public String getUserHomeUrl(String portalLogin) {
        return url + ROOT_WEBDAV + HOME_FOLDER + PATH_SEPARATOR + portalLogin;
    }

    public String getWebDavUrl(String portalLogin) {
        return webdavUrl + PATH_SEPARATOR + portalLogin;
    }

    public static String getUserVersion(String portalLogin, JCRUserManager um) throws InternalErrorException {
        if (um == null) {
            um = new JCRUserManager();
        }
        String userVersion = um.getVersionByUser(portalLogin);
        return userVersion;
    }

    public static JCRServlets getServlets() {
        if (servletManager == null) {
            servletManager = new JCRServlets();
        }
        return servletManager;
    }

    static {
        logger = LoggerFactory.getLogger(JCRRepository.class);
    }
}

