/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public abstract class JCRWorkspaceFolderItem
extends JCRWorkspaceItem
implements FolderItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String FOLDER_ITEM_TYPE = "hl:workspaceItemType";

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description) throws RepositoryException {
        super(workspace, delegate, name, description);
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }

    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public abstract FolderItemType getFolderItemType();

    public abstract long getLength() throws InternalErrorException;

    public abstract String getMimeType() throws InternalErrorException;

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
        return new ArrayList();
    }

    public void removeChild(WorkspaceItem child) {
    }

    @Override
    public Properties getProperties() throws InternalErrorException {
        try {
            return new JCRProperties(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeRemoteContent(Node node, WorkspaceItemType workspaceItemType) throws RepositoryException, RemoteBackendException {
        block5: {
            try {
                Node contentNode = node.getNode(CONTENT);
                if (!contentNode.hasProperty("hl:remotePath")) break block5;
                String remotePath = contentNode.getProperty("hl:remotePath").getString();
                try {
                    if (workspaceItemType == WorkspaceItemType.FOLDER) {
                        this.workspace.getStorage().removeRemoteFolder(remotePath, this.workspace.getOwner().getPortalLogin());
                        break block5;
                    }
                    this.workspace.getStorage().removeRemoteFile(remotePath, this.workspace.getOwner().getPortalLogin());
                }
                catch (Exception e) {
                    logger.warn(node.getName() + " payload not available", (Throwable)e);
                }
            }
            catch (PathNotFoundException e) {
                logger.error("Content node jcr:content not found", (Throwable)e);
            }
        }
    }

    public void copyRemoteContent(ItemDelegate node) throws RepositoryException, RemoteBackendException {
        block4: {
            try {
                Map contentNode = node.getContent();
                if (!contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) break block4;
                String remotePath = (String)contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
                String newRemotePath = node.getPath();
                logger.debug("copy from remote path: " + remotePath + " to: " + newRemotePath);
                this.workspace.getStorage().copyRemoteFile(remotePath, newRemotePath, this.workspace.getOwner().getPortalLogin());
                contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, newRemotePath);
                contentNode.put(NodeProperty.DATA, Integer.toBinaryString(0));
                DelegateManager wrap = null;
                try {
                    wrap = new DelegateManager(node, this.workspace.getOwner().getPortalLogin());
                    wrap.save();
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Content property jcr:content not found", (Throwable)e);
            }
        }
    }

    public void setHardLink(ItemDelegate node, String hardLinkRemotePath) throws RepositoryException {
        logger.info("hardLinkRemotePath: " + hardLinkRemotePath);
        try {
            Map content = node.getContent();
            if (content.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                String remotePath = (String)content.get(NodeProperty.REMOTE_STORAGE_PATH);
                this.workspace.getStorage().createHardLink(remotePath, hardLinkRemotePath, this.workspace.getOwner().getPortalLogin());
                content.put(NodeProperty.REMOTE_STORAGE_PATH, hardLinkRemotePath);
                DelegateManager wrap = new DelegateManager(node, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
        }
        catch (Exception e) {
            logger.error("Content node jcr:content not found", (Throwable)e);
        }
    }
}

