package org.gcube.common.homelibrary.jcr.repository;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;

import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.PrimaryNodeType;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.omg.PortableServer.POA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class JCRRepository {

	public static final String HL_NAMESPACE					= "hl:";
	public static final String JCR_NAMESPACE				= "jcr:";
	public static final String REP_NAMESPACE				= "rep:";

	public static final String PATH_SEPARATOR 				= "/";
	public static final String ROOT_WEBDAV					= "/repository/default/";

	//root level
	public static final String HOME_FOLDER 					= "Home";
	public static final String SHARED_FOLDER				= "Share";
	private static final String GCUBE_FOLDER 				= "GCube";

	//home level
	private static final String DOWNLOADS					= "Downloads";
	private static final String SMART_FOLDER 				= "Folders";
	private static final String IN_BOX_FOLDER 				= "InBox";
	private static final String OUT_BOX_FOLDER				= "OutBox";
	private static final String HIDDEN_FOLDER				= "HiddenFolder";

	private static final String NT_FOLDER 					= "nt:folder";
	private static final String NT_HOME						= "nthl:home";
	public static final String 	NT_WORKSPACE_FOLDER 		= "nthl:workspaceItem";
	private static final String NT_ROOT_ITEM_SENT  			= "nthl:rootItemSentRequest";
	private static final String NT_ROOT_FOLDER_BULK_CREATOR = "nthl:rootFolderBulkCreator";

	private static final String SCOPES						= "hl:scopes";

	private static final String nameResource 				= "HomeLibraryRepository";


	private static Repository repository;
	private static JCRServlets servletManager;
	private String portalLogin;

	public static String user;
	public static String pass;
	public static String url;
	private static String webdavUrl;
	public static String serviceName;

	//HL release version
	public static String HLversion;
	private static String version;
	private static String minorVersion;
	private static String revisionVersion;


	private static Logger logger = LoggerFactory.getLogger(JCRRepository.class);


	private static synchronized void initializeRepository() throws InternalErrorException {

		if(repository != null)
			return;


		String callerScope = ScopeProvider.instance.get();

		try {

			if (callerScope==null) throw new IllegalArgumentException("scope is null");

			String rootScope = Utils.getRootScope(callerScope);

			logger.debug("scope for repository creation is "+rootScope+" caller scope is "+callerScope);

			ScopeProvider.instance.set(rootScope);



//			url = "https://ws-repo-test.d4science.org/home-library-webapp";
//			user = "workspacerep.imarine";						
//			pass = "gcube2010*onan";
//			version = "3";
//			minorVersion = "1";
//			revisionVersion = "1";
//			HLversion =  version + "." + minorVersion + "." + revisionVersion;
//			webdavUrl = "https://www.d4science.org/Home";
//			serviceName = "home-library";	


						SimpleQuery query = queryFor(ServiceEndpoint.class);
			
						query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq '"+ nameResource + "' ");
			
						DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
			
						List<ServiceEndpoint> resources = client.submit(query);
			
						if(resources.size() != 0) {	   
							try {
								ServiceEndpoint resource = resources.get(0);
			
								for (AccessPoint ap:resource.profile().accessPoints()) {
			
									if (ap.name().equals("JCR")) {
			
										url = ap.address();
										user = ap.username();						
										pass = StringEncrypter.getEncrypter().decrypt(ap.password());
			
										Iterator<org.gcube.common.resources.gcore.ServiceEndpoint.Property> properties = ap.properties().iterator();
										while(properties.hasNext()) {
											org.gcube.common.resources.gcore.ServiceEndpoint.Property p = properties.next();		
											if (p.name().equals("version")){							
												version = p.value();
											} else if (p.name().equals("minorVersion")){							
												minorVersion = p.value();
											} else if (p.name().equals("revisionVersion")){							
												revisionVersion = p.value();
											}
										}	
										HLversion =  version + "." + minorVersion + "." + revisionVersion;
										//							System.out.println("HL VERSION: " + version + "." + minorVersion + "." + revisionVersion);					
									}
									else if (ap.name().equals("WebDav")) {								
										webdavUrl = ap.address();				
									}else if (ap.name().equals("ServiceName")) {								
										serviceName = ap.address();				
									}
								}
							} catch (Throwable e) {
								logger.error("error decrypting resource",e);
							}
						}


			if (user==null || pass==null) throw new InternalErrorException("cannot discover password and username in scope "+callerScope);

			repository = new URLRemoteRepository(url + "/rmi");
			//			repository = JcrUtils.getRepository(url + "/server");

			logger.debug("user is "+user+" password is null?"+(pass==null)+" and repository is null?"+(repository==null));

		} catch (Exception e) {
			throw new InternalErrorException(e);
		}finally{
			if (callerScope!=null)
				ScopeProvider.instance.set(callerScope);
		}

	}

	/**
	 * Get a string with credentials
	 * @return
	 */
	public static String getCredetials() {
		String credentials = "adminId=" + JCRRepository.user + "&adminPassword=" + JCRRepository.pass;
		return credentials;
	}


	public static List<String> getHomeNames() throws RepositoryException{
		List<String> homes = new ArrayList<String>();
		Session session = null;
		try{
			try {
				session = getSession();
			} catch (InternalErrorException e) {
				logger.error("error gettin session",e);
				throw new RepositoryException(e);
			}
			Node home = (Node)session.getItem(PATH_SEPARATOR+HOME_FOLDER);
			NodeIterator it = home.getNodes();
			while (it.hasNext()){
				Node node = it.nextNode();
				if (node.getPrimaryNodeType().getName().equals(NT_HOME))
					homes.add(node.getName());
			}
		}finally{
			if (session != null)
				session.logout();
		}
		return homes;
	}



	//	private static void addUserToJCRUserManager(String userId, String userHome) {
	//
	//		GetMethod getMethod = null;
	//		try {
	//
	//			HttpClient httpClient = new HttpClient();            
	//			//			 System.out.println(url);
	//			getMethod =  new GetMethod(url + "/PortalUserManager?userId=" + userId + "&userHome=" +userHome);
	//			httpClient.executeMethod(getMethod);
	//
	//			logger.debug("User set with status code " + getMethod.getResponseBodyAsString());
	//
	//		} catch (Exception e) {
	//			logger.error("User set with error ", e);
	//		} finally {
	//			if(getMethod != null)
	//				getMethod.releaseConnection();
	//		}
	//
	//	}



	public static Session getSession(String user) throws InternalErrorException  {
		//		System.out.println("GET SESSION BY USER");
		initializeRepository();
		synchronized (repository) {
			try {
				logger.debug("session of " + user);
				Session session = repository.login( 
						new SimpleCredentials(user, JCRUserManager.getSecurePassword(user).toCharArray()));
				return session;
			} catch (Exception e) {
				throw new InternalErrorException(e);
			}
		}
	}

	public static Session getSession() throws InternalErrorException  {
		//		System.out.println("GET SESSION");
		initializeRepository();
		synchronized (repository) {
			try {
				Session session = repository.login( 
						new SimpleCredentials(user, pass.toCharArray()));
				return session;
			} catch (Exception e) {
				throw new InternalErrorException(e);
			}
		}
	}

	public synchronized static void initialize() throws InternalErrorException {
		logger.debug("Initialize repository");
		initializeRepository();

	}

	public JCRRepository(final User user) throws InternalErrorException {

		portalLogin = user.getPortalLogin();
		logger.info("getHome " + portalLogin);
		try {
			init();
		} catch (Exception e) {
			throw new InternalErrorException(e);
		}

	}

	public static void removeUser(User user) throws Exception {
		 getServlets().removeItem(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR + user.getPortalLogin());
	}


	/**
	 * Create folder in /Home/xxx/
	 * @param user
	 * @throws Exception 
	 */
	public void init() throws Exception{

		//		System.out.println("INIT.................");
		JCRUserManager um = new JCRUserManager();
		String userVersion = getUserVersion(portalLogin, um);
		//		System.out.println(userVersion   + " <--- " );

		logger.info(portalLogin + " - USER VERSION: " + userVersion + " - HL VERSION: " + HLversion);

		if(!HLversion.equals(userVersion)){

			JCRServlets servlets = null;
			try {
				servlets = JCRRepository.getServlets();

				ItemDelegate home = servlets.getItemByPath("/" + HOME_FOLDER, portalLogin);

				DelegateManager homeManager = new DelegateManager(home, portalLogin);

				//create user folder es. Home/test.test

				ItemDelegate userHome = null;
				try {
					userHome = homeManager.addNode(portalLogin, NT_HOME);	
					//					System.out.println("userHome " + userHome.toString());
					homeManager.save(userHome);

					um.createUser(portalLogin, version+"");

				} catch (ItemExistsException e) {
					userHome = homeManager.getNode(portalLogin);
				}

				//create folders es. Home/test.test/Folders
				DelegateManager userHomeManager = new DelegateManager(userHome, portalLogin);

				try {
					ItemDelegate smartFolder = userHomeManager.addNode(SMART_FOLDER, NT_FOLDER);	
					userHomeManager.save(smartFolder);

				} catch (ItemExistsException e) {
					logger.error("error creating "+ SMART_FOLDER);
				}

				try {
					ItemDelegate inBoxDelegate = userHomeManager.addNode(IN_BOX_FOLDER, NT_ROOT_ITEM_SENT);	
					userHomeManager.save(inBoxDelegate);

				} catch (ItemExistsException e) {
					logger.error("error creating "+ IN_BOX_FOLDER);
				}

				try {
					ItemDelegate inBoxDelegate = userHomeManager.addNode(OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT);	
					userHomeManager.save(inBoxDelegate);

				} catch (ItemExistsException e) {
					logger.error("error creating "+ OUT_BOX_FOLDER);
				}

				try {
					ItemDelegate inBoxDelegate = userHomeManager.addNode(HIDDEN_FOLDER, NT_FOLDER);	
					userHomeManager.save(inBoxDelegate);

				} catch (ItemExistsException e) {
					logger.error("error creating "+ HIDDEN_FOLDER);
				}
				try {
					ItemDelegate inBoxDelegate = userHomeManager.addNode(DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR);	
					userHomeManager.save(inBoxDelegate);

				} catch (ItemExistsException e) {
					logger.error("error creating "+ DOWNLOADS);
				}


			}catch (InternalErrorException e) {
				throw new InternalErrorException(e);
			}

		}else
			logger.info("skip init in JCRRepository");
	}



	public boolean exist(Node parent, String childName) throws RepositoryException {
		try {
			parent.getNode(childName);
		} catch (PathNotFoundException e) {
			logger.info(childName + " does not exist");
			return false;
		} 
		return true;
	}


	public List<String> listScopes() throws RepositoryException, InternalErrorException {
		
				List<String> list = new LinkedList<String>();
		//
		//		Session session = getSession();
		//		try {
		//			Node userHome = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR + portalLogin);
		//			Property scopes = userHome.getProperty(SCOPES);
		//
		//			for (Value value  : scopes.getValues()) {
		//				list.add(value.getString());
		//			}
					return list;
		//
		//		} catch (PathNotFoundException e) {
		//			return new LinkedList<String>();
		//		} finally {
		//			if (session != null)
		//				session.logout();
		//		}
	}


	/**
	 * Get gCube root
	 * @return gCube root
	 * @throws RepositoryException
	 */
	public static ItemDelegate getGCubeRoot() throws RepositoryException {

		logger.info("getGCubeRoot");
		ItemDelegate gcubeRoot = null;
		try{
			gcubeRoot = getServlets().getItemByPath(PATH_SEPARATOR + GCUBE_FOLDER, null);
		}catch (Exception e) {
			gcubeRoot = getRootNode().addNode(GCUBE_FOLDER, NT_FOLDER);
		}
		try {
			getServlets().saveItem(gcubeRoot);
		} catch (Exception e) {
			logger.error("Error retrieving shared root");
		}
		return gcubeRoot;
	}

	/**
	 * get SharedRoot
	 * @return SharedRoot
	 * @throws RepositoryException
	 */
	public static ItemDelegate getSharedRoot() throws RepositoryException {
		logger.info("getSharedRoot");
		ItemDelegate sharedNode = null;
		try{
			sharedNode = getServlets().getItemByPath(PATH_SEPARATOR + SHARED_FOLDER, null);
		}catch (Exception e) {
			sharedNode = getRootNode().addNode(SHARED_FOLDER, NT_FOLDER);
		}
		try {
			getServlets().saveItem(sharedNode);
		} catch (Exception e) {
			logger.error("Error retrieving shared root");
		}
		return sharedNode;
	}


	/**
	 * Get root node
	 * @return
	 */
	private static DelegateManager getRootNode() {
		ItemDelegate root = null;
		DelegateManager wrap = null;
		try{
			root = getServlets().getItemByPath(PATH_SEPARATOR, null);
			wrap = new DelegateManager(root, "");
		}catch (Exception e) {
			logger.error("Error retrieving Root Node " + e);
		}
		return wrap;
	}


	/**
	 * get User Home
	 * @param session
	 * @return
	 * @throws RepositoryException
	 * @throws ItemNotFoundException 
	 */
	public ItemDelegate getUserHome() throws RepositoryException, ItemNotFoundException {		
		logger.info("getUserHome: " + PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR + portalLogin);
		return  getServlets().getItemByPath(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR + portalLogin, portalLogin);
	}


	/**
	 * Get Smart Folders root
	 * @param session
	 * @return Smart Folders root
	 * @throws RepositoryException
	 */
	public ItemDelegate getRootSmartFolders() throws RepositoryException{

		JCRServlets servlets = JCRRepository.getServlets();
		logger.info("getRootSmartFolders: " + PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
				+ portalLogin + PATH_SEPARATOR + SMART_FOLDER);
		ItemDelegate smartFolders = null;
		if (smartFolders==null){
			try {
				//create applicationFolder
				try {		
					smartFolders = servlets.getItemByPath(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin + PATH_SEPARATOR + SMART_FOLDER, portalLogin);
				} catch (ItemNotFoundException e) {	
					smartFolders = getUserWS(portalLogin).addNode(SMART_FOLDER, NT_FOLDER);
					new DelegateManager(smartFolders, portalLogin).save();
				}
			}catch (Exception e) {
				throw new RepositoryException(e);
			} 
		}
		return smartFolders;
	}



	private DelegateManager getUserWS(String user) {
		JCRServlets servlets = JCRRepository.getServlets();

		DelegateManager wrap = null;
		try {
			ItemDelegate item = servlets.getItemByPath(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
					+ portalLogin, portalLogin);
			wrap = new DelegateManager(item, portalLogin);

		} catch (ItemNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return wrap;

	}


	/**
	 * get InBoxFolder
	 * @param session
	 * @return InBoxFolder
	 * @throws RepositoryException
	 */
	public Node getOwnInBoxFolder(Session session) throws RepositoryException {

		Node inBoxNode = null;

		if (inBoxNode==null){
			try {
				//create applicationFolder
				try {				
					inBoxNode = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin + PATH_SEPARATOR + IN_BOX_FOLDER);	
				} catch (PathNotFoundException e) {
					inBoxNode = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin).addNode(IN_BOX_FOLDER, NT_ROOT_ITEM_SENT);
					session.save();
				}
			}catch (Exception e) {
				throw new RepositoryException(e);
			}
		}
		return inBoxNode;

	}

	/**
	 * get OutBoxFolder
	 * @param session
	 * @return OutBoxFolder
	 * @throws RepositoryException
	 */
	public Node getOutBoxFolder(Session session) throws RepositoryException {

		Node outBoxNode = null;

		logger.info("getOutBoxFolder: " + PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
				+ portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
		if (outBoxNode==null){
			try {
				//create applicationFolder
				try {				
					outBoxNode = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);	
				} catch (PathNotFoundException e) {
					outBoxNode = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin).addNode(OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT);
					session.save();
				}
			}catch (Exception e) {
				throw new RepositoryException(e);
			}
		}
		return outBoxNode;
	}

	/**
	 * Get Download folder
	 * @param session
	 * @return Download folder
	 * @throws RepositoryException
	 */
	public Node getRootFolderBulkCreators(Session session) throws RepositoryException {

		Node downloads = null;

		logger.info("Get Download Folder: " + PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
				+ portalLogin + PATH_SEPARATOR + DOWNLOADS);
		if (downloads==null){
			try {
				//create applicationFolder
				try {				
					downloads = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin + PATH_SEPARATOR + DOWNLOADS);	
				} catch (PathNotFoundException e) {
					downloads = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin).addNode(DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR);
					session.save();
				}
			}catch (Exception e) {
				throw new RepositoryException(e);
			}
		}
		return downloads;
	}


	/**
	 * Get Hidden folder
	 * @param session
	 * @return Hidden folder
	 * @throws RepositoryException
	 */
	public Node getHiddenFolder(Session session) throws RepositoryException {

		Node hiddenFolder = null;

		logger.info("hiddenFolder: " + PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
				+ portalLogin + PATH_SEPARATOR + HIDDEN_FOLDER);
		if (hiddenFolder==null){
			try {
				//create applicationFolder
				try {				
					hiddenFolder = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin + PATH_SEPARATOR + HIDDEN_FOLDER);	
				} catch (PathNotFoundException e) {
					hiddenFolder = session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
							+ portalLogin).addNode(HIDDEN_FOLDER, NT_ROOT_ITEM_SENT);
					session.save();
				}
			}catch (Exception e) {
				throw new RepositoryException(e);
			}
		}
		return hiddenFolder;
	}


	/**
	 * get InBoxFolder
	 * @param session
	 * @param user
	 * @return InBoxFolder
	 * @throws RepositoryException
	 * @throws InternalErrorException
	 */
	public Node getInBoxFolder(Session session, String user) throws RepositoryException,
	InternalErrorException  {
		return session.getNode(PATH_SEPARATOR + HOME_FOLDER + PATH_SEPARATOR 
				+ user + PATH_SEPARATOR + IN_BOX_FOLDER);
	}

	public String getUserHomeUrl(String portalLogin) {
		return url + ROOT_WEBDAV + HOME_FOLDER + PATH_SEPARATOR + portalLogin;     
	}

	public String getWebDavUrl(String portalLogin) {
		return webdavUrl + PATH_SEPARATOR + portalLogin;      
	}



	public static String getUserVersion(String portalLogin, JCRUserManager um) throws InternalErrorException {
		if (um==null)
			um = new JCRUserManager();
		String userVersion = um.getVersionByUser(portalLogin);
		return userVersion;
	}


	public static JCRServlets getServlets() {
		if (servletManager==null)
			servletManager = new JCRServlets();

		return servletManager;
	}


}
