/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;

public class JCRAccountingEntryRenaming
extends JCRAccountingEntry
implements AccountingEntryRenaming {
    private final String oldItemName;

    public JCRAccountingEntryRenaming(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.oldItemName = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.OLD_ITEM_NAME));
    }

    public JCRAccountingEntryRenaming(String id, String user, Calendar date, String oldItemName) {
        super(id, user, date);
        this.oldItemName = oldItemName;
        Map properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.OLD_ITEM_NAME, new XStream().toXML((Object)oldItemName));
        this.entryDelegate.setEntryType(AccountingEntryType.RENAMING);
    }

    public String getOldItemName() {
        return this.oldItemName;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.RENAMING;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s oldItemName:%s]]", parentValue, AccountingEntryType.RENAMING, this.oldItemName);
    }
}

