/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.importing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.jcr.importing.ContentManagerItemType;
import org.gcube.common.homelibrary.jcr.importing.ImportContentManagerItemRequest;
import org.gcube.common.homelibrary.jcr.importing.ImportQueryRequest;
import org.gcube.common.homelibrary.jcr.importing.ImportRequest;
import org.gcube.common.homelibrary.jcr.importing.ImportUrlRequest;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceFolderItemImporter
implements Runnable {
    private List<ImportContentManagerItemRequest> contentItemRequests;
    private List<ImportUrlRequest> urlRequests;
    private List<ImportQueryRequest> queryRequests;
    private final JCRRepository contentManager;
    private final String folderBulkCreatorId;
    private final JCRFolderBulkCreatorManager manager;
    private final String STATUS = "hl:status";
    private final String FAILURES = "hl:failures";
    private int failures;
    private int status;
    private final int totalRequests;
    private final JCRWorkspaceFolder folder;
    private Logger logger = LoggerFactory.getLogger(JCRWorkspaceFolder.class);

    public JCRWorkspaceFolderItemImporter(JCRFolderBulkCreatorManager manager, String folderBulkCreatorId, List<ImportRequest> requests, JCRWorkspaceFolder folder) throws InternalErrorException {
        this.manager = manager;
        this.folderBulkCreatorId = folderBulkCreatorId;
        this.contentManager = folder.getWorkspace().getRepository();
        this.folder = folder;
        this.status = 0;
        this.failures = 0;
        this.contentItemRequests = new LinkedList<ImportContentManagerItemRequest>();
        this.urlRequests = new LinkedList<ImportUrlRequest>();
        this.queryRequests = new LinkedList<ImportQueryRequest>();
        this.totalRequests = requests.size();
        for (ImportRequest request : requests) {
            switch (request.getType()) {
                case CONTENT_MANAGER_ITEM: {
                    this.contentItemRequests.add((ImportContentManagerItemRequest)request);
                    break;
                }
                case URL: {
                    this.urlRequests.add((ImportUrlRequest)request);
                    break;
                }
                case QUERY: {
                    this.queryRequests.add((ImportQueryRequest)request);
                }
            }
        }
    }

    @Override
    public void run() {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        for (ImportContentManagerItemRequest importContentManagerItemRequest : this.contentItemRequests) {
            final URI uri = importContentManagerItemRequest.getUri();
            if (importContentManagerItemRequest.getItemType() != ContentManagerItemType.DOCUMENT) continue;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = null;
                    try {
                        try {
                            URLConnection connection = uri.toURL().openConnection();
                            inputStream = connection.getInputStream();
                        }
                        catch (IOException e) {
                            JCRWorkspaceFolderItemImporter.this.logger.error("Content retrieving failed", (Throwable)e);
                            try {
                                inputStream.close();
                            }
                            catch (Exception e2) {
                                JCRWorkspaceFolderItemImporter.this.logger.error("InputStream not closed");
                            }
                            return;
                        }
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            JCRWorkspaceFolderItemImporter.this.logger.error("InputStream not closed");
                        }
                    }
                }
            });
        }
        executorService.shutdown();
        for (ImportUrlRequest importUrlRequest : this.urlRequests) {
            String name = importUrlRequest.getUrl();
            try {
                name = this.folder.getUniqueName(name, false);
                ExternalUrl externalUrl = this.folder.createExternalUrlItem(name, "", importUrlRequest.getUrl());
                this.folder.getWorkspace().fireItemImportedEvent((WorkspaceItem)externalUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getCollectionName(URI uri) throws Exception {
        String uriString = uri.toString();
        String[] values = uriString.split("/tree/");
        String[] subValues = values[1].split("/");
        String collectionID = subValues[0];
        String[] IdAndScope = subValues[1].split("\\?");
        String treeID = IdAndScope[0];
        StringBuilder title = new StringBuilder();
        title.append(treeID);
        title.append("(");
        title.append(collectionID);
        title.append(")");
        return title.toString();
    }
}

