/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.homelibary.model.util.Cleanable;
import org.gcube.common.homelibary.model.util.MemoryCache;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRHomeManager
implements HomeManager {
    private static final String GUEST = "guest";
    private Map<String, JCRUser> users = new LinkedHashMap<String, JCRUser>();
    private static long timeToLiveInSeconds = 3600L;
    private static long timerIntervalInSeconds = 7200L;
    private static int maxItems = 20;
    private static MemoryCache<String, Home> cache = new MemoryCache(timeToLiveInSeconds, timerIntervalInSeconds, maxItems);
    private HomeManagerFactory factory;
    private static Logger logger = LoggerFactory.getLogger(JCRHomeManager.class);

    public JCRHomeManager(HomeManagerFactory factory) {
        this.factory = factory;
    }

    public HomeManagerFactory getHomeManagerFactory() {
        return this.factory;
    }

    public List<User> getUsers() {
        return new LinkedList<User>(this.users.values());
    }

    public User getUser(String portalLogin) throws InternalErrorException {
        logger.debug("getUser portalLogin: " + portalLogin);
        return this.createUser(portalLogin);
    }

    public synchronized boolean existUser(String portalLogin) throws InternalErrorException {
        logger.trace("existUser portalLogin: " + portalLogin);
        if (portalLogin == null) {
            logger.error("portalLogin null");
            throw new IllegalArgumentException("The portalLogin value is null");
        }
        return this.users.containsKey(portalLogin);
    }

    public synchronized User createUser(String portalLogin) throws InternalErrorException {
        JCRUser user = this.users.get(portalLogin);
        if (user == null) {
            try {
                logger.debug("User " + portalLogin + " not found, creating a new one.");
                user = new JCRUser(UUID.randomUUID().toString(), portalLogin);
                logger.debug("User created: " + user.getPortalLogin());
                this.users.put(portalLogin, user);
                this.getHome(user);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return user;
    }

    public Home getHome(User user) throws InternalErrorException, HomeNotFoundException {
        JCRHome home;
        logger.debug("getHome user: " + user.getPortalLogin());
        if (cache.containsKey((Object)user.getPortalLogin())) {
            logger.debug("User is already logged");
            Home home2 = (Home)cache.get((Object)user.getPortalLogin());
            return home2;
        }
        try {
            home = new JCRHome(this, (JCRUser)user);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        logger.debug("Add " + user.getPortalLogin() + "'s home to memory cache");
        cache.put((Object)user.getPortalLogin(), (Cleanable)home);
        logger.trace("User loaded.");
        return home;
    }

    public Home getGuestLogin() throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.debug("getHome portalLogin: guest");
        User user = this.getUser(GUEST);
        return this.getHome(user);
    }

    public Home getHome(String portalLogin) throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.debug("getHome portalLogin: " + portalLogin);
        User user = this.getUser(portalLogin);
        return this.getHome(user);
    }

    public synchronized void removeUser(User user) throws InternalErrorException {
        cache.remove((Object)user.getPortalLogin());
    }

    public MemoryCache<String, Home> getCache() throws InternalErrorException {
        return cache;
    }

    public Home getHome() throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        AuthorizationEntry entry = null;
        try {
            entry = Constants.authorizationService().get(SecurityTokenProvider.instance.get());
        }
        catch (Exception e1) {
            throw new InternalErrorException("User not authorize to access Home Library");
        }
        String portalLogin = entry.getClientInfo().getId();
        return this.getHome(portalLogin);
    }
}

