/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
    public static final String SERVICE_NAME = "home-library";
    public static final String SERVICE_CLASS = "org.gcube.portlets.user";
    private String portalLogin;
    private IClient storage;

    public GCUBEStorage(String portalLogin) {
        try {
            this.portalLogin = portalLogin;
            this.storage = this.getClient();
        }
        catch (Exception e) {
            throw new RemoteBackendException("Error initializing GCUBE Storage: " + e.getMessage(), (Throwable)e);
        }
    }

    private IClient getClient() {
        if (this.storage == null) {
            logger.info("******* Initialize Storage of user " + this.portalLogin + " **********");
            this.storage = new StorageClient(SERVICE_CLASS, SERVICE_NAME, this.portalLogin, AccessType.SHARED, MemoryType.PERSISTENT).getClient();
            logger.info("******* Storage activateProtocol for Storage **********");
            Handler.activateProtocol();
            logger.info("******* Storage Done **********");
        }
        return this.storage;
    }

    public String putStream(InputStream is, String remotePath, String mimeType) throws RemoteBackendException, IOException {
        logger.trace("GCUBE Storage - PutStream - remotePath: " + remotePath + " - mimetype: " + mimeType);
        String storageId = null;
        try {
            storageId = this.getClient().put(true, mimeType).LFile(is).RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException("GCUBE Storage error in putStream operation: " + e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
                logger.trace("GCUBE Storage inputStream closed");
            }
        }
        return storageId;
    }

    public String putStream(InputStream is, String remotePath) throws RemoteBackendException, IOException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + remotePath);
        String storageId = null;
        try {
            storageId = this.getClient().put(true).LFile(is).RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
                logger.trace("GCUBE Storage inputStream closed");
            }
        }
        return storageId;
    }

    public String putStream(String old_remotePath, String new_remotePath, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage -putStream - remotePath: " + new_remotePath);
        String storageID = null;
        try {
            storageID = this.getClient().put(true, mimeType).LFile(old_remotePath).RFile(new_remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return storageID;
    }

    public long getRemoteFileSize(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        long size = 0L;
        try {
            size = this.getClient().getSize().RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return size;
    }

    public void removeRemoteFile(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - removeRemoteFile - remotePath: " + remotePath);
        try {
            this.getClient().remove().RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public long getRemoteFileSize(String remotePath, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        try {
            return this.getClient().getSize().RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public long getDiskUsageByUser() throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume used by user: " + this.portalLogin + "");
        long diskUsage = 0L;
        try {
            diskUsage = Long.parseLong(this.getClient().getTotalUserVolume());
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return diskUsage;
    }

    public int getTotalItemsByUser() throws RemoteBackendException {
        logger.trace("GCUBE Storage - get tot items of user " + this.portalLogin + "");
        int totalItem = 0;
        try {
            totalItem = Integer.parseInt(this.getClient().getUserTotalItems());
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return totalItem;
    }

    public long getFolderTotalVolume(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        long volume = 0L;
        try {
            volume = Long.parseLong(this.getClient().getFolderTotalVolume().RDir(remotePath).toString());
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return volume;
    }

    public String getFolderLastUpdate(String remotePath) throws RemoteBackendException {
        String lastUpdate;
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        try {
            lastUpdate = this.getClient().getFolderLastUpdate().RDir(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return lastUpdate;
    }

    public int getFolderTotalItems(String remotePath) throws RemoteBackendException {
        int totalItems;
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        try {
            totalItems = Integer.parseInt(this.getClient().getFolderTotalItems().RDir(remotePath).toString());
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return totalItems;
    }

    public InputStream getRemoteFile(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage -getRemoteFile - stream = storage.get().RFileAsInputStream(" + remotePath + ")");
        InputStream stream = null;
        try {
            stream = this.getClient().get().RFileAsInputStream(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return stream;
    }

    public String getPublicLink(String remotePath) throws RemoteBackendException {
        String publicLink;
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        try {
            publicLink = this.getClient().getHttpUrl().RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return publicLink;
    }

    public String getClientId(String remotePath) throws RemoteBackendException {
        String id;
        logger.trace("GCUBE Storage - Get Storage  Id for " + remotePath);
        try {
            MyFile file = this.getClient().getMetaFile().RFile(remotePath);
            id = file.getId();
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return id;
    }

    public String getRemotePathByStorageId(String storageId) throws RemoteBackendException {
        String remotePath;
        logger.trace("GCUBE Storage - Get RemotePath by Storage Id " + storageId);
        try {
            remotePath = this.getClient().getRemotePath().RFile(storageId);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return remotePath;
    }

    public void moveRemoteFolder(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.moveDir().from(" + oldPath + ").to(" + newPath + ")");
        try {
            this.getClient().moveDir().from(oldPath).to(newPath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public void moveRemoteFile(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.moveFile().from(" + oldPath + ").to(" + newPath + ")");
        try {
            this.getClient().moveFile().from(oldPath).to(newPath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public void copyRemoteFile(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.copyFile().from(" + oldPath + ").to(" + newPath + ")");
        try {
            this.getClient().copyFile().from(oldPath).to(newPath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public void createHardLink(String srcPath, String destPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.linkFile().from(" + srcPath + ").to(" + destPath + ")");
        try {
            this.getClient().linkFile().from(srcPath).to(destPath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public void removeRemoteFolder(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        try {
            this.getClient().removeDir().RDir(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public String putStream(InputStream is, String new_remotePath, String serviceName, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + new_remotePath);
        String storageId = null;
        try {
            if (is != null) {
                is.close();
            }
            this.getClient().getUrl().RFile(new_remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return storageId;
    }

    public String getMetaInfo(String field, String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - getMetaInfo: field: " + field + "; remotePath: " + remotePath);
        String metadata = null;
        try {
            metadata = this.getClient().getMetaInfo(field).RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return metadata;
    }

    public void setMetaInfo(String field, String value, String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - getMetaInfo: field: " + field + "; remotePath: " + remotePath);
        try {
            this.getClient().setMetaInfo(field, value).RFile(remotePath);
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public String getStorageId(String remotePath) throws RemoteBackendException {
        String id;
        logger.trace("GCUBE Storage - Get Storage  Id for " + remotePath);
        try {
            MyFile file = this.getClient().getMetaFile().RFile(remotePath);
            id = file.getId();
        }
        catch (Exception e) {
            throw new RemoteBackendException(e.getMessage());
        }
        return id;
    }

    public boolean isStorageIdValid(String storageID) {
        try {
            logger.info("Reading element with storage id " + storageID);
            InputStream is = this.getClient().get().RFileAsInputStream(storageID);
            int read = is.read();
            if (read == -1) {
                throw new Exception("Unable to read storage element with id " + storageID);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Error while checking storage id", (Object)storageID);
            return false;
        }
    }
}

