/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.sharing;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessage
implements WorkspaceMessage {
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessage.class);
    private static final String NT_WORKSPACE_FOLDER_ITEM = "nthl:workspaceLeafItem";
    private final JCRWorkspace workspace;
    private final ItemDelegate messageItem;
    private final WorkspaceMessageType type;
    private List<String> copyAttachmentIds;
    private boolean isRead;
    private boolean isOpened;

    public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate messageItem, WorkspaceMessageType type) throws javax.jcr.RepositoryException {
        this.workspace = workspace;
        this.messageItem = messageItem;
        this.type = type;
    }

    public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate messageItem, WorkspaceMessageType type, String messageId, String subject, String body, User sender, List<String> attachmentIds, List<String> addresses) throws javax.jcr.RepositoryException, InternalErrorException {
        this.workspace = workspace;
        this.messageItem = messageItem;
        this.type = type;
        this.copyAttachmentIds = new ArrayList<String>();
        this.isRead = false;
        this.isOpened = false;
        HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
        content.put(NodeProperty.SUBJECT, subject);
        content.put(NodeProperty.BODY, body);
        content.put(NodeProperty.READ, new XStream().toXML((Object)false));
        content.put(NodeProperty.OPEN, new XStream().toXML((Object)false));
        content.put(NodeProperty.PORTAL_LOGIN, sender.getPortalLogin());
        content.put(NodeProperty.ADDRESSES, new XStream().toXML((Object)addresses.toArray(new String[addresses.size()])));
        content.put(NodeProperty.ATTACHMENTS_ID, new XStream().toXML(attachmentIds));
        messageItem.setContent(content);
        JCRServlets servlets = null;
        String rootAttachmentsId = null;
        try {
            servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
            ItemDelegate saved = servlets.saveItem(messageItem);
            DelegateManager dm = new DelegateManager(saved, workspace.getOwner().getPortalLogin());
            rootAttachmentsId = dm.getNode(NodeProperty.ATTACHMENTS_ID.toString()).getId();
        }
        catch (ItemNotFoundException | RepositoryException e1) {
            e1.printStackTrace();
        }
        LinkedList<User> users = new LinkedList<User>();
        for (String address : addresses) {
            User user = workspace.getHome().getHomeManager().getUser(address);
            if (user == null) continue;
            users.add(user);
        }
        try {
            try {
                logger.info("attachmentIds.size() " + attachmentIds.size());
                for (String attachmentId : attachmentIds) {
                    ItemDelegate nodeItem = servlets.getItemById(attachmentId);
                    JCRWorkspaceItem item = workspace.getWorkspaceItem(nodeItem);
                    if (!item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) continue;
                    try {
                        logger.info("nodeItem.getName() " + nodeItem.getName());
                        ItemDelegate att = servlets.getItemById(rootAttachmentsId);
                        ItemDelegate newNode = item.internalCopy(servlets, servlets.getItemById(rootAttachmentsId), nodeItem.getName());
                        if (this.type.equals((Object)WorkspaceMessageType.SENT)) {
                            workspace.copyRemoteContent(servlets, newNode, null);
                            servlets.saveItem(newNode);
                            logger.info("add new id to copyAttachmentIds " + newNode.getId());
                            this.copyAttachmentIds.add(newNode.getId());
                        } else if (this.type.equals((Object)WorkspaceMessageType.RECEIVED)) {
                            servlets.getItemById(rootAttachmentsId);
                            String hardLinkRemotePath = String.valueOf(messageItem.getPath()) + "/" + nodeItem.getName();
                            workspace.setHardLink(newNode, hardLinkRemotePath);
                        }
                        workspace.fireItemSentEvent(item, users);
                    }
                    catch (ItemAlreadyExistException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (WrongDestinationException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (RepositoryException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (ItemNotFoundException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            }
            catch (ItemNotFoundException | RepositoryException e) {
                throw new InternalErrorException(e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public String getId() {
        return this.messageItem.getName();
    }

    public User getSender() {
        return new JCRUser(this.messageItem.getOwner(), this.messageItem.getOwner());
    }

    public Calendar getSendTime() {
        return this.messageItem.getCreationTime();
    }

    public String getSubject() {
        return (String)this.messageItem.getProperties().get(NodeProperty.SUBJECT);
    }

    public String getBody() {
        return (String)this.messageItem.getProperties().get(NodeProperty.BODY);
    }

    public List<String> getAttachmentsIds() {
        return (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
    }

    public List<String> getCopyAttachmentsIds() {
        return this.copyAttachmentIds;
    }

    public boolean isRead() {
        return (Boolean)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.READ));
    }

    public void open() throws InternalErrorException {
        this.isOpened = true;
        JCRServlets servlets = null;
        ItemDelegate root = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                switch (this.type) {
                    case RECEIVED: {
                        root = this.workspace.getRepository().getOwnInBoxFolder();
                        break;
                    }
                    case SENT: {
                        root = this.workspace.getRepository().getOutBoxFolder();
                    }
                }
                DelegateManager manager = new DelegateManager(root, this.workspace.getOwner().getPortalLogin());
                ItemDelegate node = manager.getNode(this.getId());
                node.getProperties().put(NodeProperty.OPEN, new XStream().toXML((Object)true));
                servlets.saveItem(node);
            }
            catch (javax.jcr.RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                e.printStackTrace();
                if (servlets != null) {
                    servlets.releaseSession();
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                if (servlets != null) {
                    servlets.releaseSession();
                }
            }
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public void setStatus(boolean status) throws InternalErrorException {
        this.isRead = status;
        JCRServlets servlets = null;
        ItemDelegate root = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                switch (this.type) {
                    case RECEIVED: {
                        root = this.workspace.getRepository().getOwnInBoxFolder();
                        break;
                    }
                    case SENT: {
                        root = this.workspace.getRepository().getOutBoxFolder();
                    }
                }
                DelegateManager manager = new DelegateManager(root, this.workspace.getOwner().getPortalLogin());
                ItemDelegate node = manager.getNode(this.getId());
                node.getProperties().put(NodeProperty.READ, new XStream().toXML((Object)status));
                servlets.saveItem(node);
            }
            catch (javax.jcr.RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                e.printStackTrace();
                if (servlets != null) {
                    servlets.releaseSession();
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                if (servlets != null) {
                    servlets.releaseSession();
                }
            }
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public void saveAttachments(String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        JCRServlets servlets = null;
        try {
            try {
                WorkspaceFolder folder;
                ItemDelegate folderNode;
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                try {
                    folderNode = servlets.getItemById(destinationFolderId);
                    folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
                }
                catch (Exception e) {
                    throw new WrongDestinationException(e.getMessage());
                }
                List attachs = (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
                for (String attachmentId : attachs) {
                    this.saveAttachment(attachmentId, folder, folderNode);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public WorkspaceItem saveAttachment(String attachmentId, String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        WorkspaceFolder folder;
        ItemDelegate folderNode;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                folderNode = servlets.getItemById(destinationFolderId);
                folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
            }
            catch (Exception e) {
                throw new WrongDestinationException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return this.saveAttachment(attachmentId, folder, folderNode);
    }

    private WorkspaceItem saveAttachment(String attachmentId, WorkspaceFolder folder, ItemDelegate folderNode) throws ItemNotFoundException, WrongDestinationException, InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate attachment = servlets.getItemById(attachmentId);
            String name = folder.getUniqueName(attachment.getTitle(), false);
            String pathDestination = String.valueOf(folderNode.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)name);
            try {
                servlets.copy(attachment.getPath(), pathDestination);
            }
            catch (HttpException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ItemDelegate itemSaved = servlets.getItemByPath(pathDestination);
            itemSaved.setOwner(this.workspace.getOwner().getPortalLogin());
            itemSaved.setTitle(name);
            this.workspace.copyRemoteContent(servlets, itemSaved, folderNode);
            servlets.saveItem(itemSaved);
            WorkspaceItem workspaceItem = this.workspace.getItem(itemSaved.getId());
            return workspaceItem;
        }
        catch (RepositoryException | RemoteBackendException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<WorkspaceItem> getAttachments() throws InternalErrorException {
        LinkedList<WorkspaceItem> list = new LinkedList<WorkspaceItem>();
        try {
            List attachs = (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
            for (String id : attachs) {
                list.add(this.workspace.getItem(id));
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public List<String> getAddresses() {
        return (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ADDRESSES));
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public static enum WorkspaceMessageType {
        RECEIVED,
        SENT;

    }
}

