/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRRepository {
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_WEBDAV = "/repository/default/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    private static final String GCUBE_FOLDER = "GCube";
    private static final String DOWNLOADS = "Downloads";
    private static final String SMART_FOLDER = "Folders";
    private static final String IN_BOX_FOLDER = "InBox";
    private static final String OUT_BOX_FOLDER = "OutBox";
    private static final String nameResource = "HomeLibraryRepository";
    private static Repository repository;
    private static String portalLogin;
    public static String user;
    public static String pass;
    public static String url;
    private static String webdavUrl;
    public static String serviceName;
    public static String HLversion;
    private static String version;
    private static String minorVersion;
    private static String revisionVersion;
    private static Logger logger;

    static {
        logger = LoggerFactory.getLogger(JCRRepository.class);
    }

    private static synchronized void initializeRepository() throws InternalErrorException {
        if (repository != null) {
            return;
        }
        String callerScope = ScopeProvider.instance.get();
        try {
            try {
                if (callerScope == null) {
                    throw new IllegalArgumentException("scope is null");
                }
                String rootScope = Utils.getRootScope(callerScope);
                logger.debug("scope for repository creation is " + rootScope + " caller scope is " + callerScope);
                ScopeProvider.instance.set(rootScope);
                url = "http://ws-repo-test.d4science.org/home-library-webapp";
                user = "workspacerep.imarine";
                pass = "gcube2010*onan";
                version = "3";
                minorVersion = "1";
                revisionVersion = "1";
                HLversion = String.valueOf(version) + "." + minorVersion + "." + revisionVersion;
                webdavUrl = "https://www.d4science.org/Home";
                serviceName = "home-library";
                if (user == null || pass == null) {
                    throw new InternalErrorException("cannot discover password and username in scope " + callerScope);
                }
                repository = new URLRemoteRepository(String.valueOf(url) + "/rmi");
                logger.debug("user is " + user + " password is null?" + (pass == null) + " and repository is null?" + (repository == null));
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            if (callerScope != null) {
                ScopeProvider.instance.set(callerScope);
            }
        }
    }

    public static String getCredentials() {
        StringBuilder credentials = new StringBuilder();
        credentials.append("adminId=" + user + "&adminPassword=" + pass);
        return credentials.toString();
    }

    public static List<String> getHomeNames() throws RepositoryException {
        ArrayList<String> homes = new ArrayList<String>();
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets();
                ItemDelegate home = session.getItemByPath("/Home");
                List<ItemDelegate> children = session.getChildrenById(home.getId(), false);
                for (ItemDelegate child : children) {
                    if (!child.getPrimaryType().equals("nthl:home")) continue;
                    homes.add(child.getName());
                }
            }
            catch (ItemNotFoundException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            session.releaseSession();
        }
        return homes;
    }

    public static ItemDelegate getHome() throws RepositoryException {
        ItemDelegate home = null;
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets();
                home = session.getItemByPath("/Home");
            }
            catch (ItemNotFoundException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            session.releaseSession();
        }
        return home;
    }

    public static Session getSession(String user) throws InternalErrorException {
        JCRRepository.initializeRepository();
        Repository repository = JCRRepository.repository;
        synchronized (repository) {
            try {
                logger.debug("session of " + user);
                Session session = JCRRepository.repository.login((Credentials)new SimpleCredentials(user, JCRUserManager.getSecurePassword(user).toCharArray()));
                return session;
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public static Session getSession() throws InternalErrorException {
        JCRRepository.initializeRepository();
        Repository repository = JCRRepository.repository;
        synchronized (repository) {
            try {
                Session session = JCRRepository.repository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()));
                return session;
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public static synchronized void initialize() throws InternalErrorException {
        logger.debug("Initialize repository");
        JCRRepository.initializeRepository();
    }

    public JCRRepository(User user) throws InternalErrorException {
        portalLogin = user.getPortalLogin();
        logger.info("getHome " + portalLogin);
        try {
            this.init();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void init() throws Exception {
        block18: {
            JCRUserManager um = new JCRUserManager();
            String userVersion = JCRRepository.getUserVersion(portalLogin, um);
            logger.info(String.valueOf(portalLogin) + " - USER VERSION: " + userVersion + " - HL VERSION: " + HLversion);
            if (!HLversion.equals(userVersion)) {
                JCRServlets servlets = null;
                try {
                    try {
                        servlets = new JCRServlets(portalLogin, false);
                        ItemDelegate home = servlets.getItemByPath("/Home");
                        DelegateManager homeManager = new DelegateManager(home, portalLogin);
                        ItemDelegate userHome = null;
                        try {
                            userHome = homeManager.addNode(portalLogin, "nthl:home");
                            try {
                                homeManager.save(userHome);
                            }
                            catch (Exception e) {
                                logger.error("Impossible to create " + portalLogin);
                                throw new RepositoryException(e.getMessage());
                            }
                            um.createUser(portalLogin, String.valueOf(version));
                        }
                        catch (InternalErrorException e) {
                            userHome = homeManager.getNode(portalLogin);
                        }
                        DelegateManager userHomeManager = new DelegateManager(userHome, portalLogin);
                        try {
                            ItemDelegate smartFolder = userHomeManager.addNode(SMART_FOLDER, "nt:folder");
                            userHomeManager.save(smartFolder);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create Folders");
                        }
                        try {
                            ItemDelegate inBoxDelegate = userHomeManager.addNode(IN_BOX_FOLDER, "nthl:rootItemSentRequest");
                            userHomeManager.save(inBoxDelegate);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create InBox");
                        }
                        try {
                            ItemDelegate outBoxDelegate = userHomeManager.addNode(OUT_BOX_FOLDER, "nthl:rootItemSentRequest");
                            userHomeManager.save(outBoxDelegate);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create OutBox");
                        }
                        try {
                            ItemDelegate downloadFolder = userHomeManager.addNode(DOWNLOADS, "nthl:rootFolderBulkCreator");
                            userHomeManager.save(downloadFolder);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create Downloads");
                        }
                        break block18;
                    }
                    catch (RepositoryException e) {
                        throw new RepositoryException(e.getMessage());
                    }
                }
                finally {
                    servlets.releaseSession();
                }
            }
            logger.info("skip init in JCRRepository");
        }
    }

    public List<String> listScopes() throws RepositoryException, InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        return list;
    }

    public static ItemDelegate getGCubeRoot() throws RepositoryException, InternalErrorException {
        logger.info("getGCubeRoot");
        JCRServlets servlet = null;
        ItemDelegate gcubeRoot = null;
        try {
            try {
                servlet = new JCRServlets();
                try {
                    gcubeRoot = servlet.getItemByPath("/GCube");
                }
                catch (ItemNotFoundException e) {
                    gcubeRoot = JCRRepository.getRootNode().addNode(GCUBE_FOLDER, "nt:folder");
                    servlet.saveItem(gcubeRoot);
                }
            }
            catch (Exception e) {
                logger.error("Error retrieving shared root");
                servlet.releaseSession();
            }
        }
        finally {
            servlet.releaseSession();
        }
        return gcubeRoot;
    }

    public static ItemDelegate getSharedRoot() throws RepositoryException, InternalErrorException {
        logger.info("getSharedRoot");
        JCRServlets servlet = null;
        ItemDelegate sharedNode = null;
        try {
            try {
                servlet = new JCRServlets();
                try {
                    sharedNode = servlet.getItemByPath("/Share");
                }
                catch (Exception e) {
                    sharedNode = JCRRepository.getRootNode().addNode(SHARED_FOLDER, "nt:folder");
                    servlet.saveItem(sharedNode);
                }
            }
            catch (RepositoryException e) {
                logger.error("Error retrieving shared root");
                servlet.releaseSession();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlet.releaseSession();
        }
        return sharedNode;
    }

    private static DelegateManager getRootNode() throws RepositoryException {
        JCRServlets servlet = null;
        ItemDelegate root = null;
        DelegateManager wrap = null;
        try {
            try {
                servlet = new JCRServlets();
                root = servlet.getItemByPath(PATH_SEPARATOR);
                wrap = new DelegateManager(root, "");
            }
            catch (Exception e) {
                logger.error("Error retrieving Root Node " + e);
                servlet.releaseSession();
            }
        }
        finally {
            servlet.releaseSession();
        }
        return wrap;
    }

    public ItemDelegate getUserHome() throws RepositoryException, ItemNotFoundException {
        logger.info("getUserHome: /Home/" + portalLogin);
        ItemDelegate userHomeDelegate = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(portalLogin, false);
                userHomeDelegate = servlets.getItemByPath("/Home/" + portalLogin);
            }
            catch (RepositoryException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return userHomeDelegate;
    }

    public ItemDelegate getRootSmartFolders() throws RepositoryException {
        ItemDelegate smartFolders = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(portalLogin, true);
                logger.info("getRootSmartFolders: /Home/" + portalLogin + PATH_SEPARATOR + SMART_FOLDER);
                try {
                    smartFolders = servlets.getItemByPath("/Home/" + portalLogin + PATH_SEPARATOR + SMART_FOLDER);
                }
                catch (ItemNotFoundException e) {
                    smartFolders = this.getUserHome(portalLogin).addNode(SMART_FOLDER, "nt:folder");
                    servlets.saveItem(smartFolders);
                }
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return smartFolders;
    }

    private DelegateManager getUserHome(String user) throws InternalErrorException, RepositoryException {
        DelegateManager wrap = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(portalLogin, false);
                ItemDelegate item = servlets.getItemByPath("/Home/" + portalLogin);
                wrap = new DelegateManager(item, portalLogin);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return wrap;
    }

    public ItemDelegate getOwnInBoxFolder() throws javax.jcr.RepositoryException {
        ItemDelegate inBoxNode = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(portalLogin, false);
                try {
                    inBoxNode = servlets.getItemByPath("/Home/" + portalLogin + PATH_SEPARATOR + IN_BOX_FOLDER);
                }
                catch (ItemNotFoundException e) {
                    inBoxNode = this.getUserHome(portalLogin).addNode(IN_BOX_FOLDER, "nthl:rootItemSentRequest");
                    servlets.saveItem(inBoxNode);
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return inBoxNode;
    }

    public ItemDelegate getOutBoxFolder() throws javax.jcr.RepositoryException {
        ItemDelegate outBoxNode = null;
        JCRServlets servlets = null;
        logger.info("getOutBoxFolder: /Home/" + portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
        try {
            try {
                servlets = new JCRServlets(portalLogin, false);
                try {
                    outBoxNode = servlets.getItemByPath("/Home/" + portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
                }
                catch (ItemNotFoundException e) {
                    outBoxNode = this.getUserHome(portalLogin).addNode(OUT_BOX_FOLDER, "nthl:rootItemSentRequest");
                    servlets.saveItem(outBoxNode);
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return outBoxNode;
    }

    public Node getRootFolderBulkCreators(Session session) throws javax.jcr.RepositoryException {
        Node downloads = null;
        logger.info("Get Download Folder: /Home/" + portalLogin + PATH_SEPARATOR + DOWNLOADS);
        if (downloads == null) {
            try {
                try {
                    downloads = session.getNode("/Home/" + portalLogin + PATH_SEPARATOR + DOWNLOADS);
                }
                catch (PathNotFoundException e) {
                    downloads = session.getNode("/Home/" + portalLogin).addNode(DOWNLOADS, "nthl:rootFolderBulkCreator");
                    session.save();
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        return downloads;
    }

    public ItemDelegate getInBoxFolder(String user) throws javax.jcr.RepositoryException, InternalErrorException {
        JCRServlets servlets = null;
        ItemDelegate inBoxFolder = null;
        try {
            try {
                servlets = new JCRServlets(portalLogin, false);
                inBoxFolder = servlets.getItemByPath("/Home/" + user + PATH_SEPARATOR + IN_BOX_FOLDER);
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return inBoxFolder;
    }

    public String getUserHomeUrl(String portalLogin) {
        return String.valueOf(url) + ROOT_WEBDAV + HOME_FOLDER + PATH_SEPARATOR + portalLogin;
    }

    public String getWebDavUrl(String portalLogin) {
        return String.valueOf(webdavUrl) + PATH_SEPARATOR + portalLogin;
    }

    public static String getUserVersion(String portalLogin, JCRUserManager um) throws InternalErrorException {
        if (um == null) {
            um = new JCRUserManager();
        }
        String userVersion = um.getVersionByUser(portalLogin);
        return userVersion;
    }
}

