/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.Util;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRExternalUrl
extends JCRWorkspaceFolderItem
implements ExternalUrl {
    protected final JCRFile content;

    public JCRExternalUrl(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException, InternalErrorException {
        super(workspace, itemDelegate);
        this.content = new JCRFile(workspace, itemDelegate);
    }

    public JCRExternalUrl(JCRWorkspace workspace, ItemDelegate itemDelegate, String name, String description, String url) throws RepositoryException, RemoteBackendException, InternalErrorException, IOException {
        super(workspace, itemDelegate, name, description);
        Validate.notNull((Object)url, (String)"url must be not null");
        this.delegate.setContent(new HashMap());
        this.delegate.getContent().put(NodeProperty.CONTENT, ContentType.GENERAL.toString());
        this.content = new JCRFile(workspace, this.delegate, new ByteArrayInputStream(url.getBytes()));
        this.delegate.setProperties(new HashMap());
        this.delegate.getProperties().put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_URL.toString());
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.content.getLength();
    }

    public String getUrl() throws InternalErrorException {
        try {
            return Util.readStreamAsString((InputStream)this.content.getData());
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_URL;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }
}

