/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceVREFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRWorkspaceVREFolder
extends JCRWorkspaceSharedFolder
implements WorkspaceVREFolder {
    private JCRUserManager um;

    public JCRWorkspaceVREFolder(JCRWorkspace workspace, ItemDelegate node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
    }

    public JCRWorkspaceVREFolder(JCRWorkspace workspace, ItemDelegate delegate, String VREname, String description, String groupID, String displayName, String scope) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        super(workspace, delegate, VREname, description, workspace.getMySpecialFolders().getId(), Arrays.asList(groupID, VREname + "-Manager"), null, null);
        Map properties = delegate.getProperties();
        properties.put(NodeProperty.IS_VRE_FOLDER, new XStream().toXML((Object)true));
        properties.put(NodeProperty.DISPLAY_NAME, displayName);
        properties.put(NodeProperty.GROUP_ID, groupID);
        properties.put(NodeProperty.SCOPE, new XStream().toXML((Object)scope));
        this.save();
        this.share();
    }

    @Override
    public String getDisplayName() {
        return (String)this.delegate.getProperties().get(NodeProperty.DISPLAY_NAME);
    }

    public GCubeGroup getGroup() throws InternalErrorException {
        if (this.delegate.getProperties().get(NodeProperty.GROUP_ID) != null) {
            String groupId = (String)this.delegate.getProperties().get(NodeProperty.GROUP_ID);
            if (this.um == null) {
                this.um = (JCRUserManager)HomeLibrary.getHomeManagerFactory().getUserManager();
            }
            return this.um.getGroup(groupId);
        }
        logger.error("Group ID not found in " + this.delegate.getPath());
        return null;
    }

    public String getScope() throws InternalErrorException {
        if (this.delegate.getProperties().get(NodeProperty.SCOPE) != null) {
            return (String)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.SCOPE));
        }
        logger.error("Scope not found in " + this.delegate.getPath());
        return null;
    }

    public void changeOwner(String user) throws InternalErrorException, RepositoryException {
        this.delegate.setOwner(user);
        this.save();
    }

    public void addUserToVRE(String user) throws InternalErrorException {
        if (this.um == null) {
            this.um = (JCRUserManager)HomeLibrary.getHomeManagerFactory().getUserManager();
        }
        try {
            this.um.associateUserToGroup(this.getScope(), user);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addUser(String userToAdd) throws InsufficientPrivilegesException, InternalErrorException {
        block10: {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            UserManager gm = factory.getUserManager();
            GCubeGroup group = this.getGroup();
            String manager = this.getManager(group.getName());
            try {
                if (gm.createUser(userToAdd, null)) {
                    logger.trace(userToAdd + " has been created");
                }
                if (group != null) {
                    group.addMember(userToAdd);
                }
                Workspace ws = null;
                try {
                    ws = factory.getHomeManager().getHome(manager).getWorkspace();
                }
                catch (WorkspaceFolderNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (HomeNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (UserNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                if (ws == null) break block10;
                JCRWorkspaceSharedFolder folder = (JCRWorkspaceSharedFolder)ws.getItemByPath(this.workspace.getMySpecialFolders().getPath() + "/" + this.getName());
                logger.trace("VRE folder path: " + folder.getPath());
                ArrayList<String> userList = new ArrayList<String>();
                super.addUser(userToAdd);
                try {
                    folder.share(userList);
                }
                catch (InsufficientPrivilegesException | WrongDestinationException e) {
                    throw new InternalErrorException(e);
                }
            }
            catch (InternalErrorException | ItemNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getManager(String groupId) {
        String manager = groupId + "-Manager";
        return manager;
    }

    public void removeUserFromVRE(String user) throws InternalErrorException {
        if (this.um == null) {
            this.um = (JCRUserManager)HomeLibrary.getHomeManagerFactory().getUserManager();
        }
        try {
            this.um.removeUserFromGroup(this.getScope(), user);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isVreFolder() {
        return true;
    }

    public void setDisplayName(String displayName) throws InternalErrorException, RepositoryException {
        this.delegate.getProperties().put(NodeProperty.DISPLAY_NAME, displayName);
        this.save();
    }
}

