package org.gcube.common.homelibrary.jcr.workspace.versioning;

import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibary.model.servlet.ServletParameter;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.ServletName;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.thoughtworks.xstream.XStream;

public class JCRVersioning {

	private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);

	Map<String, Endpoint> servlets;

	public JCRVersioning(){
		super();
		this.servlets = JCRRepository.servlets;
	}


	@SuppressWarnings("unchecked")
	public List<String> getVersioning(String id) throws InternalErrorException {

		List<String> list = null;
		GetMethod getMethod = null;
		try {
			HttpClient httpClient = new HttpClient();            

			//			logger.info(url);
			getMethod =  new GetMethod(servlets.get(ServletName.VERSION_HISTORY).uri().toString() + "?" + ServletParameter.ID + "=" + id );
			
			TokenUtility.setHeader(getMethod);
			httpClient.executeMethod(getMethod);

			logger.trace("Callin List Version History Servlet");
			XStream xstream = new XStream();
			list = (List<String>) xstream.fromXML(getMethod.getResponseBodyAsString());

		} catch (Exception e) {
			logger.error("Error retrieving versioning for node " + id, e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}

		return list;
	}
	
	

	public void saveCurrentVersion(String id, String remotePath) throws InternalErrorException {
		logger.trace("Callin Update Version Servlet");

		GetMethod getMethod = null;
		try {
			HttpClient httpClient = new HttpClient();            


			getMethod =  new GetMethod(servlets.get(ServletName.SAVE_CURRENT_VERSION).uri().toString() + "?" + ServletParameter.ID + "=" + id + "&" + ServletParameter.REMOTE_PATH + "=" + remotePath );
			
			TokenUtility.setHeader(getMethod);
			int response =  httpClient.executeMethod(getMethod);

			// Check response code
			if (response != HttpStatus.SC_OK)
				throw new HttpException("Received error status " + response);
			

		} catch (Exception e) {
			logger.error("Error retrieving versioning for node " + id, e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}

	}
	
	

	public void restoreVersion(String id, String remotePath, String version) throws InternalErrorException {
		logger.trace("Callin List Version History Servlet");

		GetMethod getMethod = null;
		try {
			HttpClient httpClient = new HttpClient();            

			getMethod =  new GetMethod(servlets.get(ServletName.RESTORE_VERSION).uri().toString() + "?" + ServletParameter.ID + "=" + id + "&" +  ServletParameter.REMOTE_PATH + "=" + remotePath + "&" + ServletParameter.VERSION + "=" + version );
			
			TokenUtility.setHeader(getMethod);
			int response =  httpClient.executeMethod(getMethod);

			// Check response code
			if (response != HttpStatus.SC_OK)
				throw new HttpException("Received error status " + response);


		} catch (Exception e) {
			logger.error("Error retrieving versioning for node " + id, e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}

	}

}
