/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.model.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.model.exceptions.ItemNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRLockManager {
    private String urlRepository;
    private Logger logger = LoggerFactory.getLogger(JCRLockManager.class);
    private String login;
    private String sessionId;
    private String credential;

    public JCRLockManager(String login, String sessionId, String repository, String credential) {
        this.urlRepository = repository;
        this.credential = credential;
        this.login = login;
        this.sessionId = sessionId;
    }

    public void lockItem(String id) throws ItemNotFoundException {
        this.logger.info("Calling Servlet Lock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.urlRepository + "/rest/LockSession?" + this.credential + "&login=" + this.login + "&id=" + id + "&uuid=" + this.sessionId);
            httpClient.executeMethod((HttpMethod)getMethod);
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public void unlockItem(String id) throws ItemNotFoundException {
        this.logger.info("Calling Servlet Lock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.urlRepository + "/rest/UnlockSession?" + this.credential + "&login=" + this.login + "&id=" + id + "&uuid=" + this.sessionId);
            httpClient.executeMethod((HttpMethod)getMethod);
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public boolean isLocked(String id) throws ItemNotFoundException {
        this.logger.info("Calling Servlet Lock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.urlRepository + "/rest/IsLocked?" + this.credential + "&login=" + this.login + "&id=" + id);
            httpClient.executeMethod((HttpMethod)getMethod);
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return false;
    }
}

