/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.unittest.workspace.test;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.common.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestSharedFolders
extends AbstractWorkspaceTest {
    public WorkspaceTestSharedFolders(WorkspaceFactory factory) {
        super(factory);
    }

    private void checkContentSharedFolder(String sharedFolderId, int itemsSize, boolean hasDifferentName) throws Exception {
        WorkspaceSharedFolder folder = (WorkspaceSharedFolder)this.ownerWorkspace.getItem(sharedFolderId);
        List items = folder.getChildren();
        Assert.assertEquals((long)items.size(), (long)itemsSize);
        for (Workspace workspace : this.userWorkspaces.values()) {
            WorkspaceSharedFolder sharedFodler = (WorkspaceSharedFolder)workspace.getItem(sharedFolderId);
            List sharedItems = sharedFodler.getChildren();
            Assert.assertEquals((long)sharedItems.size(), (long)itemsSize);
            for (WorkspaceItem ownerItem : items) {
                Assert.assertTrue((boolean)ownerItem.isShared());
                boolean found = false;
                for (WorkspaceItem item : sharedItems) {
                    if (!ownerItem.getId().equals(item.getId())) continue;
                    Assert.assertTrue((boolean)item.isShared());
                    found = true;
                    if (hasDifferentName) {
                        Assert.assertFalse((boolean)ownerItem.getPath().equals(item.getPath()));
                        break;
                    }
                    Assert.assertTrue((boolean)ownerItem.getPath().equals(item.getPath()));
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
        }
    }

    private final WorkspaceSharedFolder createSharedFolder(String name, String destinationFolderId) throws InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, InternalErrorException {
        String description = "DescriptionSharedFolder";
        ArrayList<String> users = new ArrayList<String>();
        for (Workspace testWorkspace : this.userWorkspaces.values()) {
            users.add(testWorkspace.getOwner().getPortalLogin());
        }
        return this.ownerWorkspace.createSharedFolder(name, description, users, destinationFolderId);
    }

    private final void fillFolder(WorkspaceFolder folder, int size) throws Exception {
        TestDataFactory.getInstance().fillExternalFiles(folder, size);
    }

    private final void markItemsAsRead(String sharedFolderId, boolean marked) throws Exception {
        WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)this.ownerWorkspace.getItem(sharedFolderId);
        for (WorkspaceItem item : sharedFolder.getChildren()) {
            item.markAsRead(marked);
        }
        for (Workspace workspace : this.userWorkspaces.values()) {
            WorkspaceSharedFolder userSharedFolder = (WorkspaceSharedFolder)workspace.getItem(sharedFolderId);
            for (WorkspaceItem item : userSharedFolder.getChildren()) {
                item.markAsRead(marked);
            }
        }
    }

    private final void checkItemsIsMarkAsRead(String sharedFolderId, boolean marked) throws Exception {
        WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)this.ownerWorkspace.getItem(sharedFolderId);
        for (WorkspaceItem item : sharedFolder.getChildren()) {
            Assert.assertTrue((boolean)item.isMarkedAsRead());
        }
        for (Workspace workspace : this.userWorkspaces.values()) {
            sharedFolder = (WorkspaceSharedFolder)workspace.getItem(sharedFolderId);
            for (WorkspaceItem item : sharedFolder.getChildren()) {
                if (marked) {
                    Assert.assertTrue((boolean)item.isMarkedAsRead());
                    continue;
                }
                Assert.assertFalse((boolean)item.isMarkedAsRead());
            }
        }
    }

    private final void checkCopySharedFodler(WorkspaceItem folder, WorkspaceItem folderCopy) throws InternalErrorException {
        for (WorkspaceItem item : folder.getChildren()) {
            boolean found = false;
            for (WorkspaceItem itemCopy : folderCopy.getChildren()) {
                if (!item.getName().equals(itemCopy.getName())) continue;
                found = true;
                Assert.assertFalse((boolean)item.getId().equals(itemCopy.getId()));
                Assert.assertFalse((boolean)itemCopy.isShared());
                this.checkCopySharedFodler(item, itemCopy);
            }
            Assert.assertTrue((boolean)found);
        }
    }

    @Test
    public final void createSharedFolderWithItems() throws Exception {
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder("SharedFolder", this.ownerWorkspace.getRoot().getId());
        int itemSize = 2;
        this.fillFolder((WorkspaceFolder)sharedFolder, itemSize);
        this.checkContentSharedFolder(sharedFolder.getId(), itemSize, false);
    }

    @Test
    public final void createSharedFolderWithItemsAndExistingNameInUsersRoot() throws Exception {
        String name = "FakeSharedFolder";
        for (Workspace workspace : this.userWorkspaces.values()) {
            workspace.getRoot().createFolder(name, "");
        }
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(name, this.ownerWorkspace.getRoot().getId());
        int itemSize = 2;
        this.fillFolder((WorkspaceFolder)sharedFolder, itemSize);
        this.checkContentSharedFolder(sharedFolder.getId(), itemSize, true);
    }

    @Test(expected=WrongDestinationException.class)
    public final void createSharedFolderOnDestinationFolderAlreadyShared() throws Exception {
        String sharedFolderName1 = "SharedFolder1";
        WorkspaceSharedFolder sharedFolder1 = this.createSharedFolder(sharedFolderName1, this.ownerWorkspace.getRoot().getId());
        String sharedFolderName2 = "SharedFolder2";
        this.createSharedFolder(sharedFolderName2, sharedFolder1.getId());
    }

    @Test
    public final void shareFolder() throws Exception {
        String folderName = "NormalFolder";
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(folderName, "");
        this.fillFolder(folder, 10);
        ArrayList<String> users = new ArrayList<String>();
        for (String user : this.userWorkspaces.keySet()) {
            users.add(user);
        }
        this.ownerWorkspace.shareFolder(users, folder.getId());
    }

    @Test(expected=WrongDestinationException.class)
    public final void shareFolderWithAncestorsAlreadyShared() throws Exception {
        String sharedFolderName = "SharedFolder";
        String childSharedFolderName = "ChildFolder";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(sharedFolderName, this.ownerWorkspace.getRoot().getId());
        this.fillFolder((WorkspaceFolder)sharedFolder, 10);
        WorkspaceFolder folder = sharedFolder.createFolder(childSharedFolderName, "");
        ArrayList<String> users = new ArrayList<String>();
        for (String user : this.userWorkspaces.keySet()) {
            users.add(user);
        }
        this.ownerWorkspace.shareFolder(users, folder.getId());
    }

    @Test(expected=WrongDestinationException.class)
    public final void shareFolderWithDiscendentsAlreadyShared() throws Exception {
        String sharedFolderName = "SharedFolder";
        String childSharedFolderName = "ChildFolder";
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(childSharedFolderName, "");
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(sharedFolderName, folder.getId());
        this.fillFolder((WorkspaceFolder)sharedFolder, 10);
        ArrayList<String> users = new ArrayList<String>();
        for (String user : this.userWorkspaces.keySet()) {
            users.add(user);
        }
        this.ownerWorkspace.shareFolder(users, folder.getId());
    }
}

