/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.testdata.AbstractDataManager;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.testdata.data.TimeSeriesData;
import org.gcube.common.homelibrary.util.WorkspaceUtil;

public class TimeSeriesDataManager
extends AbstractDataManager<TimeSeriesData, TimeSeries> {
    public TimeSeriesDataManager() {
        super("timeseries.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("ts", TimeSeriesData.class);
        this.xstream.alias("timeseries", LinkedList.class);
    }

    protected static InputStream getTestDataStream(TimeSeriesData testData) {
        String testDataPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + testData.getCompressedCSV();
        return TestDataFactory.class.getResourceAsStream(testDataPath);
    }

    @Override
    protected TimeSeries fillData(WorkspaceFolder destinationFolder, TimeSeriesData testData) throws InternalErrorException {
        InputStream tsStream = TimeSeriesDataManager.getTestDataStream(testData);
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return destinationFolder.createTimeSeries(name, testData.getDescription(), testData.getTimeseriesId(), testData.getTitle(), testData.getCreator(), testData.getTimeseriesDescription(), testData.getTimeseriesCreationDate(), testData.getPublisher(), testData.getSourceId(), testData.getSourceName(), testData.getRights(), testData.getDimension(), testData.getHeaderLabels(), tsStream);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error("Error creating the ts", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error("Error creating the ts", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

