/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeUtil {
    protected static final Logger logger = LoggerFactory.getLogger(MimeTypeUtil.class);
    public static final String BINARY_MIMETYPE = "application/octet-stream";
    public static final String[] ZIP_MIMETYPES = new String[]{"application/x-compress", "application/x-compressed", "application/x-gzip", "application/x-winzip", "application/x-zip", "application/zip", "multipart/x-zip"};
    protected static final Map<String, String> mimetype_extension_map = new LinkedHashMap<String, String>();
    protected static final Map<String, String> extension_mimetype_map = new LinkedHashMap<String, String>();

    protected static void loadExtensions(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            String[] split = line.split("=");
            if (split.length == 2) {
                String mimeType = split[0];
                String extension = split[1];
                extension_mimetype_map.put(extension, mimeType);
            }
            line = br.readLine();
        }
        br.close();
    }

    protected static void loadMimeTypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            String[] split = line.split("=");
            if (split.length == 2) {
                String mimeType = split[0];
                String extension = split[1];
                mimetype_extension_map.put(mimeType, extension);
            }
            line = br.readLine();
        }
        br.close();
    }

    public static String getExtension(String mimeType) {
        return mimetype_extension_map.get(mimeType);
    }

    public static String getMimeType(String filenameWithExtension, InputStream file) {
        TikaConfig config = TikaConfig.getDefaultConfig();
        Detector detector = config.getDetector();
        TikaInputStream stream = TikaInputStream.get((InputStream)file);
        Metadata metadata = new Metadata();
        metadata.add("resourceName", filenameWithExtension);
        MediaType mediaType = null;
        try {
            mediaType = detector.detect((InputStream)stream, metadata);
        }
        catch (IOException e) {
            logger.error("Error detecting mime type for file " + filenameWithExtension);
        }
        return mediaType.getBaseType().toString();
    }

    public static void main(String[] args) throws IOException {
    }

    public static String getNameWithExtension(String name, String mimeType) throws IOException {
        logger.trace("getNameWithExtension name: " + name + " mimeType: " + mimeType);
        if (mimeType == null) {
            return name;
        }
        String extension = MimeTypeUtil.getExtension(mimeType);
        logger.trace("extension: " + extension);
        extension = extension == null ? "" : "." + extension;
        if (name.toLowerCase().endsWith(extension.toLowerCase())) {
            logger.trace("extension already exist in name, returning name");
            return name;
        }
        logger.trace("returning " + name + extension);
        return name + extension;
    }

    public static boolean isZipContentType(String contentType) {
        for (String zip_mimetype : ZIP_MIMETYPES) {
            if (!zip_mimetype.equals(contentType)) continue;
            return true;
        }
        return false;
    }

    static {
        InputStream extensionToMimetype = MimeTypeUtil.class.getResourceAsStream("/ExtensionToMimeTypeMap.properties");
        InputStream mimetypeToExtension = MimeTypeUtil.class.getResourceAsStream("/MimeTypeToExtensionMap.properties");
        try {
            MimeTypeUtil.loadExtensions(extensionToMimetype);
            MimeTypeUtil.loadMimeTypes(mimetypeToExtension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

