/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.unittest.workspace.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.common.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.common.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestCreateExternalMethods
extends AbstractWorkspaceTest {
    public WorkspaceTestCreateExternalMethods(WorkspaceFactory factory) {
        super(factory);
    }

    @Test
    public final void testCreateExternalFile() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder60", "A test folder");
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        ExternalFile externalFile = this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
        UnitTestUtil.testItemCreation((WorkspaceItem)externalFile, (WorkspaceItem)folder, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalFile.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_FILE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalFile.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalFile.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateExternalFileDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder61", "A test folder");
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder62", "A test folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "ExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileNullDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder63", "A test folder");
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, null, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder64", "A test folder");
        String expectedName = "TestExternalFile";
        String expectedDescription = null;
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileNullDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder65", "A test folder");
        String expectedName = null;
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateExternalFileWrongDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreateExternalFileWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder66", "A test folder");
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        ExternalFile testItem = this.ownerWorkspace.createExternalFile("TestItem", "A test Item", "testMimeType", (InputStream)new FileInputStream(fileData), folder.getId());
        this.ownerWorkspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), testItem.getId());
    }

    @Test
    public final void testCreateExternalImage() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder67", "A test folder");
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ExternalImage externalImage = this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
        UnitTestUtil.testItemCreation((WorkspaceItem)externalImage, (WorkspaceItem)folder, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalImage.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_IMAGE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalImage.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalImage.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateExternalImageDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder68", "A test folder");
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder69", "A test folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "ExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageNullDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder70", "A test folder");
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, null, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder71", "A test folder");
        String expectedName = "TestExternalImage";
        String expectedDescription = null;
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageNullDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder72", "A test folder");
        String expectedName = null;
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateExternalImageWrongDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreateExternalImageWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder73", "A test folder");
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ExternalImage testItem = this.ownerWorkspace.createExternalImage("TestItem", "A test Item", "testMimeType", (InputStream)new FileInputStream(fileData), folder.getId());
        this.ownerWorkspace.createExternalImage(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), testItem.getId());
    }

    @Test
    public final void testCreateExternalPDFFile() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder74", "A test folder");
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        ExternalPDFFile externalPDFFile = this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
        UnitTestUtil.testItemCreation((WorkspaceItem)externalPDFFile, (WorkspaceItem)folder, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalPDFFile.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_PDF_FILE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalPDFFile.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalPDFFile.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateExternalPDFFileDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder75", "A test folder");
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder76", "A test folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "ExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileNullDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder77", "A test folder");
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, null, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder78", "A test folder");
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = null;
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileNullDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder80", "A test folder");
        String expectedName = null;
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), folder.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateExternalPDFFileWrongDestinationIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreateExternalPDFFileWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder81", "A test folder");
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        ExternalPDFFile testItem = this.ownerWorkspace.createExternalPDFFile("TestItem", "A test Item", "testMimeType", (InputStream)new FileInputStream(fileData), folder.getId());
        this.ownerWorkspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), testItem.getId());
    }
}

