/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.unittest.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.common.homelibrary.unittest.workspace.WorkspaceItemTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class FolderTest
extends WorkspaceItemTest {
    protected WorkspaceFolder folder;

    @Before
    public abstract void setUpFolder() throws Exception;

    @After
    public abstract void tearDownFolder() throws Exception;

    @Test
    public final void testGetType() {
        WorkspaceItemType type = this.folder.getType();
        Assert.assertEquals((String)"Wrong type", (Object)WorkspaceItemType.FOLDER, (Object)type);
    }

    @Test
    public final void testCreateExternalFileItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        ExternalFile externalFile = this.folder.createExternalFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
        UnitTestUtil.testItemCreation((WorkspaceItem)externalFile, (WorkspaceItem)this.folder, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalFile.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_FILE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalFile.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalFile.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileItemNullNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.folder.createExternalFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileItemNullDescriptionArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalFile";
        String expectedDescription = null;
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.folder.createExternalFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileItemNullDataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalFileItemIllegalCharInNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "Test/ExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.folder.createExternalFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateExternalFileItemDuplicateItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        this.folder.createExternalFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
        this.folder.createExternalFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test
    public final void testCreateExternalPDFFileItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        ExternalPDFFile externalPDFFile = this.folder.createExternalPDFFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
        UnitTestUtil.testItemCreation((WorkspaceItem)externalPDFFile, (WorkspaceItem)this.folder, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalPDFFile.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_PDF_FILE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalPDFFile.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalPDFFile.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileItemNullNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createExternalPDFFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileItemNullDescriptionArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = null;
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createExternalPDFFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileItemNullDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalPDFFileItemIllegalCharInNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "Test/ExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createExternalPDFFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateExternalPDFFileItemDuplicateItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createExternalPDFFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
        this.folder.createExternalPDFFileItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test
    public final void testCreateExternalImageItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ExternalImage externalImage = this.folder.createExternalImageItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
        UnitTestUtil.testItemCreation((WorkspaceItem)externalImage, (WorkspaceItem)this.folder, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalImage.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_IMAGE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalImage.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalImage.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageItemNullNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createExternalImageItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageItemNullDescriptionArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalImage";
        String expectedDescription = null;
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createExternalImageItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageItemNullDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateExternalImageItemIllegalCharInNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "Test/ExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createExternalImageItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateExternalImageItemDuplicateItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestExternalImage";
        String expectedDescription = "Test external image description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createExternalImageItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
        this.folder.createExternalImageItem(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData));
    }

    @Test
    @Ignore
    public final void testCreateAnnotationItem() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testCreateDocumentItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        Document document = this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
        UnitTestUtil.testDocumentCreation(document, (WorkspaceItem)this.folder, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = document.getFolderItemType();
        Assert.assertEquals((String)"Wrong info object type", (Object)FolderItemType.DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)document.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)document.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullDescriptionArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = null;
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullOidArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = null;
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullCollectionNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = null;
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullMetadataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        Map expectedMetadata = null;
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullAnnotationsArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        Map expectedAnnotation = null;
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentItemNullDataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, null, expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateDocumentItemDuplicateItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
        this.folder.createDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test
    public final void testCreateImageDocumentItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ImageDocument imageDocument = this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
        UnitTestUtil.testDocumentCreation((Document)imageDocument, (WorkspaceItem)this.folder, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = imageDocument.getFolderItemType();
        Assert.assertEquals((String)"Wrong info object type", (Object)FolderItemType.IMAGE_DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)imageDocument.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)imageDocument.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullDescription() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = null;
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullOidArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = null;
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullCollectionNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = null;
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullMetadataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        Map expectedMetadata = null;
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullAnnotationsArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        Map expectedAnnotation = null;
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentItemNullDataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, null, expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateImageDocumentItemDuplicateItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
        this.folder.createImageDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test
    @Ignore
    public final void testCreateMetadataItem() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testCreatePDFDocumentItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        PDFDocument pdfDocument = this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
        UnitTestUtil.testDocumentCreation((Document)pdfDocument, (WorkspaceItem)this.folder, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = pdfDocument.getFolderItemType();
        Assert.assertEquals((String)"Wrong info object type", (Object)FolderItemType.PDF_DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)pdfDocument.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)pdfDocument.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullDescriptionArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = null;
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullOidArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = null;
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullCollectionNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = null;
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullMetadataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        Map expectedMetadata = null;
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullAnnotationsArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        Map expectedAnnotation = null;
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemNullDataArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, null, expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentItemIllegalCharInNameArgument() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "Test/PDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreatePDFDocumentItemDuplicateItem() throws IOException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
        this.folder.createPDFDocumentItem(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName);
    }

    @Test
    @Ignore
    public final void testCreateQueryItem() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testCreateDocumentLinkItem() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testCreateImageDocumentLinkItem() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testCreatePDFDocumentLinkItem() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testMove() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public final void testRemoveChild() {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    @Ignore
    public final void testRename() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testCreateFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestFolder";
        String expectedDescription = "TestDescription";
        this.folder.createFolder(expectedName, expectedDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateFolderNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        String expectedDescription = "TestDescription";
        this.folder.createFolder(expectedName, expectedDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateFolderNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestFolder";
        String expectedDescription = null;
        this.folder.createFolder(expectedName, expectedDescription);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateFolderIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "Test/Folder";
        String expectedDescription = "TestDescription";
        this.folder.createFolder(expectedName, expectedDescription);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateFolderDuplicateFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "TestFolder";
        String expectedDescription = "TestDescription";
        this.folder.createFolder(expectedName, expectedDescription);
        this.folder.createFolder(expectedName, expectedDescription);
    }

    @Test
    @Ignore
    public void testGetChildren() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testMoveItemFolder() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("TestFolder", "This is a test folder");
        this.folder.move(testFolder);
        Assert.assertNotNull((String)"The moved item parent is null", (Object)this.folder.getParent());
        UnitTestUtil.testRelationship((WorkspaceItem)this.folder, (WorkspaceItem)testFolder);
    }
}

