/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.util.Extensions;
import org.gcube.common.homelibrary.util.FileSystemNameUtil;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;

public class WorkspaceToZipModelConverter {
    protected XStream xstream;

    protected XStream getXStream() {
        if (this.xstream != null) {
            return this.xstream;
        }
        this.xstream = new XStream();
        return this.xstream;
    }

    public ZipItem convert(WorkspaceItem workspaceItem) throws InternalErrorException, IOException {
        switch (workspaceItem.getType()) {
            case FOLDER: 
            case SHARED_FOLDER: {
                return this.convertFolder((WorkspaceFolder)workspaceItem);
            }
            case FOLDER_ITEM: {
                return this.convertFolderItem((FolderItem)workspaceItem);
            }
        }
        return null;
    }

    protected ZipFolder convertFolder(WorkspaceFolder workspaceFolder) throws InternalErrorException, IOException {
        String name = FileSystemNameUtil.cleanFileName(workspaceFolder.getName());
        String comment = workspaceFolder.getDescription();
        ZipFolder zipFolder = new ZipFolder(null, name, comment, new byte[0]);
        LinkedList<String> childrenNames = new LinkedList<String>();
        for (WorkspaceItem child : workspaceFolder.getChildren()) {
            ZipItem childItem = this.convert(child);
            if (childItem == null) continue;
            String childName = WorkspaceToZipModelConverter.getUniqueName(childrenNames, childItem.getName());
            childItem.setName(childName);
            childrenNames.add(childName);
            childItem.setParent(zipFolder);
            zipFolder.addChild(childItem);
        }
        return zipFolder;
    }

    protected ZipItem convertFolderItem(FolderItem folderItem) throws InternalErrorException, IOException {
        String cleanedItemName = FileSystemNameUtil.cleanFileName(folderItem.getName());
        String comment = folderItem.getDescription();
        FolderItemType type = folderItem.getFolderItemType();
        switch (type) {
            case EXTERNAL_IMAGE: 
            case EXTERNAL_FILE: 
            case EXTERNAL_PDF_FILE: {
                ExternalFile externalFile = (ExternalFile)folderItem;
                String mimeType = externalFile.getMimeType();
                String name = MimeTypeUtil.getNameWithExtension(cleanedItemName, mimeType);
                InputStream data = externalFile.getData();
                if (data != null) {
                    return new ZipFile(data, name, comment);
                }
                return null;
            }
            case REPORT_TEMPLATE: {
                ReportTemplate reportTemplate = (ReportTemplate)folderItem;
                String name = String.valueOf(cleanedItemName) + "." + Extensions.REPORT_TEMPLATE.getValue();
                InputStream data = reportTemplate.getData();
                if (data != null) {
                    return new ZipFile(data, name, comment);
                }
            }
            case REPORT: {
                Report report = (Report)folderItem;
                String name = String.valueOf(cleanedItemName) + "." + Extensions.REPORT.getValue();
                InputStream data = report.getData();
                if (data != null) {
                    return new ZipFile(data, name, comment);
                }
            }
            case EXTERNAL_URL: {
                ExternalUrl externalUrl = (ExternalUrl)folderItem;
                String name = String.valueOf(cleanedItemName) + ".xml";
                ByteArrayInputStream is = new ByteArrayInputStream(externalUrl.getUrl().getBytes());
                if (is != null) {
                    return new ZipFile(is, name, comment);
                }
            }
            case QUERY: {
                Query query = (Query)folderItem;
                String name = String.valueOf(cleanedItemName) + "." + Extensions.QUERY.getValue();
                ByteArrayInputStream is = new ByteArrayInputStream(query.getQuery().getBytes());
                if (is == null) break;
                return new ZipFile(is, name, comment);
            }
        }
        return null;
    }

    protected ZipFile convertImage(ZipFolder parent, Image image) throws InternalErrorException, IOException {
        String name = FileSystemNameUtil.cleanFileName(image.getName());
        name = MimeTypeUtil.getNameWithExtension(name, image.getMimeType());
        return new ZipFile(parent, image.getData(), name, "");
    }

    protected static String getUniqueName(List<String> usedNames, String name) {
        String candidatePrefix = name;
        String candidateSuffix = "";
        if (name.contains(".")) {
            int dotIndex = name.lastIndexOf(46);
            candidatePrefix = name.substring(0, dotIndex);
            candidateSuffix = name.substring(dotIndex);
        }
        String candidateName = String.valueOf(candidatePrefix) + candidateSuffix;
        int index = 1;
        while (usedNames.contains(candidateName)) {
            candidateName = String.valueOf(candidatePrefix) + "(" + index + ")" + candidateSuffix;
            ++index;
        }
        return candidateName;
    }
}

