/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipNewModelWriter {
    protected Logger logger = LoggerFactory.getLogger(ZipNewModelWriter.class);

    public File writeItem(ZipItem item, boolean skipRoot) throws IOException {
        File zipFile = File.createTempFile("zippping", "gz");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        this.addZipItem(out, item, skipRoot);
        out.close();
        return zipFile;
    }

    protected void addZipItem(ZipOutputStream zos, ZipItem item, boolean skipRoot) throws IOException {
        switch (item.getType()) {
            case FILE: {
                this.addZipFile(zos, (ZipFile)item, skipRoot);
                break;
            }
            case FOLDER: {
                this.addZipFolder(zos, (ZipFolder)item, skipRoot);
            }
        }
    }

    protected void addZipFolder(ZipOutputStream zos, ZipFolder folder, boolean skipRoot) throws IOException {
        ZipEntry zipEntry = new ZipEntry(folder.getPath() + File.separator);
        zos.putNextEntry(zipEntry);
        zos.closeEntry();
        for (ZipItem item : folder.getChildren()) {
            this.addZipItem(zos, item, skipRoot);
        }
    }

    protected void addZipFile(ZipOutputStream zos, ZipFile file, boolean skipRoot) throws IOException {
        ZipEntry zipEntry = new ZipEntry(file.getPath());
        zos.putNextEntry(zipEntry);
        try {
            ExternalFile externalFile = (ExternalFile)((Object)file);
            try (InputStream inputStream = externalFile.getData();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)zos);
            }
        }
        catch (Exception e) {
            this.logger.error(file.getName() + " will not be compressed.");
        }
        zos.closeEntry();
    }
}

