/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndentedVisitor {
    protected static final String DEFAULT_INDENTATION_STRING = "\t";
    protected SimpleDateFormat sdf;
    protected String indentationLevel = "";
    protected String indentationChar;
    protected PrintStream os;
    protected Logger logger = LoggerFactory.getLogger(IndentedVisitor.class);

    public IndentedVisitor() {
        this("", DEFAULT_INDENTATION_STRING, null);
    }

    public IndentedVisitor(String indentationLevel, String indentationChar, PrintStream os) {
        this.indentationLevel = indentationLevel;
        this.indentationChar = indentationChar;
        this.os = os;
        this.sdf = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
    }

    public void reset() {
        this.indentationLevel = "";
    }

    protected void println() {
        this.println("");
    }

    protected void println(String s) {
        if (this.os != null) {
            this.os.println(String.valueOf(this.indentationLevel) + s);
        }
        if (this.logger != null) {
            this.logger.trace(String.valueOf(this.indentationLevel) + s);
        }
    }

    protected void indent() {
        this.indentationLevel = String.valueOf(this.indentationLevel) + this.indentationChar;
    }

    protected void outdent() {
        this.indentationLevel = this.indentationLevel.substring(this.indentationChar.length());
    }
}

