package org.gcube.homelibrary.fs.model.items;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import org.gcube.homelibrary.fs.model.Metadata;
import org.gcube.homelibrary.fs.model.annotations.Attribute;
import org.gcube.homelibrary.fs.model.annotations.NodeAttribute;
import org.gcube.homelibrary.fs.model.annotations.RootNode;

@NoArgsConstructor
@Getter
@Setter
@RootNode({"nthl:gCubeItem"})
public class GCubeItem extends Item{

	@Attribute("hl:scopes")
	String[] scopes;
		
	@Attribute("hl:creator")
	String creator;
	
	@Attribute("hl:itemType")
	String itemType;
	
	@Attribute("hl:properties")
	String properties;
	
	@Attribute("hl:isShared")
	Boolean shared;
	
	@NodeAttribute("hl:property")
	Metadata property;
	
}
