package org.gcube.homelibrary.fs.model.items;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import org.gcube.homelibrary.fs.model.Metadata;
import org.gcube.homelibrary.fs.model.annotations.Attribute;
import org.gcube.homelibrary.fs.model.annotations.NodeAttribute;
import org.gcube.homelibrary.fs.model.annotations.RootNode;

@NoArgsConstructor
@Getter
@Setter
@RootNode({"nthl:workspaceSharedItem"})
public class SharedFolder extends FolderItem {

	@Attribute("hl:privilege")
	String privilege;
	
	@Attribute("hl:isVreFolder")
	Boolean vreFolder;
		
	@Attribute("hl:displayName")
	String displayName;  

	@NodeAttribute("hl:users")
	Metadata users;
	
	@NodeAttribute("hl:members")
	Metadata members;
}
