/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak.model;

import java.util.Base64;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.ObjectWriter;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.RefreshToken;
import org.gcube.common.keycloak.model.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ModelUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJSONString(Object object) {
        return ModelUtils.toJSONString(object, false);
    }

    public static String toJSONString(Object object, boolean prettyPrint) {
        ObjectWriter writer = prettyPrint ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
        try {
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("Cannot pretty print object", (Throwable)e);
            return null;
        }
    }

    private static byte[] getDecodedPayload(String value) {
        return ModelUtils.getBase64Decoded(ModelUtils.getEncodedPayload(value));
    }

    public static String getAccessTokenPayloadStringFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getAccessTokenPayloadStringFrom(tokenResponse, true);
    }

    public static String getAccessTokenPayloadStringFrom(TokenResponse tokenResponse, boolean prettyPrint) throws Exception {
        return ModelUtils.toJSONString(ModelUtils.getAccessTokenFrom(tokenResponse, Object.class), prettyPrint);
    }

    public static AccessToken getAccessTokenFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getAccessTokenFrom(tokenResponse, RefreshToken.class);
    }

    private static <T> T getAccessTokenFrom(TokenResponse tokenResponse, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(ModelUtils.getDecodedPayload(tokenResponse.getAccessToken()), clazz);
    }

    public static String getRefreshTokenPayloadStringFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getRefreshTokenPayloadStringFrom(tokenResponse, true);
    }

    public static String getRefreshTokenPayloadStringFrom(TokenResponse tokenResponse, boolean prettyPrint) throws Exception {
        return ModelUtils.toJSONString(ModelUtils.getRefreshTokenFrom(tokenResponse, Object.class), prettyPrint);
    }

    public static RefreshToken getRefreshTokenFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getRefreshTokenFrom(tokenResponse, RefreshToken.class);
    }

    private static <T> T getRefreshTokenFrom(TokenResponse tokenResponse, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(ModelUtils.getDecodedPayload(tokenResponse.getRefreshToken()), clazz);
    }

    protected static byte[] getBase64Decoded(String string) {
        return Base64.getDecoder().decode(string);
    }

    protected static String splitAndGet(String encodedJWT, int index) {
        String[] split = encodedJWT.split("\\.");
        if (split.length == 3) {
            return split[index];
        }
        return null;
    }

    public static String getEncodedHeader(String encodedJWT) {
        return ModelUtils.splitAndGet(encodedJWT, 0);
    }

    public static String getEncodedPayload(String encodedJWT) {
        return ModelUtils.splitAndGet(encodedJWT, 1);
    }

    public static String getEncodedSignature(String encodedJWT) {
        return ModelUtils.splitAndGet(encodedJWT, 2);
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

