/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.messaging.endpoints;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gcube.common.messaging.endpoints.Constants;
import org.gcube.common.messaging.endpoints.EndpointRetriever;
import org.gcube.common.scope.api.ScopeProvider;

public class ScheduledRetriever {
    EndpointRetriever retriever = null;
    ScheduledExecutorService scheduler = null;

    public ScheduledRetriever(String scope, long intervalTime) {
        this.retriever = new EndpointRetriever(scope);
        ScopeProvider.instance.set(scope);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleWithFixedDelay(this.retriever, 0L, intervalTime, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ScheduledRetriever.this.scheduler.shutdownNow();
            }
        });
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public ArrayList<String> getEndpoints() {
        return this.retriever.getEndpoints();
    }

    public String getFailoverEndpoint() {
        String endpointString = "";
        for (String endpoint : this.retriever.getEndpoints()) {
            if (endpointString.isEmpty()) {
                endpointString = endpointString + "(" + endpoint;
                continue;
            }
            endpointString = endpointString + "," + endpoint;
        }
        endpointString = endpointString + ")";
        return Constants.failoverPrefix + endpointString;
    }
}

