/**
 * University of Illinois/NCSA Open Source License
 *
 * Copyright (c) 2001,2002 The Board of Trustees of the University of Illinois
 * All rights reserved.
 *
 * Developed by:  Open Archives Initiative Metadata Harvesting Project
 *                University of Illinois at Urbana-Champaign
 *                http://oai.grainger.uiuc.edu/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 *  . Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimers.
 *  . Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimers in the
 *    documentation and/or other materials provided with the distribution.
 *  . Neither the names of Open Archives Initiative Metadata Harvesting
 *    Project, University of Illinois at Urbana-Champaign, nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this Software without specific prior written permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS WITH THE SOFTWARE.
 *
 * DC.Title:          OAIError
 * 
 * DC.Description:    Class representing an OAI Set
 * 
 * DC.Contributor:    Yuping Tseng, ytseng1@uiuc.edu, University og Illinois at Urbana-Champaign
 * DC.Contributor:    Tom Habing, thabing@uiuc.edu, University of Illinois at Urbana-Champaign
 * 
 * DC.Date.Modified:  Modtime: 5/13/02 11:58a 
 * 
 * DC:Rights:         University of Illinois/NCSA Open Source License
 * 
 * DC.Relation:       For more information see http://oai.grainger.uiuc.edu/
 * DC.Relation:       See http://www.openarchives.org/OAI/openarchivesprotocol.html
 * 
 */
package org.gcube.common;

/**
 * This class represents an OAI Error.
 */
public class OAIError {

 /**
  * Construct a empty object.
  */
 public OAIError() {
 }

 /**
  * Set the OAI 2.0 Error Code string
  */
 protected void frndSetCode(String c) {
    strCode = c;
 }

 /**
  * Set the OAI 2.0 Error Reason
  */
 protected void frndSetReason(String r) {
    strReason = r;
 }

 /**
  * Returns the OAI 2.0 Error Code string 
  */
 public String getCode() {
    return strCode;
 }

 /**
  * Returns the OAI 2.0 Error Reason. 
  */
 public String getReason() {
    return strReason;
 }

 private String strCode;
 private String strReason;
}
