/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.gcube.common.OAIException;
import org.gcube.common.OAIMetadataFormat;
import org.gcube.common.OAIRepository;
import org.gcube.common.OAIResumptionStream;
import org.w3c.dom.Node;

public class OAIMetadataFormatList {
    private OAIResumptionStream oaiResume;

    public boolean isListValid() {
        return this.oaiResume.isResponseValid();
    }

    protected void frndSetOAIResumptionStream(OAIResumptionStream rs) {
        this.oaiResume = rs;
    }

    public OAIMetadataFormat getCurrentItem() throws OAIException {
        OAIMetadataFormat s = new OAIMetadataFormat();
        Node node = this.oaiResume.getItem();
        if (node != null) {
            try {
                PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)this.getOAIRepository().getNamespaceNode());
                XPath xpath = new XPath("oai:metadataPrefix", null, (PrefixResolver)prefixResolver, 0, null);
                XPathContext xpathSupport = new XPathContext();
                int ctxtNode = xpathSupport.getDTMHandleFromNode(node);
                XObject list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                Node node2 = list.nodeset().nextNode();
                s.frndSetMetadataPrefix(node2.getFirstChild().getNodeValue());
                xpath = new XPath("oai:schema", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node2 = list.nodeset().nextNode();
                s.frndSetSchema(node2.getFirstChild().getNodeValue());
                xpath = new XPath("oai:metadataNamespace", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node2 = list.nodeset().nextNode();
                if (node2 != null) {
                    s.frndSetMetadataNamespace(node2.getFirstChild().getNodeValue());
                }
                s.frndSetValid(this.isListValid());
            }
            catch (TransformerException te) {
                throw new OAIException(14, te.getMessage());
            }
        } else {
            s = null;
        }
        return s;
    }

    public int getCurrentIndex() throws OAIException {
        return this.oaiResume.getIndex();
    }

    public int getCompleteSize() throws OAIException {
        return this.oaiResume.getCompleteSize();
    }

    public boolean moreItems() throws OAIException {
        return this.oaiResume.more();
    }

    public void moveNext() throws OAIException {
        this.oaiResume.moveNext();
    }

    public OAIRepository getOAIRepository() {
        return this.oaiResume.getRepository();
    }

    public void requery() throws OAIException {
        this.oaiResume.requery();
    }
}

