/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.oidc.keycloak.d4science;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.oidc.D4ScienceMappings;
import org.gcube.oidc.keycloak.KeycloakHelper;
import org.gcube.oidc.keycloak.KeycloakResourceCreationException;
import org.gcube.oidc.keycloak.d4science.ExportParser;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourceResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.xml.sax.SAXException;

public class ClientsCreatorFromExport {
    private KeycloakHelper kh;
    private Keycloak keycloak;
    private ExportParser exportParser;
    private String realm;

    public ClientsCreatorFromExport(String keycloakURL, String adminUsername, String adminPassword, String realm, FileInputStream exportFileFIS) throws SAXException, IOException, ParserConfigurationException, KeyManagementException, NoSuchAlgorithmException {
        this.exportParser = new ExportParser(exportFileFIS);
        this.kh = KeycloakHelper.getInstance(keycloakURL);
        this.keycloak = this.kh.newKeycloakAdmin(adminUsername, adminPassword);
        this.realm = realm;
    }

    public void createClients() throws KeycloakResourceCreationException, UnsupportedEncodingException {
        RealmResource realmResource = this.keycloak.realm(this.realm);
        for (String contextClient : this.exportParser.getAllContexts()) {
            System.out.println("adding client: " + contextClient);
            ClientResource client = this.kh.addClient(realmResource, contextClient, contextClient, contextClient + "'s context", "");
            HashMap<D4ScienceMappings.Role, RoleResource> roleMap = new HashMap<D4ScienceMappings.Role, RoleResource>();
            for (D4ScienceMappings.Role roleToAdd : D4ScienceMappings.Role.values()) {
                System.out.println("\tcreating role: " + roleToAdd);
                RoleResource role = this.kh.addRole(client, true, roleToAdd.asString(), roleToAdd.asString(), roleToAdd.asString() + " role", null);
                roleMap.put(roleToAdd, role);
            }
            HashMap<D4ScienceMappings.Scope, ScopeRepresentation> scopeMap = new HashMap<D4ScienceMappings.Scope, ScopeRepresentation>();
            for (D4ScienceMappings.Scope scopeToAdd : D4ScienceMappings.Scope.values()) {
                ScopeRepresentation scope = new ScopeRepresentation(scopeToAdd.asString());
                scopeMap.put(scopeToAdd, scope);
            }
            HashSet<ScopeRepresentation> resourceScopes = new HashSet<ScopeRepresentation>(scopeMap.values());
            String[] resources = this.getClientResources(contextClient);
            if (resources.length > 0) {
                for (String resourceToAdd : resources) {
                    System.out.println("\t\tadding resource: " + resourceToAdd);
                    String type = "urn:" + client.toRepresentation().getClientId() + ":resources:service";
                    ResourceResource resource = this.kh.addResource(client, resourceToAdd, type, resourceToAdd, false, resourceScopes, null);
                    this.configureClientResource(client, roleMap, resource.toRepresentation());
                }
                continue;
            }
            this.configureClientResource(client, roleMap, (ResourceRepresentation)client.authorization().resources().resources().get(0));
        }
    }

    private String[] getClientResources(String contextClient) {
        return new String[0];
    }

    private D4ScienceMappings.Role[] getInvolvedRoles(String resourceName) {
        return D4ScienceMappings.Role.values();
    }

    private Set<String> getRoleResourceScopes(String resourceName, D4ScienceMappings.Role role) {
        return Collections.emptySet();
    }

    protected void configureClientResource(ClientResource client, Map<D4ScienceMappings.Role, RoleResource> roleMap, ResourceRepresentation resource) throws KeycloakResourceCreationException {
        String resourceName = resource.getName();
        HashSet<String> policies = new HashSet<String>();
        for (D4ScienceMappings.Role role : this.getInvolvedRoles(resourceName)) {
            HashMap<String, Set<String>> policyClientRoles = new HashMap<String, Set<String>>();
            policyClientRoles.put(client.toRepresentation().getClientId(), Collections.singleton(roleMap.get(role).toRepresentation().getName()));
            System.out.println("\t\t\tadding role resource policy for role: " + role);
            Set<String> roleResourceScopes = this.getRoleResourceScopes(resourceName, role);
            PolicyResource newPR = this.kh.addRoleResourcePolicy(client, Collections.singleton(resourceName), roleResourceScopes, role.asString() + "_policy", Logic.POSITIVE, policyClientRoles);
            policies.add(newPR.toRepresentation().getName());
        }
        System.out.println("\t\t\tdeleting default js policy that is no more needed");
        client.authorization().policies().policy(client.authorization().policies().findByName("Default Policy").getId()).remove();
        System.out.println("\t\t\tcreating new permission for role policies with affirmative strategy");
        this.kh.addResourcePermission(client, Collections.singleton(resourceName), "Default Permission", DecisionStrategy.AFFIRMATIVE, policies);
        System.out.println("\t\t\tupdating the default permission on server");
    }

    public void deleteClients() {
        RealmResource realmResource = this.keycloak.realm(this.realm);
        for (String contextClient : this.exportParser.getAllContexts()) {
            System.out.println("- deleting: " + contextClient);
            try {
                this.kh.removeClient(realmResource, contextClient);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void mapUsersWithRolesToClients() throws UnsupportedEncodingException {
        RealmResource realmResource = this.keycloak.realm(this.realm);
        Map<String, Map<String, Set<String>>> usersToContextsAndRoles = this.exportParser.getAllUserContextsAndRoles();
        for (String userName : usersToContextsAndRoles.keySet()) {
            System.out.println("- user: " + userName);
            UserResource userResource = this.kh.findUser(realmResource, userName);
            if (userResource != null) {
                Map<String, Set<String>> userContextsAndRoles = usersToContextsAndRoles.get(userName);
                Iterator<String> iterator = userContextsAndRoles.keySet().iterator();
                while (iterator.hasNext()) {
                    String userContext;
                    String clientId = userContext = iterator.next();
                    System.out.println("\tcontext: " + userContext);
                    ClientResource clientResource = this.kh.findClient(realmResource, clientId);
                    if (clientResource != null) {
                        System.out.println("\t\tmapping default role: " + D4ScienceMappings.Role.MEMBER.asString());
                        this.kh.mapRoleTo(userResource, clientResource, D4ScienceMappings.Role.MEMBER.asString());
                        for (String role : userContextsAndRoles.get(userContext)) {
                            System.out.println("\t\tmapping role: " + role);
                            this.kh.mapRoleTo(userResource, clientResource, role);
                        }
                        continue;
                    }
                    System.err.println("Client not found on keycloak: " + userContext);
                }
            } else {
                System.err.println("User not found on keycloak: " + userName);
            }
            System.out.println();
        }
    }

    public ExportParser getExportParser() {
        return this.exportParser;
    }

    public static void main(String[] args) throws Exception {
        String serverURL = null;
        String username = null;
        String password = null;
        String realm = null;
        FileInputStream exportFileFIS = null;
        if (args.length < 5) {
            System.err.println("Missing params.\n\nUsage: " + ClientsCreatorFromExport.class.getName() + " [serverURL] [username] [password] [realm] [export_file]");
            return;
        }
        serverURL = args[0];
        username = args[1];
        password = args[2];
        realm = args[3];
        exportFileFIS = new FileInputStream(args[4]);
        ClientsCreatorFromExport creator = new ClientsCreatorFromExport(serverURL, username, password, realm, exportFileFIS);
        Date start = new Date();
        System.out.println("Start at " + start);
        System.out.println("Deleting clients...");
        creator.deleteClients();
        System.out.println("\n\n * * * Creating clients * * *");
        creator.createClients();
        System.out.println("\n\n * * * Mapping users to client's roles * * *");
        creator.mapUsersWithRolesToClients();
        Date end = new Date();
        System.out.println("Elapsed seconds: " + new Long(end.getTime() - start.getTime()).floatValue() / 1000.0f);
        System.out.println("\nClients: " + creator.getExportParser().getAllContexts().size());
        System.out.println("Users: " + creator.getExportParser().getAllUsers().size());
        Map<String, Map<String, Set<String>>> ucar = creator.getExportParser().getAllUserContextsAndRoles();
        float rolesPerUserMean = 0.0f;
        for (String user : ucar.keySet()) {
            for (String context : ucar.get(user).keySet()) {
                rolesPerUserMean += (float)(ucar.get(user).get(context).size() + 1);
            }
        }
        System.out.println("Roles per user mean: " + rolesPerUserMean / (float)creator.getExportParser().getAllUsers().size());
    }
}

