/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.smspersistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.persistence.GCUBERIFilePersistenceManager;
import org.gcube.common.core.persistence.GCUBERIPersistenceManager;
import org.gcube.common.core.persistence.GCUBERIPersistenceManagerProfile;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEServiceClient;
import org.gcube.common.core.utils.handlers.GCUBEServiceClientImpl;
import org.gcube.common.core.utils.handlers.GCUBEServiceHandler;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfByPropertyValueSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfInfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ByPropertyValueSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreatePropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.service.SMSPortType1ServiceAddressingLocator;

public class GCUBESMSPersistenceManager
extends GCUBERIFilePersistenceManager {
    protected GCUBEServiceClient client = new GCUBEServiceClientImpl();
    protected GCUBEUnrecoverableException failure;
    static GCUBEScope cachedScope;

    public GCUBESMSPersistenceManager(GCUBEServiceContext ctxt, GCUBERIPersistenceManagerProfile profile) {
        super(ctxt, profile);
    }

    protected void storeState() throws Exception {
        SMSFileWriter writer = new SMSFileWriter();
        writer.setHandled(this.client);
        writer.setName(this.ctxt.getName());
        writer.setLogger(this.logger);
        writer.run();
    }

    protected void loadState() throws GCUBERIPersistenceManager.StateNotFoundException, Exception {
        SMSFileReader reader = new SMSFileReader();
        reader.setHandled(this.client);
        reader.setName(this.ctxt.getName());
        reader.setLogger(this.logger);
        reader.run();
    }

    public class SMSFileWriter
    extends SMSHandler {
        protected byte[] bytes;

        public void run() throws Exception {
            int offset;
            File f = GCUBESMSPersistenceManager.this.getStateFile();
            this.bytes = new byte[(int)f.length()];
            FileInputStream is = new FileInputStream(f);
            int numRead = 0;
            for (offset = 0; offset < this.bytes.length && (numRead = is.read(this.bytes, offset, this.bytes.length - offset)) >= 0; offset += numRead) {
            }
            is.close();
            if (offset < this.bytes.length) {
                throw new GCUBEUnrecoverableException("state file " + f.getName() + " seems corrupt");
            }
            super.run();
        }

        protected void interact(EndpointReferenceType epr) throws Exception {
            InfoObjectDescription io = null;
            try {
                io = this.findIO(epr);
                this.updateIO(epr, io);
            }
            catch (GCUBERIPersistenceManager.StateNotFoundException e) {
                this.createIO(epr);
            }
            this.logger.info((Object)("stored remote state with SMS at " + epr.getAddress()));
        }

        protected void createIO(EndpointReferenceType epr) throws Exception {
            this.logger.trace((Object)("persisting state " + GCUBESMSPersistenceManager.this.ctxt.getInstance().getID() + ".backup"));
            SMSPortType1PortType stub = (SMSPortType1PortType)GCUBERemotePortTypeContext.getProxy((Remote)new SMSPortType1ServiceAddressingLocator().getSMSPortType1PortTypePort(epr), (GCUBEScope)((GCUBEScope)this.scopeMap.get(epr.getAddress())), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            CreateInfoObjectReferencesProperties properties = new CreateInfoObjectReferencesProperties();
            CreatePropertyDescription[] propDescription = new CreatePropertyDescription[1];
            CreatePropertyDescription descr = new CreatePropertyDescription();
            descr.setName("RunningInstanceID");
            descr.setValue(GCUBESMSPersistenceManager.this.ctxt.getInstance().getID());
            propDescription[0] = descr;
            properties.setProperties(propDescription);
            properties.setRawContent(this.bytes);
            properties.setName(GCUBESMSPersistenceManager.this.ctxt.getInstance().getID() + ".backup");
            stub.createInfoObjectWithContent(properties);
        }

        protected void updateIO(EndpointReferenceType epr, InfoObjectDescription io) throws Exception {
            this.logger.trace((Object)("updating persistent state " + io.getName()));
            SMSPortType1PortType stub = (SMSPortType1PortType)GCUBERemotePortTypeContext.getProxy((Remote)new SMSPortType1ServiceAddressingLocator().getSMSPortType1PortTypePort(epr), (GCUBEScope)((GCUBEScope)this.scopeMap.get(epr.getAddress())), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            FileTransferParameters params = new FileTransferParameters();
            params.setObjectID(io.getObjectID());
            params.setRawContent(this.bytes);
            stub.updateRawContent(params);
        }
    }

    public class SMSFileReader
    extends SMSHandler {
        protected void interact(EndpointReferenceType epr) throws Exception {
            InfoObjectDescription iop = this.findIO(epr);
            SMSPortType1PortType stub = (SMSPortType1PortType)GCUBERemotePortTypeContext.getProxy((Remote)new SMSPortType1ServiceAddressingLocator().getSMSPortType1PortTypePort(epr), (GCUBEScope)((GCUBEScope)this.scopeMap.get(epr.getAddress())), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            FileTransferParameters params = new FileTransferParameters();
            params.setObjectID(iop.getObjectID());
            params.setFileLocation("inmessage://");
            InfoObjectDescription description = stub.getInfoObject(params);
            FileOutputStream out = new FileOutputStream(GCUBESMSPersistenceManager.this.getStateFile());
            out.write(description.getRawContent());
            out.close();
        }
    }

    public abstract class SMSHandler
    extends GCUBEServiceHandler<GCUBEServiceClient> {
        protected static final String RIID_STORAGEPROPERTY_NAME = "RunningInstanceID";
        protected static final String BACKUP_IO_SUFFIX = ".backup";
        protected static final String STORAGE_MANAGEMENT_ENDPOINT = "gcube/contentmanagement/storagelayer/storagemanagementservice/porttype1";
        protected static final String STORAGE_MANAGEMENT_NAME = "StorageManagementService";
        protected static final String STORAGE_MANAGEMENT_CLASS = "ContentManagement";
        protected Map<AttributedURI, GCUBEScope> scopeMap = new HashMap<AttributedURI, GCUBEScope>();

        protected EndpointReferenceType getCachedEPR() {
            EndpointReferenceType epr = super.getCachedEPR();
            if (epr != null) {
                this.scopeMap.put(epr.getAddress(), cachedScope);
            }
            return epr;
        }

        protected void cacheEPR(EndpointReferenceType epr) {
            super.cacheEPR(epr);
            cachedScope = this.scopeMap.get(epr.getAddress());
        }

        protected List<EndpointReferenceType> findInstances() throws Exception {
            ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", STORAGE_MANAGEMENT_NAME)});
            lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", STORAGE_MANAGEMENT_CLASS)});
            for (GCUBEScope scope : GCUBESMSPersistenceManager.this.ctxt.getInstance().getScopes().values()) {
                for (GCUBERunningInstance instance : client.execute((ISQuery)lookupQuery, scope)) {
                    EndpointReferenceType epr = instance.getAccessPoint().getEndpoint(STORAGE_MANAGEMENT_ENDPOINT);
                    if (this.scopeMap.containsKey(epr.getAddress())) continue;
                    eprs.add(epr);
                    this.scopeMap.put(epr.getAddress(), scope);
                }
            }
            return eprs;
        }

        protected String getTargetPortTypeName() {
            return STORAGE_MANAGEMENT_NAME;
        }

        protected InfoObjectDescription findIO(EndpointReferenceType epr) throws Exception {
            this.logger.trace((Object)("looking for persistent state " + GCUBESMSPersistenceManager.this.ctxt.getInstance().getID() + BACKUP_IO_SUFFIX));
            SMSPortType1PortType stub = (SMSPortType1PortType)GCUBERemotePortTypeContext.getProxy((Remote)new SMSPortType1ServiceAddressingLocator().getSMSPortType1PortTypePort(epr), (GCUBEScope)this.scopeMap.get(epr.getAddress()), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            ByPropertyValueSelector selector = new ByPropertyValueSelector();
            selector.setName(RIID_STORAGEPROPERTY_NAME);
            selector.setValue(GCUBESMSPersistenceManager.this.ctxt.getInstance().getID());
            ArrayOfByPropertyValueSelector selectorArray = new ArrayOfByPropertyValueSelector();
            selectorArray.setSelectors(new ByPropertyValueSelector[]{selector});
            ArrayOfInfoObjectDescription descriptionArray = stub.retrieveObjectsHavingAllStorageProperties(selectorArray);
            if (descriptionArray == null || descriptionArray.getInfoObjectDescriptions() == null || descriptionArray.getInfoObjectDescriptions().length == 0) {
                throw new GCUBERIPersistenceManager.StateNotFoundException((GCUBERIPersistenceManager)GCUBESMSPersistenceManager.this);
            }
            return descriptionArray.getInfoObjectDescriptions(0);
        }
    }
}

