/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.queueManager.impl;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.ProducerFactory;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.QueueProducer;
import org.gcube.common.queueManager.utils.Common;

public class QueueProducerFactory
implements ProducerFactory {
    private static QueueProducerFactory instance = null;
    private ActiveMQConnectionFactory factory = null;
    private FactoryConfiguration config = null;

    public static synchronized QueueProducerFactory get(FactoryConfiguration configuration) throws JMSException {
        if (instance == null) {
            instance = new QueueProducerFactory(configuration);
        }
        return instance;
    }

    private QueueProducerFactory(FactoryConfiguration configuration) throws JMSException {
        this.config = configuration;
        this.factory = new ActiveMQConnectionFactory(configuration.getUser(), configuration.getPassword(), configuration.getBrokerEndpoint());
    }

    public QueueProducer getSubmitter(String topic, QueueType type) throws JMSException {
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        topic = Common.formTopic(this.config.getServiceClass(), this.config.getServiceName(), type, topic);
        Topic dest = null;
        switch (type) {
            case LOG: {
                dest = session.createTopic(topic);
                break;
            }
            default: {
                dest = session.createQueue(topic);
            }
        }
        MessageProducer publisher = session.createProducer((Destination)dest);
        return new QueueProducer(publisher, session, connection);
    }

    public void close() {
    }
}

