/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import org.gcube.common.quota.library.quotalist.Quota;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.ServiceQuota;
import org.gcube.common.quota.library.quotalist.StorageQuota;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.persistence.entities.QuotaEntity;
import org.gcube.common.quota.persistence.entities.ServiceQuotaEntity;
import org.gcube.common.quota.persistence.entities.StorageQuotaEntity;
import org.gcube.common.quota.service.exception.NotFoundQuotaExecption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QuotaDBPersistence {
    private static QuotaDBPersistence instance;
    private static Logger log;
    protected EntityManagerFactory emFactory = Persistence.createEntityManagerFactory((String)"quota_persistence");

    private QuotaDBPersistence() {
    }

    public static synchronized QuotaDBPersistence getInstance() {
        if (instance == null) {
            instance = new QuotaDBPersistence();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quota addQuota(Quota quota) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            ServiceQuotaEntity quotaEntity = null;
            if (quota.getQuotaType() == QuotaType.SERVICE) {
                quotaEntity = new ServiceQuotaEntity(quota.getContext(), quota.getIdentifier(), quota.getCallerType(), quota.getTimeInterval(), quota.getQuotaValue());
            }
            if (quota.getQuotaType() == QuotaType.STORAGE) {
                quotaEntity = new StorageQuotaEntity(quota.getContext(), quota.getIdentifier(), quota.getCallerType(), quota.getTimeInterval(), quota.getQuotaValue());
            }
            quota.setId(quotaEntity.getId());
            quota.setCreationTime(quotaEntity.getCreationTime());
            quota.setLastUpdateTime(quotaEntity.getLastUpdateTime());
            em.getTransaction().begin();
            em.persist((Object)quotaEntity);
            em.getTransaction().commit();
            Quota quota2 = quota;
            return quota2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuote(List<Quota> quote) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            em.getTransaction().begin();
            for (Quota quota : quote) {
                log.debug("addQuote quota string:{}", (Object)quota.toString());
                log.debug("addQuote:{}", (Object)quota.getQuotaType());
                log.debug("Type service:{}, storage:{}", (Object)QuotaType.SERVICE, (Object)QuotaType.STORAGE);
                ServiceQuotaEntity quotaEntity = null;
                if (quota.getQuotaType() == QuotaType.SERVICE) {
                    log.debug("addQuote:service");
                    ServiceQuota quotaService = (ServiceQuota)quota;
                    quotaEntity = new ServiceQuotaEntity(quotaService.getContext(), quotaService.getIdentifier(), quotaService.getCallerType(), quotaService.getServicePackageId(), quotaService.getTimeInterval(), quotaService.getQuotaValue(), quotaService.getAccessType());
                }
                if (quota.getQuotaType() == QuotaType.STORAGE) {
                    log.debug("addQuote:storage");
                    StorageQuota quotaStorage = (StorageQuota)quota;
                    quotaEntity = new StorageQuotaEntity(quotaStorage.getContext(), quotaStorage.getIdentifier(), quotaStorage.getCallerType(), quotaStorage.getTimeInterval(), quotaStorage.getQuotaValue());
                }
                em.persist(quotaEntity);
                em.flush();
            }
            em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quota getQuota(long quotaId) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            QuotaEntity quotaEntity = (QuotaEntity)em.find(QuotaEntity.class, (Object)quotaId);
            ServiceQuota quota = null;
            if (quotaEntity.getQuotaType().equals(QuotaType.SERVICE.toString())) {
                ServiceQuotaEntity quotaEntityService = (ServiceQuotaEntity)quotaEntity;
                quota = new ServiceQuota(quotaEntityService.getContext(), quotaEntityService.getIdentifier(), quotaEntityService.getCallerType(), quotaEntityService.getServicePackageId(), quotaEntityService.getTimeInterval(), quotaEntityService.getQuotaValue(), quotaEntityService.getAccessType());
            }
            if (quotaEntity.getQuotaType().equals(QuotaType.STORAGE.toString())) {
                StorageQuotaEntity quotaEntityStorage = (StorageQuotaEntity)quotaEntity;
                quota = new StorageQuota(quotaEntityStorage.getContext(), quotaEntityStorage.getIdentifier(), quotaEntityStorage.getCallerType(), quotaEntityStorage.getTimeInterval(), quotaEntityStorage.getQuotaValue());
            }
            quota.setId(quotaEntity.getId());
            quota.setCreationTime(quotaEntity.getCreationTime());
            quota.setLastUpdateTime(quotaEntity.getLastUpdateTime());
            ServiceQuota serviceQuota = quota;
            return serviceQuota;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuota(long quotaId) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            em.getTransaction().begin();
            QuotaEntity entity = (QuotaEntity)em.find(QuotaEntity.class, (Object)quotaId);
            if (entity != null) {
                em.remove((Object)entity);
            } else {
                log.warn("quote with id {} not found", (Object)quotaId);
            }
            em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Quota> getQuote(String context) throws NotFoundQuotaExecption {
        ArrayList<Quota> quoteToReturn;
        block9: {
            quoteToReturn = new ArrayList<Quota>();
            try (EntityManager em = this.emFactory.createEntityManager();){
                TypedQuery query = em.createNamedQuery("Quota.all", QuotaEntity.class);
                query.setParameter("context", (Object)context);
                if (query.getResultList().size() > 0) {
                    for (QuotaEntity qEntity : query.getResultList()) {
                        log.warn("getQuote---Entity list:" + qEntity.toString());
                        ServiceQuota quota = null;
                        if (qEntity.getQuotaType().equals(QuotaType.SERVICE.toString())) {
                            log.warn("getQuote entity---if service");
                            ServiceQuotaEntity quotaEntityService = (ServiceQuotaEntity)qEntity;
                            quota = new ServiceQuota(quotaEntityService.getContext(), quotaEntityService.getIdentifier(), quotaEntityService.getCallerType(), quotaEntityService.getServicePackageId(), quotaEntityService.getTimeInterval(), quotaEntityService.getQuotaValue(), quotaEntityService.getAccessType());
                        }
                        if (qEntity.getQuotaType().equals(QuotaType.STORAGE.toString())) {
                            log.warn("getQuote entity---if storage");
                            StorageQuotaEntity quotaEntityStorage = (StorageQuotaEntity)qEntity;
                            quota = new StorageQuota(quotaEntityStorage.getContext(), quotaEntityStorage.getIdentifier(), quotaEntityStorage.getCallerType(), quotaEntityStorage.getTimeInterval(), quotaEntityStorage.getQuotaValue());
                        }
                        quota.setId(qEntity.getId());
                        quota.setCreationTime(qEntity.getCreationTime());
                        quota.setLastUpdateTime(qEntity.getLastUpdateTime());
                        quoteToReturn.add((Quota)quota);
                        log.warn("getQuote---quoteToReturn:" + quota.toString());
                    }
                    break block9;
                }
                throw new NotFoundQuotaExecption("No quote found");
            }
        }
        return quoteToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quota getQuotaByIdentifier(String identifier) {
        ServiceQuota quotaToReturn = null;
        try (EntityManager em = this.emFactory.createEntityManager();){
            TypedQuery query = em.createNamedQuery("Quota.getByIdentifier", QuotaEntity.class);
            query.setParameter("identifier", (Object)identifier);
            for (QuotaEntity qEntity : query.getResultList()) {
                if (qEntity.getQuotaType().equals(QuotaType.SERVICE.toString())) {
                    ServiceQuotaEntity quotaEntityService = (ServiceQuotaEntity)qEntity;
                    quotaToReturn = new ServiceQuota(quotaEntityService.getContext(), quotaEntityService.getIdentifier(), quotaEntityService.getCallerType(), quotaEntityService.getTimeInterval(), quotaEntityService.getQuotaValue(), quotaEntityService.getAccessType());
                }
                if (qEntity.getQuotaType().equals(QuotaType.STORAGE.toString())) {
                    quotaToReturn = new StorageQuota(qEntity.getContext(), qEntity.getIdentifier(), qEntity.getCallerType(), qEntity.getTimeInterval(), qEntity.getQuotaValue());
                }
                quotaToReturn.setId(qEntity.getId());
                quotaToReturn.setCreationTime(qEntity.getCreationTime());
                quotaToReturn.setLastUpdateTime(qEntity.getLastUpdateTime());
            }
        }
        return quotaToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quota getQuotaSpecified(String identifier, String context, QuotaType quotaType, TimeInterval timeInterval, Double quotaValue) {
        log.debug("getQuotaSpecified init:{}");
        ServiceQuota quotaToReturn = null;
        try (EntityManager em = this.emFactory.createEntityManager();){
            TypedQuery query = em.createNamedQuery("Quota.getSpecified", QuotaEntity.class);
            query.setParameter("identifier", (Object)identifier);
            query.setParameter("context", (Object)context);
            query.setParameter("quotaType", (Object)quotaType.toString());
            query.setParameter("timeInterval", (Object)timeInterval);
            for (QuotaEntity qEntity : query.getResultList()) {
                if (qEntity.getQuotaType().equals(QuotaType.SERVICE.toString())) {
                    ServiceQuotaEntity quotaEntityService = (ServiceQuotaEntity)qEntity;
                    quotaToReturn = new ServiceQuota(quotaEntityService.getContext(), quotaEntityService.getIdentifier(), quotaEntityService.getCallerType(), quotaEntityService.getTimeInterval(), quotaEntityService.getQuotaValue(), quotaEntityService.getAccessType());
                }
                if (qEntity.getQuotaType().equals(QuotaType.STORAGE.toString())) {
                    quotaToReturn = new StorageQuota(qEntity.getContext(), qEntity.getIdentifier(), qEntity.getCallerType(), qEntity.getTimeInterval(), qEntity.getQuotaValue());
                }
                quotaToReturn.setId(qEntity.getId());
            }
        }
        return quotaToReturn;
    }

    static {
        log = LoggerFactory.getLogger(QuotaDBPersistence.class);
    }
}

