/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.service;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.quota.library.ServicePackages;
import org.gcube.common.quota.library.quotalist.ServicePackage;
import org.gcube.common.quota.persistence.QuotaPackageDBPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="quotaPackageManager")
public class QuotaPackageManager {
    private static Logger log = LoggerFactory.getLogger(QuotaPackageManager.class);
    QuotaPackageDBPersistence quotaPackagePersistence = QuotaPackageDBPersistence.getInstance();

    @POST
    @Consumes(value={"text/xml"})
    @Path(value="/insert/")
    public Response insertPackage(ServicePackage servicePackages) {
        try {
            log.info("insert service packages: {}", (Object)servicePackages.getServicePackagesAsString());
            this.quotaPackagePersistence.addPackage(servicePackages);
        }
        catch (Exception e) {
            log.error("error service packages", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error insert service packages: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/")
    public ServicePackages getPackages() {
        try {
            log.info("retrieving packages {}");
            return new ServicePackages(this.quotaPackagePersistence.getPackages());
        }
        catch (Exception e) {
            log.error("error retrieving list packages ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error retrieving list packages: " + e.getMessage())).type("text/plain").build());
        }
    }

    @GET
    @Path(value="/detail/{servicepackage_id}")
    @Produces(value={"text/xml"})
    public ServicePackage getDetailPackage(@NotNull @PathParam(value="servicepackage_id") long servicepackage_id) {
        try {
            log.info("retrieving detail package {}", (Object)servicepackage_id);
            ServicePackage servicePackage = this.quotaPackagePersistence.getPackage(servicepackage_id);
            log.info("ServicePackage getDetailPackage:{}", (Object)servicePackage);
            return servicePackage;
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error : " + e.getMessage())).type("text/plain").build());
        }
    }

    @DELETE
    @Path(value="/remove/{servicepackage_id}")
    public Response removePackage(@Null @PathParam(value="servicepackage_id") long servicepackageId) {
        try {
            log.info("removing Package with id {}", (Object)servicepackageId);
            this.quotaPackagePersistence.removePackage(servicepackageId);
        }
        catch (Exception e) {
            log.error("error removing package", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error removing package: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/removedetail/{servicepackagedetail_id}")
    public Response removePackageDetail(@Null @PathParam(value="servicepackagedetail_id") long servicepackagedetailId) {
        try {
            log.info("removing Package detail with id {}", (Object)servicepackagedetailId);
            this.quotaPackagePersistence.removePackageDetail(servicepackagedetailId);
        }
        catch (Exception e) {
            log.error("error removing package detail", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error removing package detail: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }
}

