/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.service;

import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.quota.check.QuotaUsage;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.persistence.QuotaDBPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="quotaStatus")
public class QuotaStatus {
    private static Logger log = LoggerFactory.getLogger(QuotaStatus.class);
    QuotaDBPersistence quotaPersistence = QuotaDBPersistence.getInstance();

    @GET
    @Path(value="/detail/{identifier}")
    @Produces(value={"application/xml"})
    public QuotaStorageStatus getQuotaStorageStatus(@NotNull @PathParam(value="identifier") String identifier, TimeInterval timeinterval) {
        QuotaStorageStatus quotaStorageStatus;
        QuotaUsage queryUsage = new QuotaUsage();
        try {
            log.info("retrieving quote for identifier:{} and time:{}", (Object)identifier, (Object)timeinterval.toString());
            quotaStorageStatus = queryUsage.selectStorageQuota(identifier, timeinterval);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error : " + e.getMessage())).type("text/plain").build());
        }
        return quotaStorageStatus;
    }
}

