/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.util;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.quota.util.DiscoveryServiceListUser;
import org.gcube.common.quota.util.ListUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryListUser {
    private static Logger log = LoggerFactory.getLogger(DiscoveryListUser.class);
    private List<String> listUser = null;

    public DiscoveryListUser(String context) {
        String token = SecurityTokenProvider.instance.get();
        log.debug("scope:{} ,tokend:{}", (Object)context, (Object)token);
        DiscoveryServiceListUser discoveryList = new DiscoveryServiceListUser(context);
        String urlService = discoveryList.getBasePath() + "=" + token;
        log.debug("service DiscoveryServiceListUser:" + urlService);
        String data = this.getJSON(urlService);
        log.debug("data read:{}", (Object)data);
        ListUser msg = (ListUser)new Gson().fromJson(data, ListUser.class);
        this.listUser = new ArrayList();
        this.listUser.add("lucio.lelii");
        this.listUser.add("alessandro.pieve");
        this.listUser.add("name.surname");
    }

    public List<String> getListUser() {
        return this.listUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJSON(String url) {
        HttpURLConnection c = null;
        try {
            URL u = new URL(url);
            c = (HttpURLConnection)u.openConnection();
            c.setRequestMethod("GET");
            c.setRequestProperty("Content-length", "0");
            c.setUseCaches(false);
            c.setAllowUserInteraction(false);
            c.connect();
            int status = c.getResponseCode();
            switch (status) {
                case 200: 
                case 201: {
                    BufferedReader br = new BufferedReader(new InputStreamReader(c.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        String line;
                        if ((line = br.readLine()) == null) {
                            br.close();
                            String string = sb.toString();
                            return string;
                        }
                        sb.append(line + "\n");
                    }
                }
            }
            return null;
        }
        catch (MalformedURLException ex) {
            log.error("MalformedURLException:{}", (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            log.error("IOException:{}", (Throwable)ex);
            return null;
        }
        finally {
            if (c != null) {
                try {
                    c.disconnect();
                }
                catch (Exception ex) {
                    log.error("Exception:{}", (Throwable)ex);
                }
            }
        }
    }
}

