package org.gcube.common.quota.check;

import java.util.Timer;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.quota.util.Constants;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAppManager implements ApplicationManager {

	private static Logger logger = LoggerFactory.getLogger(MyAppManager.class);

	ApplicationContext ctx = ContextProvider.get();

	Timer timer = null;
	
	@Override
	public void onInit() {
		//do something on init
		String token = SecurityTokenProvider.instance.get();
		String context = ScopeProvider.instance.get();

		QuotaCheckTask task = new QuotaCheckTask(context, token);
		timer = new Timer(true);
		timer.scheduleAtFixedRate(task,Constants.DELAY_SCHEDULE_CHECK,  Constants.TIME_SCHEDULE_CHECK);
		logger.info("QuotaCheckTask started in context {}", context);
	}

	@Override
	public void onShutdown() {
		//do something on shutdown
		SecurityTokenProvider.instance.get();
		ScopeProvider.instance.get();

		//TODO Insert a shutdown for timertask 
		timer.cancel();
	}
}
