package org.gcube.common.quota.check;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.common.quota.defaults.InformationSystemQuery;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotedefault.QuotaDefault;
import org.gcube.common.quota.service.exception.NotFoundQuotaExecption;
import org.gcube.common.quota.util.Constants;
import org.gcube.common.quota.util.DiscoveryListUser;
import org.gcube.common.quota.util.QuotaUsageServiceValue;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.gcube.common.quota.util.ReadFileProperties;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Quota check use a specify context 
 * Verify for context all quota inserted
 *  
 * @author Alessandro Pieve (alessandro.pieve@isti.cnr.it)
 *
 */
public class QuotaCheck {

	private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
	
	
	private String context=null;

	/**
	 * List quota for specify context
	 * @param context
	 * @throws NotFoundQuotaExecption
	 * @throws JSONException 
	 */
	public QuotaCheck(String context) throws NotFoundQuotaExecption{
		this.context=context;
	}
	public void getQuotaCheck() throws SQLException{
		
		log.info("QuotaCheck - init quota check task");

		QuotaCalculateUtil quotaUtility= new QuotaCalculateUtil(context);

		//create a list quota found on information System
		InformationSystemQuery informationSystemQuery =new InformationSystemQuery();
		log.debug("QuotaCheck - context:{}, setQuoteDefault:{}",context,informationSystemQuery.getListQuotaDefault());
		
		//set quota utility with quota default found on is
		quotaUtility.setQuoteDefault(informationSystemQuery.getListQuotaDefault());
		
		//TODO verificare se non ho una quota di default la vado a verificare in locale da un file di properties
		if (quotaUtility.getQuoteDefault()==null){
			log.debug("QuotaCheck - No quota default found on IS");
			ReadFileProperties fileQuota = new ReadFileProperties(Constants.FILE_PROPERTIES_QUOTA);
			quotaUtility.setQuoteDefault(fileQuota.getListQuotaDefault());
		}
		
		//list of user for specify context
		DiscoveryListUser discoveryListUser= new DiscoveryListUser(this.context);	
		log.debug("QuotaCheck - for context:{} , list user:{}",context,discoveryListUser.getListUser());
		
		//verify for each user if have a specify quota and Overwrite if exist and traduce into object for query accounting
		quotaUtility.verifyListUser(discoveryListUser.getListUser());
		log.debug("QuotaCheck - quotaUtility.getUsageToBeVerified():{}",quotaUtility.getUsageToBeVerified());
		
		
		/*
		
		
		//init accounting Persistence
		AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
		List<UsageValue> quoteChecked=new ArrayList<UsageValue>();
		try {
			quoteChecked=apq.getUsageValueQuotaTotal(quotaUtility.getUsageToBeVerified());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//log.debug("return quota usageToBeVerified:{}",usageToBeVerified);
		log.debug("return quota usage:{}",quoteChecked);
		
		//init a object quota usage
		QuotaUsage queryQuotaUsage =new QuotaUsage();
		
		//insert into db
		for(UsageValue usageIndex:quotaUtility.getUsageToBeVerified()){
			if (usageIndex.getClz()==QuotaType.STORAGE.getQuotaTypeClass()){
				log.debug("save quota storage identifier:{},temporalConstraint:{}",usageIndex.getIdentifier(),usageIndex.getTemporalConstraint());
				QuotaUsageStorageValue usageStorVal=(QuotaUsageStorageValue) usageIndex;
				queryQuotaUsage.insertStorageQuota(usageStorVal);
			}
			if (usageIndex.getClz()==QuotaType.SERVICE.getQuotaTypeClass()){
				log.debug("save quota service identifier:{},temporalConstraint:{}",usageIndex.getIdentifier(),usageIndex.getTemporalConstraint());
				QuotaUsageServiceValue usageSerVal=(QuotaUsageServiceValue) usageIndex;
				queryQuotaUsage.insertServiceQuota(usageSerVal);
			}
		}

		
*/
		
		//TODO completare la sezione che verifica se la quota e' sforata ed inserisce la policy 
		//log.debug("verify insert ");
		//QuotaStorageStatus quotaStorageStatus =queryQuotaUsage.selectStorageQuota("lucio.lelii",TimeInterval.FOREVER);
		//log.debug("verify insert quotaStorageStatus:{}",quotaStorageStatus.toString());
	
		/*
		log.info("Checked quota:{}",quoteChecked);
		for(UsageValue usageValue:quoteChecked){
			//set in quota entity usageValue
			quotaPersistence.setUsageQuota(quoteInsert.get(usageValue.getIdentifier()),usageValue.getD());		

			log.info("For identifier:{} quota/usage is:{}/{}",usageValue.getIdentifier(),quoteInsert.get(usageValue.getIdentifier()),usageValue.getD());
			if (usageValue.getD()>quoteInsert.get(usageValue.getIdentifier()).getQuotaValue()){
				insertPolicyBlock(quoteInsert.get(usageValue.getIdentifier()));
			}
		}
		log.info("QuotaCheck end");
		 */
		
		//Verificare anche il servizio rest per inserimento quota e gestione 
		//verificare se il sistema gira su piu' scope (come si gestisce lo storage totale ( che e' senza scope ? )
		//verificare se nel db presenti altre quote che vadano ad aggiungersi o sovrascrivere la quota di default
		
		//prevedere un sistema di alert e/o di monitoraggio
	}





}
