/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.conditions.ColumnsPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AndrewsCurves
extends PlotterAdapter {
    private static final long serialVersionUID = -471636460650394557L;
    static final int MAX_NUMBER_OF_COLUMNS = 1000;
    private static final int NUMBER_OF_SUPPORT_POINTS = 100;
    private transient DataTable dataTable;
    private List<LinePlot> lines = new LinkedList<LinePlot>();
    private double minY;
    private double maxY;
    private int colorColumn = -1;
    private double minColor = 0.0;
    private double maxColor = 1.0;

    public AndrewsCurves() {
        this.setBackground(Color.white);
    }

    public AndrewsCurves(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(1000);
    }

    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    public String getPlotName() {
        return "Color";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.lines.clear();
        int numberOfColumns = this.dataTable.getNumberOfColumns() - this.dataTable.getNumberOfSpecialColumns();
        if (this.colorColumn >= 0) {
            --numberOfColumns;
            if (this.dataTable.isSpecial(this.colorColumn)) {
                ++numberOfColumns;
            }
        }
        int supportPoints = 1;
        if (numberOfColumns < 100) {
            supportPoints = (int)Math.ceil(100.0 / (double)numberOfColumns);
        }
        int totalNumberOfPoints = (numberOfColumns - 1) * supportPoints + 1;
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            double color;
            this.minY = Double.POSITIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            this.minColor = Double.POSITIVE_INFINITY;
            this.maxColor = Double.NEGATIVE_INFINITY;
            Iterator<DataTableRow> s = this.dataTable.iterator();
            if (this.colorColumn != -1) {
                while (s.hasNext()) {
                    DataTableRow row = s.next();
                    color = row.getValue(this.colorColumn);
                    this.minColor = MathFunctions.robustMin(this.minColor, color);
                    this.maxColor = MathFunctions.robustMax(this.maxColor, color);
                }
            }
            for (DataTableRow row : this.dataTable) {
                color = 1.0;
                if (this.colorColumn != -1) {
                    color = this.getColorProvider().getPointColorValue(this.dataTable, row, this.colorColumn, this.minColor, this.maxColor);
                }
                double[] linePlotData = this.getFourierTransform(row, totalNumberOfPoints);
                int d = 0;
                while (d < linePlotData.length) {
                    this.minY = Math.min(this.minY, linePlotData[d]);
                    this.maxY = Math.max(this.maxY, linePlotData[d]);
                    ++d;
                }
                this.lines.add(new LinePlot(linePlotData, color));
            }
        }
    }

    private double[] getFourierTransform(DataTableRow row, int totalNumberOfPoints) {
        double[] result = new double[totalNumberOfPoints];
        double time = -Math.PI;
        double timeDelta = Math.PI * 2 / (double)result.length;
        int t = 0;
        while (t < result.length) {
            int counter = 1;
            int columnCounter = 0;
            int i = 0;
            while (i < row.getNumberOfValues()) {
                if (i != this.colorColumn && !this.dataTable.isSpecial(i)) {
                    if (columnCounter == 0) {
                        result[t] = row.getValue(i) / Math.sqrt(2.0);
                    } else if ((columnCounter + 1) % 2 == 0) {
                        int n = t;
                        result[n] = result[n] + row.getValue(i) * Math.sin(time * (double)counter);
                    } else {
                        int n = t;
                        result[n] = result[n] + row.getValue(i) * Math.cos(time * (double)counter);
                        ++counter;
                    }
                    ++columnCounter;
                }
                ++i;
            }
            time += timeDelta;
            ++t;
        }
        return result;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintAndrewsPlot(g);
    }

    public void paintAndrewsPlot(Graphics g) {
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D translated = (Graphics2D)g.create();
        translated.translate(20, 20);
        this.prepareData();
        if (!(this.colorColumn == -1 || Double.isInfinite(this.minColor) || Double.isInfinite(this.maxColor) || !this.dataTable.isNominal(this.colorColumn) && this.minColor == this.maxColor || this.lines.size() <= 0)) {
            this.drawLegend(g, this.dataTable, this.colorColumn);
        }
        if (this.lines.size() == 0) {
            translated.drawString("No plots selected.", 0, 0);
        } else {
            g.setColor(Color.black);
            this.draw(translated, pixWidth, pixHeight);
        }
        translated.dispose();
    }

    private void draw(Graphics g, int pixWidth, int pixHeight) {
        Rectangle2D.Double frame = new Rectangle2D.Double(0.0, 0.0, pixWidth, pixHeight);
        ((Graphics2D)g).draw(frame);
        this.drawLines(g, pixWidth, pixHeight);
    }

    private void drawLines(Graphics g, int width, int height) {
        Iterator<LinePlot> l = this.lines.iterator();
        while (l.hasNext()) {
            this.drawLine(g, l.next(), width, height);
        }
    }

    private void drawLine(Graphics g, LinePlot line, int width, int height) {
        double[] data = line.lineData;
        float columnDistance = (float)width / (float)(data.length - 1);
        GeneralPath path = new GeneralPath();
        float xPos = 0.0f;
        path.moveTo(xPos, this.normY(data[0]) * (float)height);
        int d = 1;
        while (d < data.length) {
            path.lineTo(xPos += columnDistance, this.normY(data[d]) * (float)height);
            ++d;
        }
        Color color = Color.RED;
        if (this.colorColumn != -1) {
            color = this.getColorProvider().getPointColor(line.color);
        }
        g.setColor(color);
        ((Graphics2D)g).draw(path);
    }

    private float normY(double y) {
        return (float)((y - this.minY) / (this.maxY - this.minY));
    }

    private static class LinePlot {
        private double[] lineData;
        private double color;

        private LinePlot(double[] lineData, double color) {
            this.lineData = lineData;
            this.color = color;
        }
    }
}

