/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.graphs.GraphCreator;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.graphs.LayoutSelection;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphRenderer
extends AbstractRenderer {
    public static final String PARAMETER_LAYOUT = "layout";
    public static final String PARAMETER_SHOW_NODE_LABELS = "show_node_labels";
    public static final String PARAMETER_SHOW_EDGE_LABELS = "show_edge_labels";
    public static final String RENDERER_NAME = "Graph View";
    public static final String[] LAYOUTS = new String[]{"ISOM", "KKLayout", "FRLayout", "Circle", "Spring", "Tree", "Balloon"};

    public abstract GraphCreator<String, String> getGraphCreator(Object var1, IOContainer var2);

    @Override
    public String getName() {
        return RENDERER_NAME;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        GraphCreator<String, String> graphCreator = this.getGraphCreator(renderable, ioContainer);
        if (graphCreator != null) {
            return new GraphViewer<String, String>(graphCreator);
        }
        return new JLabel("No exampleset provided for similarity calculation.");
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        GraphCreator<String, String> graphCreator = this.getGraphCreator(renderable, ioContainer);
        if (graphCreator != null) {
            GraphViewer<String, String> viewer = new GraphViewer<String, String>(graphCreator);
            LayoutSelection<String, String> layoutSelection = viewer.getLayoutSelection();
            try {
                layoutSelection.setSelectedItem(this.getParameter(PARAMETER_LAYOUT));
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            viewer.setPaintEdgeLabels(this.getParameterAsBoolean(PARAMETER_SHOW_EDGE_LABELS));
            viewer.setPaintVertexLabels(this.getParameterAsBoolean(PARAMETER_SHOW_NODE_LABELS));
            return viewer;
        }
        return new DefaultReadable("No exampleset provided for similarity calculation");
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory layoutType = new ParameterTypeStringCategory(PARAMETER_LAYOUT, "Indicates which layout should be used for graph rendering.", LAYOUTS, LAYOUTS[0]);
        layoutType.setEditable(false);
        types.add(layoutType);
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_NODE_LABELS, "Indicates if the labels of the node should be visualized.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_EDGE_LABELS, "Indicates if the labels of the edges should be visualized.", true));
        return types;
    }
}

