/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DimensionalityReducerModel
extends AbstractModel {
    private static final long serialVersionUID = 1036161585615738268L;
    private int dimensions;
    private double[][] p;

    protected DimensionalityReducerModel(ExampleSet exampleSet, double[][] p, int dimensions) {
        super(exampleSet);
        this.p = p;
        this.dimensions = dimensions;
    }

    public ExampleSet apply(ExampleSet es) throws OperatorException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        int i = 0;
        while (i < this.dimensions) {
            Attribute att = AttributeFactory.createAttribute("d" + i, 4);
            attributes.add(att);
            ++i;
        }
        Iterator<AttributeRole> s = es.getAttributes().specialAttributes();
        while (s.hasNext()) {
            AttributeRole role = s.next();
            Attribute att = (Attribute)role.getAttribute().clone();
            specialAttributes.put(att, role.getSpecialName());
            attributes.add(att);
        }
        MemoryExampleTable et = new MemoryExampleTable(attributes);
        ArrayList<DoubleArrayDataRow> dataRows = new ArrayList<DoubleArrayDataRow>();
        int i2 = 0;
        for (Example oldExample : es) {
            DoubleArrayDataRow dr = new DoubleArrayDataRow(new double[this.dimensions + specialAttributes.size()]);
            int j = 0;
            while (j < this.dimensions) {
                dr.set((Attribute)attributes.get(j), this.p[i2][j]);
                ++j;
            }
            for (Attribute att : specialAttributes.keySet()) {
                dr.set(att, oldExample.getValue(es.getAttributes().getSpecial(att.getName())));
            }
            dataRows.add(dr);
            ++i2;
        }
        et.readExamples(new ListDataRowReader(dataRows.iterator()));
        ExampleSet examples = et.createExampleSet(specialAttributes);
        return examples;
    }

    public String getName() {
        return "Dimensionality Reduction";
    }

    public String toString() {
        return "This model reduces the number of dimensions to " + this.dimensions + ".";
    }
}

