/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.SOMDimensionalityReduction;
import com.rapidminer.tools.math.som.KohonenNet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class SOMDimensionalityReductionModel
extends AbstractModel {
    private static final long serialVersionUID = 7249399167412746295L;
    private KohonenNet net;
    private int dimensions;

    protected SOMDimensionalityReductionModel(ExampleSet exampleSet, KohonenNet net, int dimensions) {
        super(exampleSet);
        this.net = net;
        this.dimensions = dimensions;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int i = 0;
        while (i < this.dimensions) {
            attributes.add(AttributeFactory.createAttribute("SOM_" + i, 2));
            ++i;
        }
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        HashMap<Attribute, String> newSpecialAttributes = new HashMap<Attribute, String>();
        while (s.hasNext()) {
            AttributeRole role = s.next();
            Attribute specialAttribute = role.getAttribute();
            Attribute newAttribute = (Attribute)specialAttribute.clone();
            attributes.add(newAttribute);
            newSpecialAttributes.put(newAttribute, role.getSpecialName());
        }
        MemoryExampleTable newDataTable = new MemoryExampleTable(attributes);
        for (Example currentExample : exampleSet) {
            int[] coords = this.net.apply(SOMDimensionalityReduction.getDoubleArrayFromExample(currentExample));
            double[] exampleData = new double[attributes.size()];
            int i2 = 0;
            while (i2 < this.dimensions) {
                exampleData[i2] = coords[i2];
                ++i2;
            }
            s = exampleSet.getAttributes().specialAttributes();
            i2 = this.dimensions;
            while (s.hasNext()) {
                exampleData[i2++] = currentExample.getValue(s.next().getAttribute());
            }
            DoubleArrayDataRow newRow = new DoubleArrayDataRow(exampleData);
            newDataTable.addDataRow(newRow);
        }
        return newDataTable.createExampleSet(newSpecialAttributes);
    }

    public String getName() {
        return "SOM Dimensionality Reduction Model";
    }

    public String toString() {
        return "Transforms the input data into a new data set with " + this.dimensions + " dimensions.";
    }
}

