/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.Kernel;

public class KernelSigmoid
extends Kernel {
    private static final long serialVersionUID = 5056175330389455467L;
    private double a = 1.0;
    private double b = 0.0;

    public KernelSigmoid(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public KernelSigmoid() {
    }

    public double eval(double[] x, double[] y) {
        double prod = 0.0;
        int i = 0;
        while (i < x.length) {
            prod += x[i] * y[i];
            ++i;
        }
        prod = this.a * prod + this.b;
        double e1 = Math.exp(prod);
        double e2 = Math.exp(-prod);
        return (e1 - e2) / (e1 + e2);
    }

    public String toString() {
        return "sigmoid kernel [a = " + this.a + ", b = " + this.b + "]";
    }
}

