/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.gui.properties.ConfigureParameterOptimizationDialogCreator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeParameterValue;
import com.rapidminer.parameter.value.ParameterValueGrid;
import com.rapidminer.parameter.value.ParameterValueList;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterIteratingOperatorChain
extends OperatorChain {
    public static final String PARAMETER_PARAMETERS = "parameters";
    public static final String PARAMETER_VALUES = "values";
    public static final int VALUE_MODE_DISCRETE = 0;
    public static final int VALUE_MODE_CONTINUOUS = 1;
    private static final int PARAMETER_VALUES_ARRAY_LENGTH_RANGE = 2;
    private static final int PARAMETER_VALUES_ARRAY_LENGTH_GRID = 3;
    private static final int PARAMETER_VALUES_ARRAY_LENGTH_SCALED_GRID = 4;

    public ParameterIteratingOperatorChain(OperatorDescription description) {
        super(description);
    }

    public abstract int getParameterValueMode();

    public List<ParameterValues> parseParameterValues(List<String[]> parameterList) throws OperatorException {
        LinkedList<ParameterValues> parameterValuesList = new LinkedList<ParameterValues>();
        for (String[] parameterListEntry : parameterList) {
            ParameterValues parameterValues;
            block20: {
                String[] parameter = parameterListEntry[0].split("\\.");
                if (parameter.length != 2) {
                    throw new UserError((Operator)this, 907, parameterListEntry[0]);
                }
                Operator operator = this.getProcess().getOperator(parameter[0]);
                if (operator == null) {
                    throw new UserError((Operator)this, 109, parameter[0]);
                }
                ParameterType parameterType = operator.getParameters().getParameterType(parameter[1]);
                if (parameterType == null) {
                    throw new UserError((Operator)this, 906, String.valueOf(parameter[0]) + "." + parameter[1]);
                }
                String parameterValuesString = parameterListEntry[1];
                parameterValues = null;
                try {
                    double max;
                    double min;
                    String[] parameterValuesArray;
                    int startIndex = parameterValuesString.indexOf("[");
                    if (startIndex >= 0) {
                        int endIndex = parameterValuesString.indexOf("]");
                        if (endIndex > startIndex) {
                            parameterValuesArray = parameterValuesString.substring(startIndex + 1, endIndex).trim().split("[;:,]");
                            switch (parameterValuesArray.length) {
                                case 2: {
                                    min = Double.parseDouble(parameterValuesArray[0]);
                                    max = Double.parseDouble(parameterValuesArray[1]);
                                    parameterValues = new ParameterValueRange(operator, parameterType, min, max);
                                    break block20;
                                }
                                case 3: {
                                    min = Double.parseDouble(parameterValuesArray[0]);
                                    max = Double.parseDouble(parameterValuesArray[1]);
                                    double stepSize = Double.parseDouble(parameterValuesArray[2]);
                                    if (stepSize == 0.0) {
                                        throw new Exception("step size of 0 is not allowed");
                                    }
                                    if (min <= max + stepSize) {
                                        throw new Exception("end value must at least be as large as start value plus step size");
                                    }
                                    parameterValues = new ParameterValueGrid(operator, parameterType, min, max, stepSize);
                                    break block20;
                                }
                                case 4: {
                                    min = Double.parseDouble(parameterValuesArray[0]);
                                    max = Double.parseDouble(parameterValuesArray[1]);
                                    int steps = Integer.parseInt(parameterValuesArray[2]);
                                    if (steps == 0) {
                                        throw new Exception("step size of 0 is not allowed");
                                    }
                                    String scaleName = parameterValuesArray[3];
                                    parameterValues = new ParameterValueGrid(operator, parameterType, min, max, steps, scaleName);
                                    break block20;
                                }
                                default: {
                                    throw new Exception("parameter values string could not be parsed (too many arguments)");
                                }
                            }
                        }
                        throw new Exception("']' was missing");
                    }
                    int colonIndex = parameterValuesString.indexOf(":");
                    if (colonIndex >= 0) {
                        parameterValuesArray = parameterValuesString.trim().split(":");
                        if (parameterValuesArray.length != 2) {
                            throw new Exception("wrong parameter range format");
                        }
                        min = Double.parseDouble(parameterValuesArray[0]);
                        max = Double.parseDouble(parameterValuesArray[1]);
                        parameterValues = new ParameterValueRange(operator, parameterType, min, max);
                    } else if (parameterValuesString.length() != 0) {
                        String[] values = parameterValuesString.split(",");
                        parameterValues = new ParameterValueList(operator, parameterType, values);
                    }
                }
                catch (Throwable e) {
                    throw new UserError((Operator)this, 116, parameterListEntry[0], "Unknown parameter value specification format: '" + parameterListEntry[1] + "'. Error: " + e.getMessage());
                }
            }
            if (parameterValues == null) continue;
            parameterValuesList.add(parameterValues);
        }
        return parameterValuesList;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public boolean shouldAddNonConsumedInput() {
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeConfiguration(ConfigureParameterOptimizationDialogCreator.class, this);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_PARAMETERS, "The parameters.", new ParameterTypeParameterValue(PARAMETER_VALUES, "The value specifications for the parameters."));
        type.setHidden(true);
        types.add(type);
        return types;
    }
}

