/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteDiscretization
extends PreprocessingOperator {
    public static final String PARAMETER_SIZE_OF_BINS = "size_of_bins";
    public static final String PARAMETER_RANGE_NAME_TYPE = "range_name_type";
    public static final String PARAMETER_SORTING_DIRECTION = "sorting_direction";
    public static final String PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS = "automatic_number_of_digits";
    public static final String PARAMETER_NUMBER_OF_DIGITS = "number_of_digits";

    public AbsoluteDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        exampleSet.recalculateAllAttributeStatistics();
        int sizeOfBins = this.getParameterAsInt(PARAMETER_SIZE_OF_BINS);
        int numberOfBins = exampleSet.size() / sizeOfBins;
        int numberOfExamples = exampleSet.size();
        if (numberOfBins * sizeOfBins < numberOfExamples) {
            ++numberOfBins;
        }
        HashMap<Attribute, double[]> ranges = new HashMap<Attribute, double[]>();
        int sortingDirection = this.getParameterAsInt(PARAMETER_SORTING_DIRECTION);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            SortedExampleSet sortedSet = new SortedExampleSet(exampleSet, attribute, sortingDirection);
            double[] binRange = new double[numberOfBins];
            int i = 0;
            while (i < numberOfBins - 1) {
                int offset = (i + 1) * sizeOfBins - 1;
                double infimum = sortedSet.getExample(offset).getValue(attribute);
                double supremum = sortedSet.getExample(++offset).getValue(attribute);
                while (infimum == supremum && offset < numberOfExamples) {
                    supremum = sortedSet.getExample(offset).getValue(attribute);
                    ++offset;
                }
                if (sortingDirection == 1) {
                    binRange[numberOfBins - 2 - i] = (infimum + supremum) / 2.0;
                } else {
                    binRange[i] = (infimum + supremum) / 2.0;
                }
                ++i;
            }
            binRange[numberOfBins - 1] = Double.POSITIVE_INFINITY;
            ranges.put(attribute, binRange);
        }
        int numberOfDigits = -1;
        if (!this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS)) {
            numberOfDigits = this.getParameterAsInt(PARAMETER_NUMBER_OF_DIGITS);
        }
        model.setRanges(ranges, "range", this.getParameterAsInt(PARAMETER_RANGE_NAME_TYPE), numberOfDigits);
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_SIZE_OF_BINS, "Defines the number of examples which should be used for each bin.", 1, Integer.MAX_VALUE, false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_DIRECTION, "Indicates if the values should be sorted in increasing or decreasing order.", SortedExampleSet.SORTING_DIRECTIONS, 1));
        types.add(new ParameterTypeCategory(PARAMETER_RANGE_NAME_TYPE, "Indicates if long range names including the limits should be used.", DiscretizationModel.RANGE_NAME_TYPES, 0));
        type = new ParameterTypeBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, "Indicates if the number of digits should be automatically determined for the range names.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_RANGE_NAME_TYPE, false, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_DIGITS, "The minimum number of digits used for the interval names (-1: determine minimal number automatically).", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, false, false));
        types.add(type);
        return types;
    }
}

