/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.similarity.SimilarityMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterDensityEvaluator
extends Operator {
    private double avgClusterSim = 0.0;

    public ClusterDensityEvaluator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("clusterdensity", "Avg. within cluster similarity/distance", false){

            public double getDoubleValue() {
                return ClusterDensityEvaluator.this.avgClusterSim;
            }
        });
    }

    public InputDescription getInputDescription(Class cls) {
        if (SimilarityMeasure.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        if (ClusterModel.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ClusterModel.class, SimilarityMeasure.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        DistanceMeasure measure = this.getInput(SimilarityMeasure.class).getDistanceMeasure();
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        ClusterModel clusterModel = this.getInput(ClusterModel.class);
        PerformanceVector performance = null;
        try {
            performance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        if (performance == null) {
            performance = new PerformanceVector();
        }
        double[] avgWithinClusterSims = this.withinClusterAvgSim(clusterModel, exampleSet, measure);
        this.avgClusterSim = avgWithinClusterSims[clusterModel.getNumberOfClusters()];
        EstimatedPerformance withinClusterSim = null;
        withinClusterSim = measure.isDistance() ? new EstimatedPerformance("Avg. within cluster distance", this.avgClusterSim, 1, true) : new EstimatedPerformance("Avg. within cluster similarity", this.avgClusterSim, 1, false);
        performance.addCriterion(withinClusterSim);
        int i = 0;
        while (i < clusterModel.getNumberOfClusters()) {
            EstimatedPerformance withinSingleClusterSim = null;
            withinSingleClusterSim = measure.isDistance() ? new EstimatedPerformance("Avg. within cluster distance for cluster " + clusterModel.getCluster(i).getClusterId(), avgWithinClusterSims[i], 1, true) : new EstimatedPerformance("Avg. within cluster similarity for cluster " + clusterModel.getCluster(i).getClusterId(), avgWithinClusterSims[i], 1, false);
            performance.addCriterion(withinSingleClusterSim);
            ++i;
        }
        return new IOObject[]{performance};
    }

    private double[] withinClusterAvgSim(ClusterModel clusterModel, ExampleSet exampleSet, DistanceMeasure measure) {
        Attribute id = exampleSet.getAttributes().getId();
        double[] result = new double[clusterModel.getNumberOfClusters() + 1];
        for (Example example : exampleSet) {
            int clusterIndex = id.isNominal() ? clusterModel.getClusterIndexOfId(example.getValueAsString(id)) : clusterModel.getClusterIndexOfId(example.getValue(id));
            for (Example compExample : exampleSet) {
                int compClusterIndex;
                int n = compClusterIndex = id.isNominal() ? clusterModel.getClusterIndexOfId(compExample.getValueAsString(id)) : clusterModel.getClusterIndexOfId(compExample.getValue(id));
                if (clusterIndex != compClusterIndex) continue;
                double v = measure.isDistance() ? measure.calculateDistance(example, compExample) : measure.calculateSimilarity(example, compExample);
                int n2 = clusterIndex;
                result[n2] = result[n2] + v;
            }
        }
        double sum = 0.0;
        int totalCount = 0;
        int i = 0;
        while (i < clusterModel.getNumberOfClusters()) {
            sum += result[i];
            int clusterSize = clusterModel.getCluster(i).getNumberOfExamples();
            int n = i;
            double d = result[n] / (double)clusterSize;
            result[n] = d;
            result[i] = d;
            totalCount += clusterSize;
            ++i;
        }
        result[clusterModel.getNumberOfClusters()] = sum / (double)totalCount;
        return result;
    }
}

