/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BallTreeNode<T> {
    private double[] center;
    private double radius;
    private T value;
    private BallTreeNode<T> leftChild;
    private BallTreeNode<T> rightChild;

    public BallTreeNode(double[] center, double radius, T value) {
        this.center = center;
        this.radius = radius;
        this.value = value;
    }

    public BallTreeNode<T> getLeftChild() {
        return this.leftChild;
    }

    public void setLeftChild(BallTreeNode<T> leftChild) {
        this.leftChild = leftChild;
    }

    public BallTreeNode<T> getRightChild() {
        return this.rightChild;
    }

    public void setRightChild(BallTreeNode<T> rightChild) {
        this.rightChild = rightChild;
    }

    public double[] getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void replaceChild(BallTreeNode<T> replaceNode, BallTreeNode<T> replacementNode) {
        if (this.leftChild == replaceNode) {
            this.leftChild = replacementNode;
        }
        if (this.rightChild == replaceNode) {
            this.rightChild = replacementNode;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        double[] dArray = this.center;
        int n = this.center.length;
        int n2 = 0;
        while (n2 < n) {
            double centerDouble = dArray[n2];
            buffer.append(String.valueOf(centerDouble) + "  ");
            ++n2;
        }
        buffer.append("]  ");
        buffer.append(this.radius);
        return buffer.toString();
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean isLeaf() {
        return this.getLeftChild() == null && this.getRightChild() == null;
    }

    public boolean hasTwoChilds() {
        return this.getLeftChild() != null & this.getRightChild() != null;
    }

    public BallTreeNode<T> getChild() {
        if (this.getLeftChild() != null) {
            return this.getLeftChild();
        }
        return this.getRightChild();
    }

    public void setChild(BallTreeNode<T> node) {
        if (!this.hasLeftChild()) {
            this.setLeftChild(node);
        } else {
            this.setRightChild(node);
        }
    }

    public T getStoreValue() {
        return this.value;
    }

    public boolean hasLeftChild() {
        return this.leftChild != null;
    }

    public boolean hasRightChild() {
        return this.rightChild != null;
    }
}

