/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.NonGraphicalRenderer;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableModelTableRenderer
extends NonGraphicalRenderer {
    public static final String RENDERER_NAME = "Table View";
    public static final String PARAMETER_MIN_ROW = "min_row";
    public static final String PARAMETER_MAX_ROW = "max_row";
    public static final String PARAMETER_MIN_COLUMN = "min_column";
    public static final String PARAMETER_MAX_COLUMN = "max_column";

    @Override
    public String getName() {
        return RENDERER_NAME;
    }

    public abstract TableModel getTableModel(Object var1, IOContainer var2);

    public boolean isSortable() {
        return true;
    }

    public boolean isColumnMovable() {
        return true;
    }

    public boolean isAutoresize() {
        return true;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        TableModel tableModel = this.getTableModel(renderable, ioContainer);
        if (tableModel != null) {
            return new ExtendedJScrollPane(new ExtendedJTable(this.getTableModel(renderable, ioContainer), this.isSortable(), this.isColumnMovable(), this.isAutoresize()));
        }
        return new JLabel("No visualization possible for table.");
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer) {
        TableModel tableModel = this.getTableModel(renderable, ioContainer);
        if (tableModel != null) {
            return new DefaultTableable(tableModel, this);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MIN_ROW, "Indicates the first row number which should be rendered.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_ROW, "Indicates the last row number which should be rendered.", 1, Integer.MAX_VALUE, Integer.MAX_VALUE));
        types.add(new ParameterTypeInt(PARAMETER_MIN_COLUMN, "Indicates the first column number which should be rendered.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_COLUMN, "Indicates the last column number which should be rendered.", 1, Integer.MAX_VALUE, Integer.MAX_VALUE));
        return types;
    }

    public static class DefaultTableable
    implements Tableable {
        private TableModel model;
        private int minRow = 0;
        private int maxRow = Integer.MAX_VALUE;
        private int minColumn = 0;
        private int maxColumn = Integer.MAX_VALUE;

        public DefaultTableable(TableModel model, Renderer renderer) {
            this.model = model;
            try {
                Object minRowO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MIN_ROW);
                this.minRow = minRowO != null ? Integer.valueOf(minRowO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.minRow = 0;
            }
            try {
                Object maxRowO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MAX_ROW);
                this.maxRow = maxRowO != null ? Integer.valueOf(maxRowO.toString()) - 1 : Integer.MAX_VALUE;
            }
            catch (UndefinedParameterError e) {
                this.maxRow = Integer.MAX_VALUE;
            }
            try {
                Object minColO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MIN_COLUMN);
                this.minColumn = minColO != null ? Integer.valueOf(minColO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.minColumn = 0;
            }
            try {
                Object maxColO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MAX_COLUMN);
                this.maxColumn = maxColO != null ? Integer.valueOf(maxColO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.maxColumn = 0;
            }
        }

        public String getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex + this.minColumn);
        }

        public String getCell(int row, int column) {
            String value = this.model.getValueAt(row + this.minRow, column + this.minColumn).toString();
            if (Number.class.isAssignableFrom(this.model.getColumnClass(column))) {
                return Tools.formatIntegerIfPossible(Double.valueOf(value));
            }
            return value;
        }

        public int getColumnNumber() {
            int maxC = this.maxColumn;
            if (this.maxColumn >= this.model.getColumnCount()) {
                maxC = this.model.getColumnCount() - 1;
            }
            return maxC - this.minColumn + 1;
        }

        public int getRowNumber() {
            int maxR = this.maxRow;
            if (this.maxRow >= this.model.getRowCount()) {
                maxR = this.model.getRowCount() - 1;
            }
            return maxR - this.minRow + 1;
        }

        public void prepareReporting() {
        }

        public void finishReporting() {
        }

        public boolean isFirstLineHeader() {
            return false;
        }

        public boolean isFirstColumnHeader() {
            return false;
        }
    }
}

